/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class PotionFluidType
extends FluidType {
    public static final ResourceLocation POTION_STILL_RL = new ResourceLocation("travelersbackpack", "block/potion_still");
    public static final ResourceLocation POTION_FLOW_RL = new ResourceLocation("travelersbackpack", "block/potion_flow");

    public PotionFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public Component getDescription(FluidStack stack) {
        return Component.m_237115_((String)this.getDescriptionId(stack));
    }

    public String getDescriptionId(FluidStack stack) {
        return PotionUtils.m_43577_((CompoundTag)stack.getTag()).m_43492_("item.minecraft.potion.effect.");
    }

    public String getDescriptionId() {
        return "item.minecraft.potion.effect.empty";
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final int EMPTY_COLOR = 0xF800F8;

            public int getTintColor() {
                return -524040;
            }

            public int getTintColor(FluidStack stack) {
                return 1.getTintColor(stack.getTag()) | 0xFF000000;
            }

            private static int getTintColor(@Nullable CompoundTag tag) {
                if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
                    return tag.m_128451_("CustomPotionColor");
                }
                if (PotionUtils.m_43577_((CompoundTag)tag) == Potions.f_43598_) {
                    return 0xF800F8;
                }
                return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag));
            }

            public ResourceLocation getStillTexture() {
                return POTION_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return POTION_FLOW_RL;
            }
        });
    }
}

