/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.jei;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.compat.jei.BlockEntityTransferHandler;
import com.tiviacz.travelersbackpack.compat.jei.BlockEntityTransferInfo;
import com.tiviacz.travelersbackpack.compat.jei.ItemTransferHandler;
import com.tiviacz.travelersbackpack.compat.jei.ItemTransferInfo;
import com.tiviacz.travelersbackpack.compat.jei.JeiGhostIngredientHandler;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.Internal;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public class TravelersBackpackPlugin
implements IModPlugin {
    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new ItemTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new ItemTransferInfo()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlockEntityTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new BlockEntityTransferInfo()), RecipeTypes.CRAFTING);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BackpackSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackSettingsScreen>(){

            public List<Rect2i> getGuiExtraAreas(BackpackSettingsScreen screen) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                screen.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
                    int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
                    ret.add(new Rect2i(size[0], size[1], size[2], size[3]));
                });
                return ret;
            }
        });
        registration.addGuiContainerHandler(BackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackScreen>(){

            public List<Rect2i> getGuiExtraAreas(BackpackScreen screen) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                ret.add(new Rect2i(s[0], s[1], s[2], s[3]));
                screen.m_6702_().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                    int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                    ret.add(new Rect2i(size[0], size[1], size[2], size[3]));
                });
                screen.upgradeSlots.forEach(slot -> {
                    if (!slot.isHidden()) {
                        int[] size = slot.getUpgradeSlotSizeAndPos();
                        ret.add(new Rect2i(size[0], size[1], size[2], size[3]));
                    }
                });
                return ret;
            }
        });
        registration.addGhostIngredientHandler(BackpackScreen.class, (IGhostIngredientHandler)new JeiGhostIngredientHandler());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("travelersbackpack", "travelersbackpack");
    }
}

