/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape BACKPACK_TANKS_SHAPE_NORTH = Stream.of(Block.m_49796_((double)4.1, (double)0.8, (double)7.1, (double)11.9, (double)7.8, (double)11.0), Block.m_49796_((double)4.1, (double)7.8, (double)7.1, (double)11.9, (double)10.1, (double)11.0), Block.m_49796_((double)4.1, (double)0.0, (double)7.9, (double)11.9, (double)0.8, (double)11.0), Block.m_49796_((double)4.9, (double)2.4, (double)5.5, (double)11.1, (double)7.1, (double)7.1), Block.m_49796_((double)10.4, (double)1.6, (double)11.0, (double)11.2, (double)7.8, (double)11.8), Block.m_49796_((double)4.8, (double)1.6, (double)11.0, (double)5.6, (double)7.8, (double)11.8), Block.m_49796_((double)1.0, (double)0.0, (double)7.4, (double)4.1, (double)7.8, (double)10.5), Block.m_49796_((double)11.9, (double)0.0, (double)7.4, (double)15.0, (double)7.8, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_TANKS_SHAPE_EAST = Stream.of(Block.m_49796_((double)5.0, (double)0.8, (double)4.1, (double)8.9, (double)7.8, (double)11.9), Block.m_49796_((double)5.0, (double)7.8, (double)4.1, (double)8.9, (double)10.1, (double)11.9), Block.m_49796_((double)5.0, (double)0.0, (double)4.1, (double)5.9, (double)0.8, (double)11.9), Block.m_49796_((double)8.9, (double)2.4, (double)4.9, (double)10.5, (double)7.1, (double)11.1), Block.m_49796_((double)4.2, (double)1.6, (double)4.8, (double)5.0, (double)7.8, (double)5.6), Block.m_49796_((double)4.2, (double)1.6, (double)10.4, (double)5.0, (double)7.8, (double)11.2), Block.m_49796_((double)5.5, (double)0.0, (double)1.0, (double)8.6, (double)7.8, (double)4.1), Block.m_49796_((double)5.5, (double)0.0, (double)11.9, (double)8.6, (double)7.8, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BACKPACK_TANKS_SHAPE_SOUTH = Stream.of(Block.m_49796_((double)4.1, (double)0.8, (double)5.0, (double)11.9, (double)7.8, (double)8.9), Block.m_49796_((double)4.1, (double)7.8, (double)5.0, (double)11.9, (double)10.1, (double)8.9), Block.m_49796_((double)4.1, (double)0.0, (double)5.0, (double)11.9, (double)0.8, (double)8.1), Block.m_49796_((double)4.9, (double)2.4, (double)8.9, (double)11.1, (double)7.1, (double)10.5), Block.m_49796_((double)4.8, (double)1.6, (double)4.2, (double)5.6, (double)7.8, (double)5.0), Block.m_49796_((double)10.4, (double)1.6, (double)4.2, (double)11.2, (double)7.8, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)5.5, (double)4.1, (double)7.8, (double)8.6), Block.m_49796_((double)11.9, (double)0.0, (double)5.5, (double)15.0, (double)7.8, (double)8.6)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_TANKS_SHAPE_WEST = Stream.of(Block.m_49796_((double)7.1, (double)0.8, (double)4.1, (double)11.0, (double)7.8, (double)11.9), Block.m_49796_((double)7.1, (double)7.8, (double)4.1, (double)11.0, (double)10.1, (double)11.9), Block.m_49796_((double)7.9, (double)0.0, (double)4.1, (double)11.0, (double)0.8, (double)11.9), Block.m_49796_((double)5.5, (double)2.4, (double)4.9, (double)7.1, (double)7.1, (double)11.1), Block.m_49796_((double)11.0, (double)1.6, (double)10.4, (double)11.8, (double)7.8, (double)11.2), Block.m_49796_((double)11.0, (double)1.6, (double)4.8, (double)11.8, (double)7.8, (double)5.6), Block.m_49796_((double)7.4, (double)0.0, (double)1.0, (double)10.5, (double)7.8, (double)4.1), Block.m_49796_((double)7.4, (double)0.0, (double)11.9, (double)10.5, (double)7.8, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_SHAPE_NORTH = Stream.of(Block.m_49796_((double)4.1, (double)0.8, (double)7.1, (double)11.9, (double)7.8, (double)11.0), Block.m_49796_((double)4.1, (double)7.8, (double)7.1, (double)11.9, (double)10.1, (double)11.0), Block.m_49796_((double)4.1, (double)0.0, (double)7.9, (double)11.9, (double)0.8, (double)11.0), Block.m_49796_((double)4.9, (double)2.4, (double)5.5, (double)11.1, (double)7.1, (double)7.1), Block.m_49796_((double)10.4, (double)1.6, (double)11.0, (double)11.2, (double)7.8, (double)11.8), Block.m_49796_((double)4.8, (double)1.6, (double)11.0, (double)5.6, (double)7.8, (double)11.8)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_SHAPE_EAST = Stream.of(Block.m_49796_((double)5.0, (double)0.8, (double)4.1, (double)8.9, (double)7.8, (double)11.9), Block.m_49796_((double)5.0, (double)7.8, (double)4.1, (double)8.9, (double)10.1, (double)11.9), Block.m_49796_((double)5.0, (double)0.0, (double)4.1, (double)5.9, (double)0.8, (double)11.9), Block.m_49796_((double)8.9, (double)2.4, (double)4.9, (double)10.5, (double)7.1, (double)11.1), Block.m_49796_((double)4.2, (double)1.6, (double)4.8, (double)5.0, (double)7.8, (double)5.6), Block.m_49796_((double)4.2, (double)1.6, (double)10.4, (double)5.0, (double)7.8, (double)11.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_SHAPE_SOUTH = Stream.of(Block.m_49796_((double)4.1, (double)0.8, (double)5.0, (double)11.9, (double)7.8, (double)8.9), Block.m_49796_((double)4.1, (double)7.8, (double)5.0, (double)11.9, (double)10.1, (double)8.9), Block.m_49796_((double)4.1, (double)0.0, (double)5.0, (double)11.9, (double)0.8, (double)8.1), Block.m_49796_((double)4.9, (double)2.4, (double)8.9, (double)11.1, (double)7.1, (double)10.5), Block.m_49796_((double)4.8, (double)1.6, (double)4.2, (double)5.6, (double)7.8, (double)5.0), Block.m_49796_((double)10.4, (double)1.6, (double)4.2, (double)11.2, (double)7.8, (double)5.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape BACKPACK_SHAPE_WEST = Stream.of(Block.m_49796_((double)7.1, (double)0.8, (double)4.1, (double)11.0, (double)7.8, (double)11.9), Block.m_49796_((double)7.1, (double)7.8, (double)4.1, (double)11.0, (double)10.1, (double)11.9), Block.m_49796_((double)7.9, (double)0.0, (double)4.1, (double)11.0, (double)0.8, (double)11.9), Block.m_49796_((double)5.5, (double)2.4, (double)4.9, (double)7.1, (double)7.1, (double)11.1), Block.m_49796_((double)11.0, (double)1.6, (double)10.4, (double)11.8, (double)7.8, (double)11.2), Block.m_49796_((double)11.0, (double)1.6, (double)4.8, (double)11.8, (double)7.8, (double)5.6)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public TravelersBackpackBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60913_(1.0f, Float.MAX_VALUE).m_280606_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean hasTanks = false;
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            hasTanks = backpackBlockEntity.getWrapper().tanksVisible();
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_SOUTH;
                }
                yield BACKPACK_SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_EAST;
                }
                yield BACKPACK_SHAPE_EAST;
            }
            case Direction.WEST -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_WEST;
                }
                yield BACKPACK_SHAPE_WEST;
            }
            default -> hasTanks ? BACKPACK_TANKS_SHAPE_NORTH : BACKPACK_SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ((BackpackBlockEntity)level.m_7702_(pos)).openBackpack(player, (BackpackBlockEntity)level.m_7702_(pos), pos);
        return InteractionResult.CONSUME;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            if (state.m_60734_() == ModBlocks.MELON_TRAVELERS_BACKPACK.get()) {
                BackpackAbilities.melonAbility(blockEntity2);
            }
            if (player.m_7500_()) {
                ItemStack stack = blockEntity2.toItemStack(this.m_5456_().m_7968_());
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            }
            blockEntity2.removeSleepingBag(level, (Direction)state.m_61143_((Property)FACING));
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            super.m_6810_(state, level, pos, newState, isMoving);
            if (blockentity instanceof BackpackBlockEntity) {
                level.m_46717_(pos, state.m_60734_());
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level.m_7702_(pos) == null || !((blockEntity = level.m_7702_(pos)) instanceof BackpackBlockEntity)) {
            return 0;
        }
        BackpackBlockEntity backpack = (BackpackBlockEntity)blockEntity;
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < backpack.getWrapper().getStorage().getSlots(); ++j) {
            ItemStack itemstack = backpack.getWrapper().getStorage().getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(backpack.getWrapper().getStorage().getSlotLimit(j), backpack.getWrapper().getStorage().getStackInSlot(j).m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)backpack.getWrapper().getStorage().getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BackpackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ || (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get() == false || !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, state.m_60734_().m_5456_().m_7968_()) ? null : BackpackDeathHelper.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.BACKPACK.get(), BackpackBlockEntity::tick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            BackpackAbilities.ABILITIES.animateTick(backpackBlockEntity, state, level, pos, rand);
        }
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity blockEntity;
        if (state.m_60734_() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get() && (blockEntity = getter.m_7702_(pos)) instanceof BackpackBlockEntity && (backpackBlockEntity = (BackpackBlockEntity)blockEntity).getWrapper().isAbilityEnabled()) {
            return 15;
        }
        return super.m_6378_(state, getter, pos, direction);
    }

    public boolean m_7899_(BlockState state) {
        return state.m_60734_() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get();
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pOldState.m_60713_(pState.m_60734_()) && pState.m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public void m_6861_(BlockState state, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (state.m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.m_6861_(state, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public void tryAbsorbWater(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> {
                if (backpackBlockEntity.getWrapper().isAbilityEnabled() && (tanksUpgrade.getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity() || tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) && this.removeWaterBreadthFirstSearch(level, pos, (TanksUpgrade)tanksUpgrade)) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49990_.m_49966_()));
                }
            });
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level level, BlockPos pos, TanksUpgrade tanksUpgrade) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = level.m_8055_(blockpos1);
                FluidState fluidstate = level.m_6425_(blockpos1);
                if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                if (blockstate.m_60734_() instanceof BucketPickup && !((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)level, blockpos1, blockstate).m_41619_()) {
                    ++i;
                    if (tanksUpgrade.getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity()) {
                        tanksUpgrade.getLeftTank().fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else if (tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) {
                        tanksUpgrade.getRightTank().fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    level.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(blockpos1) : null;
                TravelersBackpackBlock.m_49892_((BlockState)blockstate, (LevelAccessor)level, (BlockPos)blockpos1, (BlockEntity)blockentity);
                level.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_(), 1);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            blockEntity2.toItemStack(stack);
        }
        return stack;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity blockEntity;
        if (state.m_60734_() == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get() && (blockEntity = world.m_7702_(pos)) instanceof BackpackBlockEntity && (backpackBlockEntity = (BackpackBlockEntity)blockEntity).getWrapper().isAbilityEnabled()) {
            return 5.0f;
        }
        return super.getEnchantPowerBonus(state, world, pos);
    }

    public static void registerDispenserBehaviour() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> DispenserBlock.m_52672_((ItemLike)((ItemLike)holder.get()), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior()));
    }
}

