/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import owmii.powah.Powah;
import owmii.powah.network.IPacket;
import owmii.powah.network.packet.NextEnergyConfigPacket;
import owmii.powah.network.packet.NextRedstoneModePacket;
import owmii.powah.network.packet.SetChannelPacket;
import owmii.powah.network.packet.SwitchGenModePacket;

public final class Network {
    private static final ResourceLocation PACKET_ID = Powah.id("packet");
    private static int nextId = 0;
    private static final List<Constructor<? extends IPacket>> decoders = new ArrayList<Constructor<? extends IPacket>>();
    private static final IdentityHashMap<Class<?>, Integer> packetIds = new IdentityHashMap();

    public static <T extends IPacket> void register(Class<T> packetClass) {
        Constructor<T> ctor = null;
        try {
            ctor = packetClass.getConstructor(FriendlyByteBuf.class);
            decoders.add(ctor);
            packetIds.put(packetClass, nextId);
            ++nextId;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to register packet", e);
        }
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PACKET_ID, (buf, ctx) -> {
            int packetId = buf.m_130242_();
            try {
                IPacket packet = decoders.get(packetId).newInstance(buf);
                ctx.queue(() -> packet.handle(ctx.getPlayer()));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to construct packet of type " + packetId, e);
            }
        });
        Network.register(NextEnergyConfigPacket.class);
        Network.register(NextRedstoneModePacket.class);
        Network.register(SetChannelPacket.class);
        Network.register(SwitchGenModePacket.class);
    }

    private static FriendlyByteBuf encodePacket(IPacket packet) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(packetIds.get(packet.getClass()).intValue());
        packet.encode(buf);
        return buf;
    }

    public static void toServer(IPacket msg) {
        NetworkManager.sendToServer((ResourceLocation)PACKET_ID, (FriendlyByteBuf)Network.encodePacket(msg));
    }

    public static void toClient(IPacket msg, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)PACKET_ID, (FriendlyByteBuf)Network.encodePacket(msg));
        }
    }
}

