/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.gui.ScreenReadableScroll;
import ovh.corail.tombstone.gui.ScreenRitualFlute;
import ovh.corail.tombstone.helper.CustomToast;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessagePlayerPreference;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.particle.ParticleMagicCircle;
import ovh.corail.tombstone.particle.ParticleRounding;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.proxy.IProxy;

@OnlyIn(value=Dist.CLIENT)
public final class ClientProxy
implements IProxy {
    private boolean isConfigDirty = false;
    private PlayerPreference lastPlayerPreference;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void produceGraveSmoke(Level level, int count, double x, double y, double z, int color) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (mc.f_91063_.m_109153_().m_90583_().m_82531_(x, y, z) <= 1024.0 && Helper.RANDOM.nextBoolean()) {
            IntStream.range(0, count).forEach(i -> mc.f_91061_.m_107344_((Particle)new ParticleGraveSmoke((ClientLevel)level, x + level.f_46441_.m_188583_(), y, z + level.f_46441_.m_188583_(), (double)(level.f_46441_.m_188501_() - 0.5f) * 0.01, 0.0, (double)(level.f_46441_.m_188501_() - 0.5f) * 0.01).withColor(color)));
        }
    }

    @Override
    public void produceShield(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.m_91104_() || mc.f_91073_ == null || entity.m_20159_() || entity.m_5803_())) {
            mc.f_91061_.m_107344_((Particle)new ParticleRounding(mc.f_91073_, entity, ParticleRounding.Type.SHIELD));
        }
    }

    @Override
    public void producePray(LivingEntity entity, int type, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && mc.f_91073_ != null) {
            mc.f_91061_.m_107344_((Particle)new ParticleRounding(mc.f_91073_, entity, ParticleRounding.Type.byId(type), predic));
            mc.f_91061_.m_107344_((Particle)new ParticleCasting(mc.f_91073_, entity, predic));
        }
    }

    @Override
    public void produceBoneShield(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.m_91104_() || mc.f_91073_ == null || entity.m_20159_() || entity.m_5803_())) {
            mc.f_91061_.m_107344_((Particle)new ParticleRounding(mc.f_91073_, entity, ParticleRounding.Type.BONE));
        }
    }

    @Override
    public void produceGraveSoul(Level level, BlockPos pos, SoulType soulType, int part) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && mc.f_91063_.m_109153_().m_90583_().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 1024.0) {
            mc.f_91061_.m_107344_((Particle)new ParticleGraveSoul((ClientLevel)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.85, (double)pos.m_123343_() + 0.5, soulType.ordinal(), part));
        }
    }

    @Override
    public void produceParticleCasting(CastingType castingType, LivingEntity entity, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && entity != null && mc.f_91073_ != null) {
            if (((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
                mc.f_91061_.m_107344_((Particle)new ParticleMagicCircle(mc.f_91073_, castingType, entity, predic));
            }
            mc.f_91061_.m_107344_((Particle)new ParticleCasting(mc.f_91073_, entity, predic));
        }
    }

    @Override
    public void produceParticleCasting(double radius, int color, LivingEntity entity, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && entity != null && mc.f_91073_ != null) {
            mc.f_91061_.m_107344_((Particle)new ParticleCasting(mc.f_91073_, entity, predic).withColor(color));
        }
    }

    @Override
    public void produceSmokeColumn(Level level, Vec3 vec) {
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ParticleSmokeColumn((ClientLevel)level, vec.f_82479_, vec.f_82480_, vec.f_82481_));
    }

    @Override
    public void markConfigDirty() {
        this.isConfigDirty = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isConfigDirty) {
            this.isConfigDirty = false;
            if (Minecraft.m_91087_().f_91074_ == null || this.lastPlayerPreference == null) {
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
            } else if (this.lastPlayerPreference.hasChangedFromConfig()) {
                LangKey.MESSAGE_SYNC_TO_SERVER.sendMessage((Player)Minecraft.m_91087_().f_91074_, new Object[0]);
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
                PacketHandler.sendToServer(new SMessagePlayerPreference(this.lastPlayerPreference, false));
            }
        }
    }

    @Override
    public PlayerPreference initPlayerPreference() {
        this.lastPlayerPreference = PlayerPreference.fromClientConfig();
        return this.lastPlayerPreference;
    }

    @Override
    public Optional<Level> getClientWorld() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_);
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void openKnowledgeScreen() {
        @Nullable LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> Minecraft.m_91087_().m_91152_((Screen)new ScreenKnowledge(player, (ITBCapability)cap)));
        }
    }

    @Override
    public void openReadableScrollScreen(String id, int part) {
        Minecraft.m_91087_().m_91152_((Screen)new ScreenReadableScroll(id, part));
    }

    @Override
    public void openRitualFluteScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ScreenRitualFlute());
    }

    @Override
    public void addToast(ItemStack initial, ItemStack added, Component description) {
        CustomToast.INSTANCE.addCombination(initial, added, description);
    }
}

