/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfHome
extends ItemTablet {
    public ItemTabletOfHome() {
        super("tablet_of_home", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfHome.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        if (this.isAncient(stack)) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        }
        this.addItemUse(tooltip, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        MinecraftServer server = Objects.requireNonNull(player.m_20194_());
        Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(server, player);
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !((ServerLevel)respawnPoint.getLeft()).m_46472_().equals((Object)world.m_46472_())) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        Location location = new SpawnHelper((ServerLevel)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
        if (location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            return false;
        }
        CallbackHandler.addFastCallback(() -> {
            boolean isAncient = this.isAncient(stack);
            ServerPlayer newPlayer = Helper.teleport(player, location, (ServerLevel)respawnPoint.getLeft());
            if (isAncient) {
                Location home = new Location((Entity)newPlayer);
                world.m_6249_((Entity)player, player.m_20191_().m_82377_(3.0, 0.0, 3.0), e -> e.m_6084_() && e.m_6072_() && !e.m_5833_()).forEach(entity -> Helper.teleport(entity, home, (ServerLevel)respawnPoint.getLeft()));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.USE_HOME.trigger(player);
        });
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        if (!this.isAncient(stack) && soulStrength > 1) {
            NBTStackHelper.setBoolean(stack, "ancient", true);
            return ISoulConsumer.ConsumeResult.success(2);
        }
        return ISoulConsumer.ConsumeResult.success(1);
    }

    @Override
    protected CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_TELEPORT : CastingType.SIMPLE_TELEPORT;
    }
}

