/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IDefaultImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBoneNeedle
extends ItemGeneric
implements IDefaultImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromMinute(30);
    private static final String IMPREGNATED_TIME_NBT_LONG = "impregnated_time";

    public ItemBoneNeedle() {
        super("bone_needle", ItemBoneNeedle.getBuilder().m_41487_(1));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        Component impregnated = this.getTooltipDisplay(stack);
        if (impregnated == null) {
            this.addItemUse(tooltip);
        } else {
            tooltip.add(impregnated);
        }
        int impregnatedTime = this.getImpregnatedTime(level, stack);
        if (impregnatedTime > 0) {
            this.addWarn(tooltip, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeStringWithUnit(impregnatedTime));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && stack.m_150930_((Item)this) && EntityHelper.noGlobalItemCooldown(player, this)) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.m_9236_().m_5776_()) {
                if (this.impregnate(stack, target)) {
                    NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, GlobalClock.INSTANCE.getTime(player.m_9236_()) + (long)IMPREGNATED_MAX_TIME);
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.sendSpecialMessage(player, target.m_7755_());
                    ModTriggers.IMPREGNATED_BONE_NEEDLE.trigger((ServerPlayer)player);
                } else {
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.sendSpecialMessage(player, new Object[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(level, stack) == 1) {
            NBTStackHelper.removeKeyName(stack, IMPREGNATED_TIME_NBT_LONG);
            NBTStackHelper.removeKeyName(stack, "entity_type");
        }
    }

    private int getImpregnatedTime(@Nullable Level level, ItemStack stack) {
        return level != null && stack.m_150930_((Item)this) ? NBTStackHelper.getTimer(GlobalClock.INSTANCE.getTime(level), stack, IMPREGNATED_TIME_NBT_LONG, IMPREGNATED_MAX_TIME) : 0;
    }
}

