/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public abstract class TBScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tombstone", "textures/gui/crow.png");
    public static final ResourceLocation FRAME = new ResourceLocation("tombstone", "textures/gui/frame.png");
    final int xSize;
    final int ySize;
    int halfWidth;
    int halfHeight;
    int guiLeft;
    int guiTop;
    int guiRight;
    int guiBottom;
    final int oldScale;
    final int scaleLimit;
    boolean isResized = false;

    TBScreen(Component titleIn) {
        this(titleIn, 345, 230);
    }

    TBScreen(Component titleIn, int xSize, int ySize) {
        super(titleIn);
        this.xSize = xSize;
        this.ySize = ySize;
        OptionInstance guiScaleConfig = Minecraft.m_91087_().f_91066_.m_231928_();
        this.oldScale = (Integer)guiScaleConfig.m_231551_();
        guiScaleConfig.m_231514_((Object)16);
        this.scaleLimit = (Integer)guiScaleConfig.m_231551_();
        guiScaleConfig.m_231514_((Object)this.oldScale);
    }

    protected void m_7856_() {
        OptionInstance guiScaleConfig;
        if (((Boolean)ConfigTombstone.client.scaleGuiscreens.get()).booleanValue() && (Integer)(guiScaleConfig = Minecraft.m_91087_().f_91066_.m_231928_()).m_231551_() != this.scaleLimit) {
            guiScaleConfig.m_231514_((Object)this.scaleLimit);
            this.isResized = true;
        }
        this.halfWidth = this.f_96543_ / 2;
        this.halfHeight = this.f_96544_ / 2;
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.guiRight = this.guiLeft + this.xSize;
        this.guiBottom = this.guiTop + this.ySize;
    }

    public void m_7379_() {
        super.m_7379_();
        if (((Boolean)ConfigTombstone.client.scaleGuiscreens.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            if ((Integer)mc.f_91066_.m_231928_().m_231551_() != this.oldScale) {
                mc.f_91066_.m_231928_().m_231514_((Object)this.oldScale);
                mc.m_5741_();
            }
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        Helper.fillGradient(matrix, 0, 0, this.halfWidth, this.f_96544_, -16777216, -14671840, 0, true);
        Helper.fillGradient(matrix, this.halfWidth, 0, this.f_96543_, this.f_96544_, -14671840, -16777216, 0, true);
        if (this.hasWhiteBorder()) {
            guiGraphics.m_280509_(this.guiLeft - 3, this.guiTop - 3, this.guiLeft + this.xSize + 3, this.guiTop + this.ySize + 3, -1);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(this.getBackground(), this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        RenderSystem.disableBlend();
    }

    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    protected boolean hasWhiteBorder() {
        return true;
    }

    protected void drawTitle(GuiGraphics guiGraphics, Component title) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280656_(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        guiGraphics.m_280656_(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        PoseStack poseStack = guiGraphics.m_280168_();
        if (FontHelper.isValidLanguageForFantasy()) {
            FontHelper.drawCentered(guiGraphics, this.f_96547_, FontHelper.withLargeFantasyFont(title), this.halfWidth, this.guiTop + 10, -1);
        } else {
            float scale = 1.8f;
            float inverseScale = 0.5555556f;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, 1.0f);
            FontHelper.drawCentered(guiGraphics, this.f_96547_, FontHelper.withLargeFantasyFont(title), (float)this.halfWidth * inverseScale, (float)(this.guiTop + 11) * inverseScale, -1);
            poseStack.m_85849_();
        }
        guiGraphics.m_280656_(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 28, -1);
        guiGraphics.m_280656_(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 30, -1);
    }

    public void m_86600_() {
        if (this.isResized) {
            this.isResized = false;
            Minecraft.m_91087_().m_5741_();
        }
    }
}

