/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class GlueEffectPacket
extends SimplePacketBase {
    private BlockPos pos;
    private Direction direction;
    private boolean fullBlock;

    public GlueEffectPacket(BlockPos pos, Direction direction, boolean fullBlock) {
        this.pos = pos;
        this.direction = direction;
        this.fullBlock = fullBlock;
    }

    public GlueEffectPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.direction = Direction.m_122376_((int)buffer.readByte());
        this.fullBlock = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeByte(this.direction.m_122411_());
        buffer.writeBoolean(this.fullBlock);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleClient));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91074_.m_20183_().m_123314_((Vec3i)this.pos, 100.0)) {
            return;
        }
        SuperGlueItem.spawnParticles((Level)mc.f_91073_, this.pos, this.direction, this.fullBlock);
    }
}

