/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.util.SpellParticleUtil;
import fuzs.illagerinvasion.util.TeleportUtil;
import fuzs.illagerinvasion.world.entity.monster.InvokerFangs;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Invoker
extends SpellcasterIllager
implements PowerableMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.m_135353_(Invoker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    public int areaDamageCooldown;
    public int teleportCooldown;
    public boolean isAoeCasting = false;
    public int fangaoecooldown;
    @Nullable
    private Sheep wololoTarget;

    public Invoker(EntityType<? extends Invoker> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 80;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AreaDamageGoal());
        this.f_21345_.m_25352_(4, (Goal)new CastTeleportGoal());
        this.f_21345_.m_25352_(5, (Goal)new SummonVexGoal());
        this.f_21345_.m_25352_(5, (Goal)new ConjureAoeFangsGoal());
        this.f_21345_.m_25352_(6, (Goal)new ConjureFangsGoal());
        this.f_21345_.m_25352_(6, (Goal)new WololoGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean m_7090_() {
        return this.getShieldedState();
    }

    public boolean m_7327_(Entity target) {
        if (!super.m_7327_(target)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_147207_(new MobEffectInstance(MobEffects.f_19610_, 100, 0), (Entity)this);
        }
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_IS_SHIELDED, (Object)false);
        super.m_8097_();
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setShieldedState(nbt.m_128471_("Invul"));
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128379_("Invul", this.getShieldedState());
        super.m_7380_(nbt);
    }

    public boolean getShieldedState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHIELDED);
    }

    public void setShieldedState(boolean isShielded) {
        this.f_19804_.m_135381_(DATA_IS_SHIELDED, (Object)isShielded);
    }

    protected void m_8024_() {
        --this.teleportCooldown;
        --this.areaDamageCooldown;
        --this.fangaoecooldown;
        super.m_8024_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.isAoeCasting && this.m_33736_()) {
            SpellParticleUtil.sendSpellParticles((LivingEntity)this, (ServerLevel)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123762_, 2, 0.06);
        }
        Vec3 vec3d = this.m_20184_();
        if (!this.m_20096_() && vec3d.f_82480_ < 0.0) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 1, 0.2, 0.2, 0.2, 0.005);
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).invokerBossBar) {
            this.bossBar.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).invokerBossBar) {
            this.bossBar.m_6539_(player);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Surrendered) {
            return this.m_7307_((Entity)((Surrendered)other).getOwner());
        }
        if (other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.m_37888_()) {
            return AbstractIllager.IllagerArmPose.CELEBRATING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                if (!this.getShieldedState() && this.f_19796_.m_188503_(2) == 0) {
                    this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                    this.setShieldedState(true);
                }
            } else if (this.getShieldedState() && this.f_19796_.m_188503_(3) == 0) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 30, 0.5, 0.7, 0.5, 0.5);
                this.m_5496_((SoundEvent)ModRegistry.INVOKER_SHIELD_BREAK_SOUND_EVENT.get(), 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                this.setShieldedState(false);
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_269533_(DamageTypeTags.f_268731_) || this.getShieldedState() && source.m_269533_(DamageTypeTags.f_268524_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.INVOKER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.INVOKER_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.INVOKER_HURT_SOUND_EVENT.get();
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModRegistry.INVOKER_COMPLETE_CAST_SOUND_EVENT.get();
    }

    public void m_7895_(int wave, boolean unused) {
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Invoker.this);
        }

        public void m_8037_() {
            if (Invoker.this.m_5448_() != null) {
                Invoker.this.m_21563_().m_24960_((Entity)Invoker.this.m_5448_(), (float)Invoker.this.m_8085_(), (float)Invoker.this.m_8132_());
            } else if (Invoker.this.getWololoTarget() != null) {
                Invoker.this.m_21563_().m_24960_((Entity)Invoker.this.getWololoTarget(), (float)Invoker.this.m_8085_(), (float)Invoker.this.m_8132_());
            }
        }
    }

    public class AreaDamageGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public AreaDamageGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean m_8036_() {
            if (Invoker.this.m_5448_() == null) {
                return false;
            }
            if (Invoker.this.areaDamageCooldown < 0) {
                Invoker.this.isAoeCasting = true;
                return true;
            }
            return false;
        }

        private void knockBack(Entity entity) {
            double d = entity.m_20185_() - Invoker.this.m_20185_();
            double e = entity.m_20189_() - Invoker.this.m_20189_();
            double f = Math.max(d * d + e * e, 0.001);
            entity.m_5997_(d / f * 6.0, 0.65, e / f * 6.0);
        }

        protected void knockback(LivingEntity target) {
            this.knockBack((Entity)target);
            target.f_19864_ = true;
        }

        public void m_8041_() {
            Invoker.this.isAoeCasting = false;
            super.m_8041_();
        }

        private void buff(LivingEntity entity) {
            this.knockback(entity);
            entity.m_6469_(Invoker.this.m_269291_().m_269425_(), 11.0f);
            double x = entity.m_20185_();
            double y = entity.m_20186_() + 1.0;
            double z = entity.m_20189_();
            ((ServerLevel)Invoker.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 1.0, z, 10, 0.2, 0.2, 0.2, 0.015);
        }

        protected void m_8130_() {
            Invoker.this.areaDamageCooldown = 300;
            Invoker.this.m_9236_().m_6443_(LivingEntity.class, Invoker.this.m_20191_().m_82400_(6.0), entity -> !(entity instanceof AbstractIllager) && !(entity instanceof Surrendered) && !(entity instanceof Ravager) && EntitySelector.f_20406_.test(entity)).forEach(this::buff);
            Invoker.this.isAoeCasting = false;
            double posx = Invoker.this.m_20185_();
            double posy = Invoker.this.m_20186_();
            double posz = Invoker.this.m_20189_();
            ((ServerLevel)Invoker.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, posx, posy + 1.0, posz, 350, 1.0, 0.8, 1.0, 0.3);
        }

        protected int m_8069_() {
            return 50;
        }

        protected int m_8089_() {
            return 50;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.INVOKER_BIG_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    public class CastTeleportGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public CastTeleportGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean m_8036_() {
            if (Invoker.this.m_5448_() == null) {
                return false;
            }
            if (Invoker.this.m_33736_()) {
                return false;
            }
            return Invoker.this.teleportCooldown < 0 && !this.getTargets().isEmpty();
        }

        private List<LivingEntity> getTargets() {
            return Invoker.this.m_9236_().m_6443_(LivingEntity.class, Invoker.this.m_20191_().m_82400_(6.0), entity -> entity instanceof Player && !((Player)entity).m_150110_().f_35937_ || entity instanceof IronGolem);
        }

        public boolean m_8045_() {
            return !this.getTargets().isEmpty();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public void m_8056_() {
            super.m_8056_();
            Invoker.this.teleportCooldown = 180;
        }

        protected void m_8130_() {
            double x = Invoker.this.m_20185_();
            double y = Invoker.this.m_20186_() + 1.0;
            double z = Invoker.this.m_20189_();
            if (Invoker.this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)Invoker.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 30, 0.3, 0.5, 0.3, 0.015);
            }
            TeleportUtil.tryRandomTeleport((LivingEntity)Invoker.this);
        }

        protected int m_8069_() {
            return 30;
        }

        protected int m_8089_() {
            return 30;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.INVOKER_TELEPORT_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class SummonVexGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private static final TargetingConditions CLOSE_VEX_PREDICATE = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();

        SummonVexGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            List entities = Invoker.this.m_9236_().m_45971_(Surrendered.class, CLOSE_VEX_PREDICATE, (LivingEntity)Invoker.this, Invoker.this.m_20191_().m_82400_(20.0));
            return entities.size() < 3;
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 340;
        }

        protected void m_8130_() {
            ServerLevel serverWorld = (ServerLevel)Invoker.this.m_9236_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = Invoker.this.m_20183_().m_7918_(-2 + Invoker.this.f_19796_.m_188503_(5), 1, -2 + Invoker.this.f_19796_.m_188503_(5));
                Surrendered surrendered = (Surrendered)((EntityType)ModRegistry.SURRENDERED_ENTITY_TYPE.get()).m_20615_(Invoker.this.m_9236_());
                surrendered.m_20035_(blockPos, 0.0f, 0.0f);
                surrendered.m_6518_((ServerLevelAccessor)serverWorld, Invoker.this.m_9236_().m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                surrendered.setOwner((Mob)Invoker.this);
                surrendered.setBounds(blockPos);
                surrendered.setLifeTicks(20 * (30 + Invoker.this.f_19796_.m_188503_(90)));
                serverWorld.m_47205_((Entity)surrendered);
            }
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.INVOKER_SUMMON_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    public class ConjureAoeFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureAoeFangsGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean m_8036_() {
            if (Invoker.this.m_5448_() == null) {
                return false;
            }
            if (this.getTargets().isEmpty()) {
                return false;
            }
            if (Invoker.this.m_33736_()) {
                return false;
            }
            return Invoker.this.fangaoecooldown < 0;
        }

        private List<LivingEntity> getTargets() {
            return Invoker.this.m_9236_().m_6443_(LivingEntity.class, Invoker.this.m_20191_().m_82400_(18.0), entity -> !(entity instanceof Monster));
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.m_7495_();
                BlockState blockState = Invoker.this.m_9236_().m_8055_(blockPos2);
                if (!blockState.m_60783_((BlockGetter)Invoker.this.m_9236_(), blockPos2, Direction.UP)) continue;
                if (!Invoker.this.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState2 = Invoker.this.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)Invoker.this.m_9236_(), blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                Invoker.this.m_9236_().m_7967_((Entity)new InvokerFangs(Invoker.this.m_9236_(), x, (double)blockPos.m_123342_() + 0.2 + d, z, yaw, warmup + 4, (LivingEntity)Invoker.this));
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected void m_8130_() {
            for (LivingEntity livingEntity : this.getTargets()) {
                double d = Math.min(livingEntity.m_20186_(), Invoker.this.m_20186_());
                double e = Math.max(livingEntity.m_20186_(), Invoker.this.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - Invoker.this.m_20189_()), (double)(livingEntity.m_20185_() - Invoker.this.m_20185_()));
                for (int i = 0; i < 5; ++i) {
                    float g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(livingEntity.m_20185_() + (double)Mth.m_14089_((float)g) * 1.5, livingEntity.m_20189_() + (double)Mth.m_14031_((float)g) * 1.5, d, e, g, 0);
                }
            }
            Invoker.this.fangaoecooldown = 100;
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 100;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.INVOKER_FANGS_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class ConjureFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        ConjureFangsGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 100;
        }

        protected void m_8130_() {
            LivingEntity livingEntity = Invoker.this.m_5448_();
            double d = Math.min(livingEntity.m_20186_(), Invoker.this.m_20186_());
            double e = Math.max(livingEntity.m_20186_(), Invoker.this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - Invoker.this.m_20189_()), (double)(livingEntity.m_20185_() - Invoker.this.m_20185_()));
            if (Invoker.this.m_20280_((Entity)livingEntity) < 9.0) {
                float g;
                int i;
                for (i = 0; i < 5; ++i) {
                    g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)g) * 1.5, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)g) * 1.5, d, e, g, 0);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)g) * 2.5, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)g) * 2.5, d, e, g, 3);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)g) * 3.5, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)g) * 2.5, d, e, g, 3);
                }
            } else {
                double h;
                int i;
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)f) * h, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)f) * h, d, e, f, i);
                }
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)(f + 0.4f)) * h, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)(f + 0.3f)) * h, d, e, f, i);
                }
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.m_20185_() + (double)Mth.m_14089_((float)(f - 0.4f)) * h, Invoker.this.m_20189_() + (double)Mth.m_14031_((float)(f - 0.3f)) * h, d, e, f, i);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.m_7495_();
                BlockState blockState = Invoker.this.m_9236_().m_8055_(blockPos2);
                if (!blockState.m_60783_((BlockGetter)Invoker.this.m_9236_(), blockPos2, Direction.UP)) continue;
                if (!Invoker.this.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState2 = Invoker.this.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)Invoker.this.m_9236_(), blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                Invoker.this.m_9236_().m_7967_((Entity)new InvokerFangs(Invoker.this.m_9236_(), x, (double)blockPos.m_123342_() + 0.2 + d, z, yaw, warmup, (LivingEntity)Invoker.this));
            }
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.INVOKER_FANGS_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class WololoGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions convertibleSheepPredicate;

        public WololoGoal() {
            super((SpellcasterIllager)Invoker.this);
            this.convertibleSheepPredicate = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(livingEntity -> ((Sheep)livingEntity).m_29874_() == DyeColor.BLUE);
        }

        public boolean m_8036_() {
            if (Invoker.this.m_5448_() != null) {
                return false;
            }
            if (Invoker.this.m_33736_()) {
                return false;
            }
            if (Invoker.this.f_19797_ < this.f_33775_) {
                return false;
            }
            if (!Invoker.this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                return false;
            }
            List list = Invoker.this.m_9236_().m_45971_(Sheep.class, this.convertibleSheepPredicate, (LivingEntity)Invoker.this, Invoker.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Invoker.this.setWololoTarget((Sheep)list.get(Invoker.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        public boolean m_8045_() {
            return Invoker.this.getWololoTarget() != null && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            Invoker.this.setWololoTarget(null);
        }

        protected void m_8130_() {
            Sheep sheepEntity = Invoker.this.getWololoTarget();
            if (sheepEntity != null && sheepEntity.m_6084_()) {
                sheepEntity.m_29855_(DyeColor.RED);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 140;
        }

        protected int m_8067_() {
            return 600;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11869_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

