/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import com.google.common.collect.Maps;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.item.v2.ToolTypeHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Basher
extends AbstractIllager {
    private static final String TAG_STUN_TICKS = "Stunned";
    private static final EntityDataAccessor<Boolean> DATA_STUNNED = SynchedEntityData.m_135353_(Basher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int stunTicks;
    private int blockedCount;

    public Basher(EntityType<? extends Basher> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean bl = ((ServerLevel)this.m_9236_()).m_8843_(this.m_20183_());
            ((GroundPathNavigation)this.m_21573_()).m_26477_(bl);
            super.m_8024_();
        }
    }

    public boolean m_142582_(Entity entity) {
        if (this.getStunnedState()) {
            return false;
        }
        return super.m_142582_(entity);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128405_(TAG_STUN_TICKS, this.stunTicks);
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setStunTicks(nbt.m_128451_(TAG_STUN_TICKS));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_STUNNED, (Object)false);
        super.m_8097_();
    }

    public boolean getStunnedState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STUNNED);
    }

    public void setStunTicks(int stunTicks) {
        this.stunTicks = stunTicks;
        this.f_19804_.m_135381_(DATA_STUNNED, (Object)(stunTicks > 0 ? 1 : 0));
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (this.stunTicks > 0) {
            this.setStunTicks(this.stunTicks - 1);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getStunnedState();
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_37888_()) {
            return AbstractIllager.IllagerArmPose.CELEBRATING;
        }
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModRegistry.BASHER_CELEBRATE_SOUND_EVENT.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        boolean hasShield = this.m_21205_().m_150930_(Items.f_42740_);
        if (this.m_5912_()) {
            if (attacker instanceof LivingEntity) {
                ItemStack attackerMainHand = ((LivingEntity)attacker).m_21205_();
                ItemStack basherMainHand = this.m_21205_();
                if ((ToolTypeHelper.INSTANCE.isAxe(attackerMainHand) || attacker instanceof IronGolem || this.blockedCount >= 4) && basherMainHand.m_150930_(Items.f_42740_)) {
                    this.m_5496_(SoundEvents.f_12347_, 1.0f, 1.0f);
                    this.setStunTicks(60);
                    if (this.m_9236_() instanceof ServerLevel) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, basherMainHand), this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), 30, 0.3, 0.2, 0.3, 0.003);
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
                    }
                    return super.m_6469_(source, amount);
                }
            }
            if (source.m_7640_() instanceof AbstractArrow && hasShield) {
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                ++this.blockedCount;
                return false;
            }
            if (source.m_7640_() instanceof LivingEntity && hasShield) {
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                ++this.blockedCount;
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData entityData2 = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_213945_(world.m_213780_(), difficulty);
        this.m_213946_(world.m_213780_(), difficulty);
        return entityData2;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public boolean m_7307_(Entity other) {
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.BASHER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.BASHER_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.BASHER_HURT_SOUND_EVENT.get();
    }

    public void m_7895_(int wave, boolean unused) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42740_);
        Raid raid = this.m_37885_();
        int i = 1;
        if (wave > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean bl = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl2 = bl;
        if (bl) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.f_44986_, i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(Basher vindicator) {
            super((PathfinderMob)vindicator, 1.0, false);
        }

        protected double m_6639_(LivingEntity entity) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * (f * 2.0f) + entity.m_20205_();
            }
            return super.m_6639_(entity);
        }
    }
}

