/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.handler;

import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PlatinumTrimHandler {
    public static final String INSIGHT_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.insight";
    public static final String AGILITY_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.agility";
    public static final String ENDURANCE_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.endurance";
    public static final String FEATHERWEIGHT_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.featherweight";
    public static final Map<ArmorItem.Type, String> PLATINUM_TRIM_TRANSLATION_KEYS = Collections.unmodifiableMap((Map)Util.m_137469_(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, FEATHERWEIGHT_TRANSLATION_KEY);
        enumMap.put(ArmorItem.Type.LEGGINGS, ENDURANCE_TRANSLATION_KEY);
        enumMap.put(ArmorItem.Type.CHESTPLATE, AGILITY_TRANSLATION_KEY);
        enumMap.put(ArmorItem.Type.HELMET, INSIGHT_TRANSLATION_KEY);
    }));

    public static EventResult onBreakSpeed(Player player, BlockState state, DefaultedFloat breakSpeed) {
        if (player.m_150109_().m_36020_(state) == 1.0f && PlatinumTrimHandler.hasPlatinumTrim(player, EquipmentSlot.CHEST)) {
            breakSpeed.mapFloat(f -> Float.valueOf(f.floatValue() * 1.5f));
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(LivingEntity entity, @Nullable Player attackingPlayer, DefaultedInt droppedExperience) {
        if (attackingPlayer != null && PlatinumTrimHandler.hasPlatinumTrim(attackingPlayer, EquipmentSlot.HEAD)) {
            droppedExperience.mapDefaultInt(i -> i + (int)Math.max(1.0f, (float)i * 0.2f));
        }
        return EventResult.PASS;
    }

    public static EventResult onFarmlandTrample(Level level, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
        Player player;
        return entity instanceof Player && PlatinumTrimHandler.hasPlatinumTrim(player = (Player)entity, EquipmentSlot.FEET) ? EventResult.INTERRUPT : EventResult.PASS;
    }

    public static boolean hasPlatinumTrim(Player player, EquipmentSlot equipmentSlot) {
        return PlatinumTrimHandler.getPlatinumTrim(player.m_9236_(), player.m_6844_(equipmentSlot)).isPresent();
    }

    public static Optional<ArmorTrim> getPlatinumTrim(Level level, ItemStack stack) {
        if (!((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).platinumTrimEffects) {
            return Optional.empty();
        }
        return ArmorTrim.m_266285_((RegistryAccess)level.m_9598_(), (ItemStack)stack).filter(armorTrim -> armorTrim.m_266210_().m_203565_(ModRegistry.PLATINUM_TRIM_MATERIAL));
    }
}

