/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.network;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.endertech.minecraft.mods.adpoles.network.JumpMsg;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HolderMsg
extends ForgeNetMsg<HolderMsg> {
    public int holderId;
    public Holder.PlayerAction playerAction;
    public float deltaYaw;

    public HolderMsg() {
    }

    public HolderMsg(Holder holder, Holder.PlayerAction playerAction, float deltaYaw) {
        this.holderId = holder.m_19879_();
        this.playerAction = playerAction;
        this.deltaYaw = deltaYaw;
    }

    public HolderMsg create() {
        return new HolderMsg();
    }

    public void handle(Level level, Player player) {
        Entity entity = level.m_6815_(this.holderId);
        if (entity instanceof Holder) {
            Holder holder = (Holder)entity;
            switch (this.playerAction) {
                case DISMOUNT: {
                    holder.m_20153_();
                    break;
                }
                case JUMP: {
                    holder.m_20153_();
                    new JumpMsg().sendTo(player);
                    break;
                }
                default: {
                    holder.updateSlideAcceleration(this.playerAction);
                    holder.updateSpinVelocity(this.deltaYaw);
                }
            }
        }
    }

    public void sendToServer() {
        AdPoles.getInstance().getConnection().sendToServer((Object)this);
    }
}

