/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.init;

import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import com.endertech.minecraft.mods.adpoles.blocks.PoweredPole;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class Poles
extends RelatedUnitsInit<Pole, BuildIn> {
    public Poles(AbstractForgeMod mod) {
        super(mod, BuildIn.class);
    }

    protected void initCustomConfigs() {
    }

    public Pole createDefaultUnitFrom(UnitConfig config, BuildIn e) {
        e.pole = e == BuildIn.REDSTONE_POLE ? new PoweredPole(config, (Pole.Properties)((Object)e.props.get())) : new Pole(config, (Pole.Properties)((Object)e.props.get()));
        return e.pole;
    }

    public Pole createCustomUnitFrom(UnitConfig config, String name) {
        return new Pole(config, (Pole.Properties<?>)((Object)Pole.Properties.of(name, "").speedFactor(0.5f)));
    }

    public Optional<Pole> get(BlockState state) {
        VoxelShape shape;
        BlockPos pos;
        EmptyBlockGetter level;
        if (state.m_60795_()) {
            return Optional.empty();
        }
        Block block = state.m_60734_();
        if (block instanceof Pole) {
            return Optional.of((Pole)block);
        }
        if (block instanceof IPole) {
            return BuildIn.bySound(state.m_60827_()).map(BuildIn::get);
        }
        if (!(!(block instanceof FenceBlock) || ((Boolean)state.m_61143_((Property)FenceBlock.f_52309_)).booleanValue() || ((Boolean)state.m_61143_((Property)FenceBlock.f_52310_)).booleanValue() || ((Boolean)state.m_61143_((Property)FenceBlock.f_52311_)).booleanValue() || ((Boolean)state.m_61143_((Property)FenceBlock.f_52312_)).booleanValue())) {
            return BuildIn.WOODEN_POLE.getIf(OptionalTypes.WOODEN_FENCES.enabled);
        }
        if (block instanceof BambooStalkBlock) {
            return BuildIn.WOODEN_POLE.getIf(OptionalTypes.BAMBOO_PLANTS.enabled);
        }
        if (block instanceof ChainBlock && ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).m_122478_()) {
            return BuildIn.IRON_POLE.getIf(OptionalTypes.CHAINS.enabled);
        }
        if (!(!(block instanceof IronBarsBlock) || ((Boolean)state.m_61143_((Property)IronBarsBlock.f_52309_)).booleanValue() || ((Boolean)state.m_61143_((Property)IronBarsBlock.f_52310_)).booleanValue() || ((Boolean)state.m_61143_((Property)IronBarsBlock.f_52311_)).booleanValue() || ((Boolean)state.m_61143_((Property)IronBarsBlock.f_52312_)).booleanValue())) {
            if (state.m_60827_() == SoundType.f_56743_) {
                return BuildIn.IRON_POLE.getIf(OptionalTypes.IRON_BARS.enabled);
            }
            if (state.m_60827_() == SoundType.f_56744_) {
                return BuildIn.GLASS_POLE.getIf(OptionalTypes.GLASS_PANES.enabled);
            }
        }
        if (state.m_60659_((BlockGetter)(level = EmptyBlockGetter.INSTANCE), pos = BlockPos.f_121853_, Direction.DOWN, SupportType.CENTER) && !state.m_60783_((BlockGetter)level, pos, Direction.DOWN) && !state.m_60783_((BlockGetter)level, pos, Direction.UP) && Shapes.m_83148_((VoxelShape)(shape = state.m_60808_((BlockGetter)level, pos)), (VoxelShape)Pole.shape(2.0f), (BooleanOp)BooleanOp.f_82683_).m_83281_() && Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Pole.shape(4.0f), (BooleanOp)BooleanOp.f_82685_).m_83281_()) {
            String name = Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block)).map(ResourceLocation::m_135815_).orElse("");
            BuildIn pole = BuildIn.bySound(state.m_60827_()).orElse(BuildIn.WOODEN_POLE);
            if (name.contains("post")) {
                return pole.getIf(OptionalTypes.POSTS.enabled);
            }
            if (name.contains("fence")) {
                return pole.getIf(OptionalTypes.MODDED_FENCES.enabled);
            }
        }
        return Optional.empty();
    }

    public Optional<Pole> get(LevelReader reader, BlockPos pos) {
        if (reader.m_46805_(pos)) {
            return this.get(reader.m_8055_(pos));
        }
        return Optional.empty();
    }

    public static enum BuildIn implements IForgeEnum
    {
        WOODEN_POLE("oak_planks", 0.2f, false),
        IRON_POLE("iron_block", 0.4f, true),
        GLASS_POLE("glass", 0.5f, false),
        REDSTONE_POLE("redstone_block", 0.5f, true),
        GOLDEN_POLE("gold_block", 0.6f, true),
        DIAMOND_POLE("diamond_block", 0.8f, true),
        OBSIDIAN_POLE("obsidian", 0.9f, true);

        private final Lazy<Pole.Properties<?>> props = Lazy.of(() -> Pole.Properties.of(this.getName(), relatedBlockId).speedFactor(speedFactor));
        private Pole pole;

        private BuildIn(String relatedBlockId, float speedFactor, boolean register) {
        }

        public Pole get() {
            return this.pole;
        }

        public Optional<Pole> getIf(ForgeConfigSpec.ConfigValue<Boolean> enabled) {
            return enabled != null && (Boolean)enabled.get() != false ? Optional.of(this.pole) : Optional.empty();
        }

        public static Optional<BuildIn> bySound(SoundType sound) {
            if (sound == SoundType.f_56744_) {
                return Optional.of(GLASS_POLE);
            }
            if (sound == SoundType.f_56743_ || sound == SoundType.f_154663_ || sound == SoundType.f_56728_) {
                return Optional.of(IRON_POLE);
            }
            if (sound == SoundType.f_56736_) {
                return Optional.of(WOODEN_POLE);
            }
            return Optional.empty();
        }
    }

    public static enum OptionalTypes {
        GLASS_PANES,
        WOODEN_FENCES,
        IRON_BARS,
        CHAINS,
        BAMBOO_PLANTS,
        MODDED_FENCES,
        POSTS;

        public ForgeConfigSpec.ConfigValue<Boolean> enabled;
    }
}

