/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.entities;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import com.endertech.minecraft.mods.adpoles.data.PolePosition;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fluids.FluidType;

public class Holder
extends ForgeEntity {
    private static final float MAX_DELTA_YAW = 105.0f;
    private static final Vect3d UP_UNIT_VECTOR = Vect3d.from((double)0.0, (double)1.0, (double)0.0);
    private static final EntityDataAccessor<Optional<BlockPos>> POLE_POS = SynchedEntityData.m_135353_(Holder.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Float> SPIN_RADIUS = SynchedEntityData.m_135353_(Holder.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPIN_VELOCITY = SynchedEntityData.m_135353_(Holder.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ACCELERATION = SynchedEntityData.m_135353_(Holder.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Direction> SLIDE_DIRECTION = SynchedEntityData.m_135353_(Holder.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static ForgeConfigSpec.ConfigValue<Boolean> switchToThirdPersonView;
    public static ForgeConfigSpec.ConfigValue<Boolean> basicSlidingControl;
    private float deltaRotation;
    private CameraType savedPointOfView;

    public Holder(EntityType<?> type, Level world) {
        super(type, world);
    }

    public Holder(Level world, Player player, BlockPos polePos) {
        super((EntityType)AdPoles.getInstance().entities.holder.get(), world);
        this.m_20359_((Entity)player);
        this.setPolePos(polePos);
        this.setSpinRadius(player.m_20205_() * 0.8f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(POLE_POS, Optional.empty());
        this.f_19804_.m_135372_(ACCELERATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPIN_RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPIN_VELOCITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SLIDE_DIRECTION, (Object)Direction.DOWN);
    }

    public void updateSpinVelocity(float deltaYaw) {
        this.getPolePosition().ifPresent((pole, pos) -> {
            float yawFactor = deltaYaw / 105.0f;
            float maxSpinVelocity = pole.getMaxVelocity(this.m_9236_(), (BlockPos)pos, Pole.Velocity.SPINNING);
            float spinVelocity = maxSpinVelocity * yawFactor;
            this.setSpinVelocity(spinVelocity);
        });
    }

    public void updateSlideAcceleration(PlayerAction action) {
        this.getPolePosition().ifPresent((pole, pos) -> {
            Direction direction = pole.getSlideDirection(this.m_9236_(), (BlockPos)pos);
            float targetVelocity = pole.getMaxVelocity(this.m_9236_(), (BlockPos)pos, Pole.Velocity.SLIDING);
            if (direction == Direction.DOWN) {
                targetVelocity = -targetVelocity;
            }
            switch (action) {
                case ACCELERATE: {
                    break;
                }
                case STOP: {
                    targetVelocity = 0.0f;
                    break;
                }
                case CLIMB: {
                    targetVelocity = pole.getMaxVelocity(this.m_9236_(), (BlockPos)pos, Pole.Velocity.CLIMBING);
                    if (direction != Direction.UP) break;
                    targetVelocity = -targetVelocity;
                    break;
                }
            }
            float acceleration = Mth.m_14036_((float)((float)((double)targetVelocity - this.m_20184_().f_82480_)), (float)(-pole.getAcceleration()), (float)pole.getAcceleration());
            this.setSlideAcceleration(acceleration);
            this.setSlideDirection(direction);
        });
    }

    public double m_6048_() {
        return 0.0;
    }

    public Vec3 m_7688_(LivingEntity pPassenger) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_());
    }

    @Nullable
    public LivingEntity m_6688_() {
        return Optional.ofNullable(this.m_146895_()).filter(LivingEntity.class::isInstance).orElse(null);
    }

    public void m_8119_() {
        this.m_6853_(true);
        LivingEntity passenger = this.m_6688_();
        BlockPos polePos = this.getPolePosition().position().orElse(null);
        if (!(passenger instanceof Player && polePos != null && passenger.m_6084_() && Pole.isRidableFor((Entity)passenger, polePos) && Pole.isRidableFor((Entity)passenger, polePos.m_7495_()))) {
            if (this.isServerSide()) {
                if (passenger != null) {
                    passenger.m_8127_();
                }
                this.m_146870_();
            }
            return;
        }
        passenger.m_6853_(true);
        float slideAcceleration = this.getSlideAcceleration();
        this.addMotion(0.0, slideAcceleration, 0.0);
        if (this.m_20184_().f_82480_ > 0.0 && (!Pole.isLongEnoughFor((Entity)passenger, polePos) || Pole.isObstacleAbove((Entity)passenger, polePos))) {
            this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
        }
        if (this.m_9236_().m_5776_() && passenger instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)passenger;
            PlayerAction action = PlayerAction.NONE;
            Options gs = GameKeys.getGameSettings();
            boolean isSprinting = gs.f_92091_.m_90857_();
            if (gs.f_92090_.m_90857_()) {
                action = PlayerAction.DISMOUNT;
            } else if (gs.f_92089_.m_90857_()) {
                action = PlayerAction.JUMP;
            } else if (((Boolean)basicSlidingControl.get()).booleanValue()) {
                if (gs.f_92085_.m_90857_()) {
                    action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
            } else {
                boolean lookingForward;
                Vec3 lookVec = player.m_20154_();
                Direction direction = this.getSlideDirection();
                boolean bl = lookingForward = direction == Direction.DOWN && lookVec.f_82480_ < 0.0 || direction == Direction.UP && lookVec.f_82480_ > 0.0;
                if (gs.f_92085_.m_90857_() && !lookingForward) {
                    PlayerAction playerAction = action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
                if (gs.f_92087_.m_90857_() && lookingForward) {
                    action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
            }
            float headYaw = passenger.m_6080_();
            float holderYaw = this.m_146908_();
            float deltaYaw = Mth.m_14177_((float)(headYaw - holderYaw));
            new HolderMsg(this, action, deltaYaw).sendToServer();
        }
        if (polePos.m_123342_() != this.m_20183_().m_123342_()) {
            polePos = BlockPos.m_274561_((double)polePos.m_123341_(), (double)this.m_20182_().m_7098_(), (double)polePos.m_123343_());
            this.setPolePos(polePos);
        }
        Vect3d poleCenter = Pole.getCenterWithY(polePos, this.m_20186_());
        Vect3d radiusVec = this.getCorrectedRadiusVector(polePos);
        float spinVelocity = this.getSpinVelocity();
        float yaw = 180.0f - radiusVec.yaw();
        this.deltaRotation = Mth.m_14177_((float)(yaw - this.m_146908_()));
        Vect3d spinVec = radiusVec.mult(UP_UNIT_VECTOR).scale((double)spinVelocity);
        Vect3d destPos = poleCenter.add(radiusVec.scale((double)this.getSpinRadius())).add(spinVec).move(0.0, this.m_20184_().f_82480_, 0.0);
        this.m_19890_(destPos.x, destPos.y, destPos.z, yaw, this.m_146909_());
    }

    protected Optional<Direction> getNearbyWallDirection() {
        BlockPos polePos = this.getPolePosition().position().orElse(null);
        LivingEntity passenger = this.m_6688_();
        if (polePos != null && passenger != null) {
            for (Direction dir : GameWorld.Directions.of().horizontals().toArray()) {
                BlockPos pos = polePos.m_121945_(dir);
                if (!Pole.isObstacleFor((Entity)passenger, pos) && !Pole.isObstacleFor((Entity)passenger, pos.m_7494_())) continue;
                return Optional.of(dir);
            }
        }
        return Optional.empty();
    }

    protected Vect3d getCorrectedRadiusVector(BlockPos polePos) {
        Vect3d poleCenter = Pole.getCenterWithY(polePos, this.m_20186_());
        Vect3d radiusVec = this.getCurPosition().subtract(poleCenter).normalize();
        Direction wallDirection = this.getNearbyWallDirection().orElse(null);
        if (wallDirection == null) {
            return radiusVec;
        }
        Vect3d wallCenter = Pole.getCenterWithY(polePos.m_121945_(wallDirection), this.m_20186_());
        float wallYaw = wallCenter.subtract(poleCenter).yaw();
        float amplitude = 80.0f;
        float minYaw = wallYaw - amplitude;
        float maxYaw = wallYaw + amplitude;
        if (maxYaw >= 360.0f) {
            minYaw -= 360.0f;
            maxYaw -= 360.0f;
        }
        FloatBounds bounds = FloatBounds.between((Float)Float.valueOf(minYaw), (Float)Float.valueOf(maxYaw));
        float curYaw = radiusVec.yaw();
        if (curYaw < 0.0f && bounds.getMin().floatValue() >= 0.0f) {
            curYaw = 360.0f + curYaw;
        }
        if (bounds.encloses(Float.valueOf(curYaw))) {
            float deltaYaw = 0.0f;
            deltaYaw = curYaw - bounds.getMin().floatValue() < bounds.getMax().floatValue() - curYaw ? curYaw - bounds.getMin().floatValue() : curYaw - bounds.getMax().floatValue();
            radiusVec = radiusVec.rotateYaw(deltaYaw);
        }
        return radiusVec;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
        passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
        this.m_7340_(passenger);
    }

    public void m_7340_(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float delta = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float clamped = Mth.m_14036_((float)delta, (float)-105.0f, (float)105.0f);
        entity.m_146922_(entity.m_146908_() + clamped - delta);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public float getSpinRadius() {
        return ((Float)this.f_19804_.m_135370_(SPIN_RADIUS)).floatValue();
    }

    public void setSpinRadius(float spinRadius) {
        this.f_19804_.m_135381_(SPIN_RADIUS, (Object)Float.valueOf(spinRadius));
    }

    public float getSpinVelocity() {
        return ((Float)this.f_19804_.m_135370_(SPIN_VELOCITY)).floatValue();
    }

    public void setSpinVelocity(float spinVelocity) {
        this.f_19804_.m_135381_(SPIN_VELOCITY, (Object)Float.valueOf(spinVelocity));
    }

    public float getSlideAcceleration() {
        return ((Float)this.f_19804_.m_135370_(ACCELERATION)).floatValue();
    }

    public Direction getSlideDirection() {
        return (Direction)this.f_19804_.m_135370_(SLIDE_DIRECTION);
    }

    public void setSlideAcceleration(float slideAcceleration) {
        this.f_19804_.m_135381_(ACCELERATION, (Object)Float.valueOf(slideAcceleration));
    }

    public void setSlideDirection(Direction direction) {
        this.f_19804_.m_135381_(SLIDE_DIRECTION, (Object)direction);
    }

    public PolePosition getPolePosition() {
        Optional position = (Optional)this.m_20088_().m_135370_(POLE_POS);
        Optional<Pole> pole = position.isPresent() ? Pole.getAt((LevelReader)this.m_9236_(), (BlockPos)position.get()) : Optional.empty();
        return new PolePosition(pole, position);
    }

    public void setPolePos(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(POLE_POS, Optional.ofNullable(pos));
    }

    protected void m_20348_(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof LocalPlayer) {
            Options settings = Minecraft.m_91087_().f_91066_;
            this.savedPointOfView = settings.m_92176_();
            if (settings.m_92176_() == CameraType.FIRST_PERSON) {
                settings.m_92157_(CameraType.THIRD_PERSON_BACK);
            }
        }
        super.m_20348_(passenger);
    }

    protected void m_20351_(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof LocalPlayer) {
            Minecraft.m_91087_().f_91066_.m_92157_(this.savedPointOfView);
        }
        this.getPolePosition().ifPresent((pole, pos) -> {
            float dist = passenger.m_20205_();
            Vect3d poleCenter = Pole.getCenterWithY(pos, this.m_20186_());
            Vect3d radiusVec = this.getCorrectedRadiusVector((BlockPos)pos);
            this.m_20219_(poleCenter.add(radiusVec.scale((double)dist)).move(0.0, -0.5, 0.0).toVector3d());
        });
        super.m_20351_(passenger);
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public static enum PlayerAction {
        NONE,
        ACCELERATE,
        STOP,
        CLIMB,
        JUMP,
        DISMOUNT;

    }
}

