/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredPole
extends Pole {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public PoweredPole(UnitConfig config, Pole.Properties<?> props) {
        super(config, props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public Direction getSlideDirection(Level level, BlockPos pos) {
        if (this.isPoweredPole((BlockGetter)level, pos)) {
            return Direction.UP;
        }
        return super.getSlideDirection(level, pos);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (side != null) {
            switch (side) {
                case UP: 
                case DOWN: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPoweredPole(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return this.isSamePole(world, pos) && (Boolean)state.m_61143_((Property)POWERED) != false;
    }

    public void updatePoweredState(Level world, BlockPos pos, BlockState state) {
        boolean powered;
        BlockState newstate;
        if (GameWorld.isServerSide((LevelReader)world) && state != (newstate = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered = this.findPowerSource(world, pos))))) {
            world.m_46597_(pos, newstate);
        }
    }

    protected boolean findPowerSource(Level world, BlockPos startPos) {
        for (Direction facing : new Direction[]{Direction.DOWN, Direction.UP}) {
            BlockPos pos = startPos;
            while (this.isSamePole((BlockGetter)world, pos)) {
                boolean found = world.m_276987_(pos.m_121945_(facing), facing.m_122424_());
                if (found) {
                    return true;
                }
                pos = pos.m_121945_(facing);
            }
        }
        return false;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updatePoweredState(world, pos, state);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(world, pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.isPoweredPole(world, pos) ? 1 : super.getLightEmission(state, world, pos);
    }
}

