/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.blocks.RelatedBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.data.MovableApexes;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;

public class Pole
extends RelatedBlock
implements IPole {
    public static MovableApexes movableApexes;
    public static ForgeConfigSpec.ConfigValue<Boolean> quickExtension;
    public static ForgeConfigSpec.ConfigValue<Integer> maxPolesAtOnce;
    public static final VoxelShape SHAPE;
    private final float acceleration;
    private final EnumMap<Velocity, Float> maxVelocityMap = new EnumMap(Velocity.class);

    public Pole(UnitConfig config, Properties<?> props) {
        super(config, props);
        for (Velocity vel : Velocity.values()) {
            float defaultValue = vel.bounds.interpolateUp(props.speedFactor).floatValue();
            defaultValue = GameMath.roundTo((float)defaultValue, (int)-2);
            String category = Names.dotted().join(new String[]{props.name, "maxVelocity"});
            String comment = "Defines the maximum " + vel.getName() + " speed, " + vel.getDirection() + " the pole.";
            float value = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)vel.getName(), (float)defaultValue, (FloatBounds)vel.bounds, (String)comment);
            this.maxVelocityMap.put(vel, Float.valueOf(value));
        }
        this.acceleration = UnitConfig.getFloat((UnitConfig)config, (String)props.name, (String)"acceleration", (float)0.04f, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.1f)), (String)"Defines how fast sliding velocity changes.");
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((LevelAccessor)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.m_49966_());
    }

    @VisibleForTesting
    public void setTestValues() {
    }

    public static boolean isOneBlockNear(Entity entity) {
        Level level = entity.m_9236_();
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() + 0.5), (double)entity.m_20189_());
        for (Direction facing : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
            BlockPos checkPos = pos.m_121945_(facing);
            if (!Pole.getAt((LevelReader)level, checkPos).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockPos findReachableFor(Entity entity) {
        Level level = entity.m_9236_();
        Vec3 look = entity.m_20154_();
        look = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        AABB bb = entity.m_20191_();
        bb = bb.m_82383_(look);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int y = Mth.m_14107_((double)bb.f_82289_);
        while ((double)y <= bb.f_82292_) {
            int x = Mth.m_14107_((double)bb.f_82288_);
            while ((double)x <= bb.f_82291_) {
                int z = Mth.m_14107_((double)bb.f_82290_);
                while ((double)z <= bb.f_82293_) {
                    pos.m_122178_(x, y, z);
                    if (Pole.getAt((LevelReader)level, (BlockPos)pos).isPresent()) {
                        return pos.m_7949_();
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return null;
    }

    public static Optional<Holder> getHolderFor(Entity entity) {
        return Optional.ofNullable(entity.m_20202_()).map(vehicle -> vehicle instanceof Holder ? (Holder)((Object)vehicle) : null);
    }

    public static void releaseFrom(Entity entity) {
        Pole.getHolderFor(entity).ifPresent(Entity::m_146870_);
    }

    public static boolean canBeHeldBy(Entity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_20159_()) {
            return false;
        }
        if (entity.m_6047_()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                return false;
            }
            if (player.m_7500_() && player.m_150110_().f_35935_) {
                return false;
            }
        }
        return true;
    }

    public static Vect3d getCenterWithY(BlockPos pos, double y) {
        return Vect3d.from((double)((double)pos.m_123341_() + 0.5), (double)y, (double)((double)pos.m_123343_() + 0.5));
    }

    public static Optional<Pole> getAt(LevelReader level, BlockPos pos) {
        return AdPoles.getInstance().poles.get(level, pos);
    }

    public boolean isApex(BlockState state) {
        return movableApexes.contains(state);
    }

    public boolean isPole(BlockState state) {
        return AdPoles.getInstance().poles.get(state).isPresent();
    }

    public static boolean hasLengthIn(Level level, BlockPos pos, Direction direction, int length) {
        int count;
        for (count = 0; count < length && Pole.getAt((LevelReader)level, pos.m_5484_(direction, count)).isPresent(); ++count) {
        }
        return count >= length;
    }

    public static boolean isRidableFor(Entity entity, BlockPos pos) {
        Level level = entity.m_9236_();
        Pole pole = Pole.getAt((LevelReader)level, pos).orElse(null);
        if (pole == null) {
            return false;
        }
        boolean maxObstacles = true;
        int count = 0;
        for (BlockPos check : GameWorld.Positions.getAroundHoriz((BlockPos)pos, (boolean)false, (BlockPos[])new BlockPos[0])) {
            if (Pole.isObstacleFor(entity, check)) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return count <= 1;
    }

    public static boolean isObstacleFor(Entity entity, BlockPos pos) {
        Level level = entity.m_9236_();
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60647_((BlockGetter)level, pos, PathComputationType.LAND)) {
            return false;
        }
        if (state.m_60804_((BlockGetter)level, pos)) {
            return true;
        }
        if (state.m_60783_((BlockGetter)level, pos, Direction.DOWN)) {
            return true;
        }
        VoxelShape shape = state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity));
        if (shape.m_83281_()) {
            return false;
        }
        AABB aabb = shape.m_83215_();
        if (aabb == null) {
            return false;
        }
        double length = 0.5;
        return !(aabb.f_82291_ - aabb.f_82288_ < 0.5) || !(aabb.f_82293_ - aabb.f_82290_ < 0.5);
    }

    public static boolean isObstacleAbove(Entity entity, BlockPos pos) {
        double margin = 0.4f;
        double y = entity.m_20186_() + (double)entity.m_20206_() + margin;
        BlockPos top = BlockPos.m_274561_((double)pos.m_123341_(), (double)y, (double)pos.m_123343_());
        return Pole.isObstacleFor(entity, top);
    }

    public static boolean isLongEnoughFor(Entity entity, BlockPos pos) {
        Level level = entity.m_9236_();
        int length = Mth.m_14167_((float)entity.m_20206_());
        return Pole.hasLengthIn(level, pos, Direction.UP, length);
    }

    public float getMaxVelocity(Level level, BlockPos pos, Velocity velocity) {
        float waterReduction = IWaterLoggable.isWaterlogged((BlockState)level.m_8055_(pos)) ? 4.0f : 1.0f;
        return this.maxVelocityMap.get((Object)velocity).floatValue() / waterReduction;
    }

    public Direction getSlideDirection(Level level, BlockPos pos) {
        return Direction.DOWN;
    }

    public boolean isSamePole(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.canStayAt(level, pos);
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)quickExtension.get()).booleanValue()) {
            int quantity = player.m_21206_().m_41720_() == player.m_21205_().m_41720_() ? (Integer)maxPolesAtOnce.get() : 1;
            return this.buildBy(player, level, pos, hand, hit, quantity);
        }
        return InteractionResult.PASS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int quantity = player.m_6047_() ? (Integer)maxPolesAtOnce.get() : 1;
            this.breakBy(player, server, pos, quantity);
        }
        return false;
    }

    public static VoxelShape shape(float width) {
        double radius = width / 2.0f;
        return Block.m_49796_((double)(8.0 - radius), (double)0.0, (double)(8.0 - radius), (double)(8.0 + radius), (double)16.0, (double)(8.0 + radius));
    }

    static {
        SHAPE = Shapes.m_83048_((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    }

    public static enum Velocity implements IForgeEnum
    {
        CLIMBING(0.0f, 0.4f, "up"),
        SLIDING(0.0f, 0.8f, "down"),
        SPINNING(0.0f, 0.2f, "around");

        public final FloatBounds bounds;
        private final String direction;

        private Velocity(float min, float max, String direction) {
            this.bounds = FloatBounds.between((Float)Float.valueOf(min), (Float)Float.valueOf(max));
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedBlock.Properties<T> {
        public float speedFactor;

        protected Properties(Class<T> selfClass, String name, UnitId relatedBlockId) {
            super(selfClass, name, relatedBlockId);
        }

        public static Properties<?> of(String name, String relatedBlockId) {
            return new Properties<Properties>(Properties.class, name, UnitId.from((String)relatedBlockId));
        }

        public T speedFactor(float speedFactor) {
            this.speedFactor = speedFactor;
            return (T)((Object)((Properties)this.self));
        }
    }
}

