/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import com.endertech.minecraft.mods.adpoles.client.HolderRenderer;
import com.endertech.minecraft.mods.adpoles.data.MovableApexes;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.endertech.minecraft.mods.adpoles.init.Blocks;
import com.endertech.minecraft.mods.adpoles.init.Entities;
import com.endertech.minecraft.mods.adpoles.init.Items;
import com.endertech.minecraft.mods.adpoles.init.Poles;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import com.endertech.minecraft.mods.adpoles.network.JumpMsg;
import com.endertech.minecraft.mods.adpoles.network.PoleGrabMsg;
import java.util.Locale;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="adpoles")
public class AdPoles
extends AbstractForgeMod {
    public static final String ID = "adpoles";
    public static final String NAME = "To the Bat Poles!";
    private static AdPoles instance;
    public final Poles poles;
    public final Blocks blocks;
    public final Items items;
    public final Entities entities;

    public static AdPoles getInstance() {
        return instance;
    }

    public AdPoles() {
        instance = this;
        this.poles = new Poles(this);
        this.blocks = new Blocks(this);
        this.items = new Items(this);
        this.entities = new Entities(this);
        this.registerCommonConfig();
        this.registerClientConfig();
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(HolderMsg::new);
        this.registerNetMessage(PoleGrabMsg::new);
        this.registerNetMessage(JumpMsg::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        this.setRenderLayer((Block)Poles.BuildIn.GLASS_POLE.get(), RenderType.m_110466_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            this.items.streamAll().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
        this.registerEntityRender((EntityType)this.entities.holder.get(), HolderRenderer::new);
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        Pole.movableApexes = new MovableApexes(value.builder, "List of blocks that can be moved along with the top of the pole", new String[]{"#minecraft:banners", "#forge:chests", "hopper:*", "torch:*", "soul_torch:*", "redstone_torch:*", "campfire:*", "soul_campfire:*"});
        Pole.quickExtension = value.comment("Allows to quickly extend a pole by right-clicking it with a pole item").define("quickExtension", true);
        Pole.maxPolesAtOnce = value.comment("Number of poles that can be placed(when holding pole items in both hands) / broken(when crouching) at once").defineInRange("maxPolesAtOnce", 8, IntBounds.between((Integer)1, (Integer)128));
        value.push("SlidingMechanics");
        for (Poles.OptionalTypes type : Poles.OptionalTypes.values()) {
            String path = String.join((CharSequence)"", UnitId.splitRegName((String)type.name().toLowerCase(Locale.ROOT), (boolean)true, (boolean)false));
            type.enabled = value.comment("Enables/disables sliding mechanics for this type of blocks").define(path, true);
        }
        value.pop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        Holder.switchToThirdPersonView = value.comment("Enables automatic switching to a third-person view while holding the pole").define("switchToThirdPersonView", true);
        Holder.basicSlidingControl = value.comment("Switches between one key 'moveForward' and two keys 'moveForward/moveBackward' controls").define("basicSlidingControl", false);
    }

    public void configUpdated(ModConfig config) {
        if (config.getType() == ModConfig.Type.COMMON) {
            Pole.movableApexes.loadData();
        }
    }

    public void tagsUpdated() {
        Pole.movableApexes.loadData();
    }
}

