/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.datagen;

import com.mrbysco.justaraftmod.init.RaftRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RaftDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput));
            RaftBlockTags blockTags = new RaftBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new RaftItemTags(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Language(packOutput));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, helper));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            this.generateRaftRecipe(RaftRegistry.ACACIA_RAFT, (TagKey<Item>)ItemTags.f_13186_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.BAMBOO_RAFT, (ItemLike)Items.f_41911_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.BIRCH_RAFT, (TagKey<Item>)ItemTags.f_13185_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.CHERRY_RAFT, (TagKey<Item>)ItemTags.f_271202_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.DARK_OAK_RAFT, (TagKey<Item>)ItemTags.f_13183_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.JUNGLE_RAFT, (TagKey<Item>)ItemTags.f_13187_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.MANGROVE_RAFT, (TagKey<Item>)ItemTags.f_215869_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.OAK_RAFT, (TagKey<Item>)ItemTags.f_13184_).m_176498_(consumer);
            this.generateRaftRecipe(RaftRegistry.SPRUCE_RAFT, (TagKey<Item>)ItemTags.f_13188_).m_176498_(consumer);
        }

        private RecipeBuilder generateRaftRecipe(RegistryObject<Item> raft, TagKey<Item> logTag) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)raft.get())).m_126130_("S S").m_126130_("LLL").m_126130_("S S").m_206416_(Character.valueOf('L'), logTag).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126132_("has_log", (CriterionTriggerInstance)Recipes.m_206406_(logTag));
        }

        private RecipeBuilder generateRaftRecipe(RegistryObject<Item> raft, ItemLike log) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)raft.get())).m_126130_("S S").m_126130_("LLL").m_126130_("S S").m_126127_(Character.valueOf('L'), log).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126132_("has_log", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)log));
        }
    }

    public static class RaftBlockTags
    extends BlockTagsProvider {
        public RaftBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "justaraftmod", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
        }
    }

    public static class RaftItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> RAFTS = ItemTags.create((ResourceLocation)new ResourceLocation("justaraftmod", "rafts"));

        public RaftItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider.m_274426_(), "justaraftmod", existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(RAFTS).m_255179_((Object[])new Item[]{(Item)RaftRegistry.OAK_RAFT.get(), (Item)RaftRegistry.SPRUCE_RAFT.get(), (Item)RaftRegistry.BIRCH_RAFT.get(), (Item)RaftRegistry.JUNGLE_RAFT.get(), (Item)RaftRegistry.ACACIA_RAFT.get(), (Item)RaftRegistry.DARK_OAK_RAFT.get(), (Item)RaftRegistry.BAMBOO_RAFT.get(), (Item)RaftRegistry.MANGROVE_RAFT.get(), (Item)RaftRegistry.CHERRY_RAFT.get()});
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "justaraftmod", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.justaraftmod.raft", "Just A Raft Mod");
            this.add("justaraftmod.config.title", "Just Another Raft Config");
            this.addItem((Supplier)RaftRegistry.OAK_RAFT, "Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.SPRUCE_RAFT, "Spruce Log Raft");
            this.addItem((Supplier)RaftRegistry.BIRCH_RAFT, "Birch Log Raft");
            this.addItem((Supplier)RaftRegistry.CHERRY_RAFT, "Cherry Log Raft");
            this.addItem((Supplier)RaftRegistry.JUNGLE_RAFT, "Jungle Log Raft");
            this.addItem((Supplier)RaftRegistry.ACACIA_RAFT, "Acacia Log Raft");
            this.addItem((Supplier)RaftRegistry.DARK_OAK_RAFT, "Dark Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.BAMBOO_RAFT, "Bamboo Raft");
            this.addItem((Supplier)RaftRegistry.MANGROVE_RAFT, "Mangrove Raft");
            this.addEntityType((Supplier)RaftRegistry.RAFT, "Raft");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "justaraftmod", helper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.ACACIA_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/acacia_log"))).texture("log_side", this.mcLoc("block/acacia_log"))).texture("log_top", this.mcLoc("block/acacia_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.BAMBOO_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/bamboo_stalk"))).texture("log_side", this.mcLoc("block/bamboo_stalk"))).texture("log_top", this.mcLoc("block/bamboo_stalk"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.BIRCH_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/birch_log"))).texture("log_side", this.mcLoc("block/birch_log"))).texture("log_top", this.mcLoc("block/birch_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.CHERRY_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/cherry_log"))).texture("log_side", this.mcLoc("block/cherry_log"))).texture("log_top", this.mcLoc("block/cherry_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.DARK_OAK_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/dark_oak_log"))).texture("log_side", this.mcLoc("block/dark_oak_log"))).texture("log_top", this.mcLoc("block/dark_oak_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.JUNGLE_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/jungle_log"))).texture("log_side", this.mcLoc("block/jungle_log"))).texture("log_top", this.mcLoc("block/jungle_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.MANGROVE_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/mangrove_log"))).texture("log_side", this.mcLoc("block/mangrove_log"))).texture("log_top", this.mcLoc("block/mangrove_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.OAK_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/oak_log"))).texture("log_side", this.mcLoc("block/oak_log"))).texture("log_top", this.mcLoc("block/oak_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.SPRUCE_RAFT.getId().m_135815_(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/spruce_log"))).texture("log_side", this.mcLoc("block/spruce_log"))).texture("log_top", this.mcLoc("block/spruce_log_top"));
        }
    }
}

