/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MovingSlidyBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.entities.IFluteParrot;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.SongInstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFluteParrotsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSetSlidingBlockEntityPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSlimedMessage;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<Player> action) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            action.accept((Player)player);
        }
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        Component str;
        SpeakerBlockTile.Mode mode = message.mode;
        Component component = str = Minecraft.m_91087_().m_167974_() ? message.filtered : message.message;
        if (mode == SpeakerBlockTile.Mode.NARRATOR && !ClientConfigs.Blocks.SPEAKER_BLOCK_MUTE.get().booleanValue()) {
            Minecraft.m_91087_().m_240477_().f_93313_.say(str.getString(), true);
        } else if (mode == SpeakerBlockTile.Mode.TITLE) {
            Gui gui = Minecraft.m_91087_().f_91065_;
            gui.m_168713_();
            gui.m_93006_();
            gui.m_168714_(str);
        } else {
            ClientReceivers.withPlayerDo(p -> p.m_5661_(str, mode == SpeakerBlockTile.Mode.STATUS_MESSAGE));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.id);
            if (e != null) {
                e.m_20256_(e.m_20184_().m_82520_(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> PlayerSuggestionBoxWidget.setUsernameCache(message.usernameCache));
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            RandomSource ran = l.f_46441_;
            switch (message.type) {
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.001f, (float)0.01f, (boolean)true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.01f);
                    break;
                }
                case WAX_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)ParticleTypes.f_175828_, (UniformInt)UniformInt.m_146622_((int)3, (int)5), (float)0.01f);
                    break;
                }
                case GLOW_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.m_274446_((Position)message.pos), (ParticleOptions)ParticleTypes.f_175827_, (UniformInt)UniformInt.m_146622_((int)3, (int)5), (float)0.01f);
                    break;
                }
                case BUBBLE_CLEAN_ENTITY: {
                    Entity e;
                    if (message.extraData == null || (e = l.m_6815_(message.extraData.intValue())) == null) break;
                    ParticleUtil.spawnParticleOnBoundingBox((AABB)e.m_20191_(), (Level)l, (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.m_146622_((int)2, (int)4), (float)0.01f);
                    break;
                }
                case BUBBLE_EAT: {
                    Entity entity = l.m_6815_(message.extraData.intValue());
                    Vec3 v = message.dir.m_82541_();
                    double x = entity.m_20185_() + v.f_82479_;
                    double y = entity.m_20188_() + v.f_82480_ - 0.12;
                    double z = entity.m_20189_() + v.f_82481_;
                    for (int j = 0; j < 4; ++j) {
                        v = v.m_82490_(0.1 + (double)(ran.m_188501_() * 0.1f));
                        double dx = v.f_82479_ + (0.5 - (double)ran.m_188501_()) * 0.9;
                        double dy = v.f_82480_ + (0.5 - (double)ran.m_188501_()) * 0.06;
                        double dz = v.f_82481_ + (0.5 - (double)ran.m_188501_()) * 0.9;
                        l.m_7106_((ParticleOptions)ModParticles.SUDS_PARTICLE.get(), x, y, z, dx, dy, dz);
                    }
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.f_82479_ + (double)j1 * 0.6;
                    double d24 = message.pos.f_82480_ + (double)j2 * 0.6;
                    double d28 = message.pos.f_82481_ + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = ran.m_188500_() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (ran.m_188500_() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (ran.m_188500_() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (ran.m_188500_() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + ran.m_188583_() * 0.01;
                        double d10 = (double)j2 * d4 + ran.m_188583_() * 0.01;
                        double d11 = (double)k2 * d4 + ran.m_188583_() * 0.01;
                        l.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
                case FLINT_BLOCK_IGNITE: {
                    if (message.extraData == null || message.pos == null) break;
                    boolean isIronMoving = message.extraData == 1;
                    BlockPos pos = BlockPos.m_274446_((Position)message.pos);
                    for (Direction ironDir : Direction.values()) {
                        BlockPos facingPos = pos.m_121945_(ironDir);
                        BlockState facingState = l.m_8055_(facingPos);
                        if (!(isIronMoving ? facingState.m_60713_(ModRegistry.FLINT_BLOCK.get()) : FlintBlock.canBlockCreateSpark(facingState, l, facingPos, ironDir.m_122424_()))) continue;
                        for (int i = 0; i < 6; ++i) {
                            ParticleUtil.spawnParticleOnFace((Level)l, (BlockPos)facingPos, (Direction)ironDir.m_122424_(), (ParticleOptions)ParticleTypes.f_123797_, (float)-0.5f, (float)0.5f, (boolean)false);
                        }
                    }
                    break;
                }
                case CONFETTI: {
                    ClientReceivers.spawnConfettiParticles(message, l, ran);
                    break;
                }
                case CONFETTI_EXPLOSION: {
                    int radius = message.extraData;
                    ParticleUtil.spawnParticleInASphere((Level)l, (double)message.pos.f_82479_, (double)(message.pos.f_82480_ + 1.0), (double)message.pos.f_82481_, () -> ran.m_188503_(6) == 0 ? (ParticleOptions)ModParticles.STREAMER_PARTICLE.get() : (ParticleOptions)ModParticles.CONFETTI_PARTICLE.get(), (int)(radius * 40), (float)((float)radius / 9.0f), (float)0.05f, (float)(0.15f * (float)radius / 3.0f));
                    l.m_7785_(message.pos.f_82479_, message.pos.f_82480_, message.pos.f_82481_, ModSounds.CONFETTI_POPPER.get(), SoundSource.HOSTILE, 4.0f, ran.m_188501_() * 0.2f + 0.5f, false);
                    break;
                }
                case FEATHER: {
                    int amount = message.extraData == null ? 1 : message.extraData;
                    double dy = Mth.m_14008_((double)(0.03 * message.dir.f_82480_ / 7.0), (double)0.03, (double)0.055);
                    for (int i = 0; i < amount; ++i) {
                        l.m_7106_((ParticleOptions)ModParticles.FEATHER_PARTICLE.get(), message.pos.f_82479_ + ran.m_188583_() * 0.35, message.pos.f_82480_, message.pos.f_82481_ + ran.m_188583_() * 0.35, ran.m_188583_() * 0.007, dy * 0.5, ran.m_188583_() * 0.007);
                    }
                    break;
                }
                case WRENCH_ROTATION: {
                    if (!ClientConfigs.Items.WRENCH_PARTICLES.get().booleanValue()) break;
                    l.m_7106_((ParticleOptions)ModParticles.ROTATION_TRAIL_EMITTER.get(), message.pos.m_7096_(), message.pos.m_7098_(), message.pos.m_7094_(), (double)message.extraData.intValue(), 0.71, -1.0);
                    break;
                }
                case PEARL_TELEPORT: {
                    Vec3 start = message.pos;
                    Vec3 end = message.dir;
                    for (int j = 0; j < 64; ++j) {
                        double delta = ran.m_188500_();
                        float f = (ran.m_188501_() - 0.5f) * 0.2f;
                        float f1 = (ran.m_188501_() - 0.5f) * 0.2f;
                        float f2 = (ran.m_188501_() - 0.5f) * 0.2f;
                        double dx = Mth.m_14139_((double)delta, (double)end.m_7096_(), (double)start.m_7096_()) + (ran.m_188500_() - 0.5);
                        double dy = Mth.m_14139_((double)delta, (double)end.m_7098_(), (double)start.m_7098_()) + (ran.m_188500_() - 0.5) - 0.5;
                        double dz = Mth.m_14139_((double)delta, (double)end.m_7094_(), (double)start.m_7094_()) + (ran.m_188500_() - 0.5);
                        l.m_7106_((ParticleOptions)ParticleTypes.f_123760_, dx, dy, dz, (double)f, (double)f1, (double)f2);
                    }
                    break;
                }
            }
        });
    }

    public static void spawnConfettiParticles(ClientBoundParticlePacket message, Level l, RandomSource ran) {
        float spread = 0.1f;
        Vec3 dir = message.dir;
        Vec3 pos = message.pos;
        float scale = message.extraData != null ? (float)(message.extraData + 1) * 0.8f : 1.0f;
        for (int j = 0; j < 60; ++j) {
            Vector3f facingDir = ClientReceivers.randomizeVector(ran, dir, spread).mul(scale * Mth.m_216267_((RandomSource)ran, (float)0.3f, (float)0.7f));
            SimpleParticleType p = ran.m_188503_(6) == 0 ? ModParticles.STREAMER_PARTICLE.get() : ModParticles.CONFETTI_PARTICLE.get();
            l.m_7106_((ParticleOptions)p, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)facingDir.x, (double)facingDir.y, (double)facingDir.z);
        }
        l.m_7785_(message.pos.f_82479_, message.pos.f_82480_, message.pos.f_82481_, ModSounds.CONFETTI_POPPER.get(), SoundSource.PLAYERS, 1.0f, ran.m_188501_() * 0.2f + 0.8f, false);
    }

    public static void handleSetSlidingBlockEntityPacket(ClientBoundSetSlidingBlockEntityPacket m) {
        ClientReceivers.withLevelDo(l -> {
            if (!(l.m_7702_(m.pos()) instanceof MovingSlidyBlockEntity)) {
                BlockPos pos = m.pos();
                l.m_7731_(m.pos(), m.state(), 64);
                Direction direction = m.direction();
                MovingSlidyBlockEntity be = MovingSlidyBlock.newMovingBlockEntity(pos, m.state(), m.movedState(), direction);
                l.m_151523_((BlockEntity)be);
            }
        });
    }

    private double r(RandomSource random, double a) {
        return a * (double)(random.m_188501_() + random.m_188501_() - 1.0f);
    }

    public static Vector3f randomizeVector(RandomSource random, Vec3 mean, float spread) {
        Vector3f facing = mean.m_252839_();
        Vector3f ort = ClientReceivers.findOrthogonalVector(facing);
        ort.rotateAxis(random.m_188501_() * ((float)Math.PI * 2), facing.x, facing.y, facing.z);
        ort.mul((float)(random.m_188583_() * (double)spread));
        facing.add((Vector3fc)ort).normalize();
        return facing;
    }

    private static Vector3f findOrthogonalVector(Vector3f v) {
        if (Math.abs(v.x) > Math.abs(v.y)) {
            return new Vector3f(-v.z, 0.0f, v.x).normalize();
        }
        return new Vector3f(0.0f, v.z, -v.y).normalize();
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            BlockEntity tile = l.m_7702_(message.pos());
            if (tile != null) {
                AntiqueInkItem.setAntiqueInk(tile, message.ink());
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Player p;
            Item patt16024$temp;
            Entity e = l.m_6815_(message.entityID);
            if (e instanceof Player && (patt16024$temp = (p = (Player)e).m_21211_().m_41720_()) instanceof SongInstrumentItem) {
                SongInstrumentItem instrumentItem = (SongInstrumentItem)patt16024$temp;
                IntListIterator intListIterator = message.notes.iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.m_6263_((Player)Minecraft.m_91087_().f_91074_, p.m_20185_(), p.m_20186_(), p.m_20189_(), instrumentItem.getSound(), SoundSource.PLAYERS, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((Level)l, (LivingEntity)p, note);
                }
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            AbstractContainerMenu container = p.f_36096_;
            if (message.containerId == container.f_38840_ && container instanceof RedMerchantMenu) {
                RedMerchantMenu containerMenu = (RedMerchantMenu)container;
                containerMenu.setOffers(new MerchantOffers(message.offers.m_45388_()));
                containerMenu.setXp(message.villagerXp);
                containerMenu.setMerchantLevel(message.villagerLevel);
                containerMenu.setShowProgressBar(message.showProgress);
                containerMenu.setCanRestock(message.canRestock);
            }
        });
    }

    public static void handleSyncQuiverPacket(SyncEquippedQuiverPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.entityID);
            if (e instanceof IQuiverEntity) {
                IQuiverEntity qe = (IQuiverEntity)e;
                qe.supplementaries$setQuiver(message.quiver);
            }
        });
    }

    public static void handleSyncPartyCreeper(SyncPartyCreeperPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.entityID);
            if (e instanceof IPartyCreeper) {
                IPartyCreeper le = (IPartyCreeper)e;
                le.supplementaries$setFestive(message.on);
            }
        });
    }

    public static void handleParrotPacket(ClientBoundFluteParrotsPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.playerId());
            if (e == null) {
                Supplementaries.LOGGER.error("Entity not found for parrot packet");
                return;
            }
            if (message.playing() && e instanceof Player) {
                Player p = (Player)e;
                BlockPos pos = e.m_20183_();
                List list = l.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(3.0));
                for (LivingEntity livingEntity : list) {
                    if (!(livingEntity instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)livingEntity;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
            ClientReceivers.setDisplayParrotsPartying(l, (Either<Player, BlockPos>)Either.left((Object)((Player)e)), message.playing());
        });
    }

    public static void setDisplayParrotsPartying(Level level, Either<Player, BlockPos> source, boolean isPartying) {
        BlockPos pos = source.right().isPresent() ? (BlockPos)source.right().get() : ((Player)source.left().get()).m_20183_();
        List list = level.m_45976_(Player.class, new AABB(pos).m_82400_(3.0));
        for (Player player : list) {
            CompoundTag r;
            CompoundTag l = player.m_36331_();
            if (l != null) {
                l.m_128379_("record_playing", isPartying);
            }
            if ((r = player.m_36332_()) == null) continue;
            r.m_128379_("record_playing", isPartying);
        }
        Player p = source.left().orElse(null);
        int r = 3;
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        for (int x = pos.m_123341_() - r; x < pos.m_123341_() + r; ++x) {
            for (int y = pos.m_123342_() - r; y < pos.m_123342_() + r; ++y) {
                for (int z = pos.m_123343_() - r; z < pos.m_123343_() + r; ++z) {
                    BlockEntity blockEntity = level.m_7702_((BlockPos)mut.m_122178_(x, y, z));
                    if (!(blockEntity instanceof IMobContainerProvider)) continue;
                    IMobContainerProvider te = (IMobContainerProvider)blockEntity;
                    MobContainer container = te.getMobContainer();
                    Entity e = container.getDisplayedMob();
                    if (p == null && e instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)e;
                        le.m_6818_(pos, isPartying);
                        continue;
                    }
                    if (p == null || !(e instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)e;
                    if (!isPartying) continue;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
        }
    }

    public static void handleExplosionPacket(ClientBoundExplosionPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            Vec3 pos = packet.pos();
            float power = packet.power();
            List<BlockPos> toBlow = packet.toBlow();
            Vec3 knockback = packet.knockback();
            switch (packet.type()) {
                case BOMB: {
                    BombExplosion explosion = new BombExplosion((Level)l, null, pos.f_82479_, pos.f_82480_, pos.f_82481_, power, toBlow, BombEntity.BombType.values()[packet.getId()]);
                    explosion.m_46075_(true);
                    if (knockback == null) break;
                    ClientReceivers.withPlayerDo(p -> p.m_20256_(p.m_20184_().m_82520_(knockback.f_82479_, knockback.f_82480_, knockback.f_82481_)));
                    break;
                }
                case CANNONBALL: {
                    CannonBallExplosion explosion = new CannonBallExplosion((Level)l, null, pos.f_82479_, pos.f_82480_, pos.f_82481_, power, toBlow);
                    explosion.m_46075_(true);
                    Entity patt21792$temp = l.m_6815_(packet.getId());
                    if (!(patt21792$temp instanceof CannonBallEntity)) break;
                    CannonBallEntity le = (CannonBallEntity)patt21792$temp;
                    if (knockback == null) break;
                    le.m_20256_(knockback);
                    break;
                }
                case GUNPOWDER: {
                    GunpowderExplosion explosion = new GunpowderExplosion((Level)l, null, pos.f_82479_, pos.f_82480_, pos.f_82481_, power);
                    explosion.m_46075_(true);
                }
            }
        });
    }

    public static void handleSyncSlimed(ClientBoundSyncSlimedMessage message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.id());
            if (e instanceof ISlimeable) {
                ISlimeable s = (ISlimeable)e;
                s.supp$setSlimedTicks(message.duration(), false);
            }
        });
    }

    public static void handleCannonControlPacket(ClientBoundControlCannonPacket message) {
        ClientReceivers.withLevelDo(l -> {
            BlockEntity patt22678$temp = l.m_7702_(message.pos());
            if (patt22678$temp instanceof CannonBlockTile) {
                CannonBlockTile te = (CannonBlockTile)patt22678$temp;
                CannonController.startControlling(te);
            }
        });
    }
}

