/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DumboOctopusEntity
extends WaterAnimal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int restTimer;
    protected boolean bubblingPlayer;
    protected ServerPlayer bubbledPlayer;

    public DumboOctopusEntity(EntityType<? extends DumboOctopusEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DumboOctopusMoveControl(90, 90, 1.0f, 1.0f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 180);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.06);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double distance) {
        return !this.m_27487_() && !this.m_8077_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RESTING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BubblePlayerGoal());
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal(this, 1.0, 40));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Resting", this.isResting());
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setResting(compound.m_128471_("Resting"));
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack bucketStack) {
        CompoundTag bucketCompound = bucketStack.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucketStack);
        bucketCompound.m_128405_("BucketVariant", this.getVariant());
    }

    public void m_142278_(CompoundTag bucketCompound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)bucketCompound);
        if (bucketCompound.m_128441_("BucketVariant")) {
            this.setVariant(bucketCompound.m_128451_("BucketVariant"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)CACItems.DUMBO_OCTOPUS_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && !this.bubblingPlayer && this.m_21515_()) {
            if (this.m_20069_()) {
                if (this.isResting()) {
                    if (--this.restTimer <= 0) {
                        this.setResting(false);
                    }
                    this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
                } else if (this.f_19796_.m_188501_() <= 0.001f) {
                    this.restTimer = this.f_19796_.m_216339_(200, 601);
                    this.setResting(true);
                }
            } else {
                this.setResting(false);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 speed) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), speed);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(speed);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        this.setVariant(this.f_19796_.m_216339_(0, 4));
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isResting()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_idle"));
        } else if (this.m_20069_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_swim"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_on_land"));
        }
        return PlayState.CONTINUE;
    }

    public void sendBubble(ServerPlayer player, boolean state) {
        if (!(player instanceof IBubbleState)) {
            return;
        }
        IBubbleState bubbleState = (IBubbleState)player;
        bubbleState.setBubbleActive(state);
        CACPacketHandler.BUBBLE_STATE.sendToTracking((Entity)player, new ClientboundBubbleStatePacket(state, player.m_19879_()));
    }

    public ServerPlayer getBubbledPlayer() {
        return this.bubbledPlayer;
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public void setResting(boolean resting) {
        this.f_19804_.m_135381_(RESTING, (Object)resting);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)3));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class DumboOctopusMoveControl
    extends SmoothSwimmingMoveControl {
        public DumboOctopusMoveControl(int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            super((Mob)DumboOctopusEntity.this, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, applyGravity);
        }

        public void m_8126_() {
            if (!DumboOctopusEntity.this.isResting()) {
                super.m_8126_();
            }
        }
    }

    class BubblePlayerGoal
    extends Goal {
        private final Level level;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private boolean bubbleSent;

        public BubblePlayerGoal() {
            this.level = DumboOctopusEntity.this.m_9236_();
            this.navigation = DumboOctopusEntity.this.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            ServerPlayer player = (ServerPlayer)this.level.m_45930_((Entity)DumboOctopusEntity.this, 6.0);
            if (player != null && player.m_20146_() < 150) {
                DumboOctopusEntity.this.bubbledPlayer = player;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return DumboOctopusEntity.this.bubbledPlayer != null && DumboOctopusEntity.this.bubbledPlayer.m_6084_() && DumboOctopusEntity.this.bubbledPlayer.m_20146_() <= 150;
        }

        public void m_8056_() {
            DumboOctopusEntity.this.bubblingPlayer = true;
            this.timeToRecalcPath = 0;
        }

        public void m_8037_() {
            DumboOctopusEntity.this.m_21563_().m_24960_((Entity)DumboOctopusEntity.this.bubbledPlayer, 10.0f, (float)DumboOctopusEntity.this.m_8132_());
            if (DumboOctopusEntity.this.m_20280_((Entity)DumboOctopusEntity.this.bubbledPlayer) > 2.0) {
                --this.timeToRecalcPath;
                if (this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.m_183277_(10);
                    if (!DumboOctopusEntity.this.m_21523_() && !DumboOctopusEntity.this.m_20159_()) {
                        this.navigation.m_5624_((Entity)DumboOctopusEntity.this.bubbledPlayer, 2.0);
                    }
                }
            } else if (!this.bubbleSent) {
                DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, true);
                this.bubbleSent = true;
            }
            if (this.bubbleSent) {
                DumboOctopusEntity.this.bubbledPlayer.m_20301_(150);
            }
        }

        public void m_8041_() {
            DumboOctopusEntity.this.bubblingPlayer = false;
            DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, false);
            this.bubbleSent = false;
            DumboOctopusEntity.this.bubbledPlayer.m_216990_((SoundEvent)CACSounds.BUBBLE_POP.get());
            DumboOctopusEntity.this.bubbledPlayer = null;
            this.navigation.m_26573_();
        }
    }

    static class RandomSwimmingGoal
    extends net.minecraft.world.entity.ai.goal.RandomSwimmingGoal {
        private final DumboOctopusEntity dumboOctopus;

        public RandomSwimmingGoal(DumboOctopusEntity dumboOctopus, double speedModifier, int interval) {
            super((PathfinderMob)dumboOctopus, speedModifier, interval);
            this.dumboOctopus = dumboOctopus;
        }

        public boolean m_8036_() {
            return !this.dumboOctopus.isResting() && super.m_8036_();
        }
    }
}

