/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.AddItemModifier;
import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.CrittersAndCompanionsClient;
import com.github.eterdelta.crittersandcompanions.ReplaceItemModifier;
import com.github.eterdelta.crittersandcompanions.handler.PlayerHandler;
import com.github.eterdelta.crittersandcompanions.platform.ForgeConfigs;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.PathPackResources;

@Mod(value="crittersandcompanions")
@Mod.EventBusSubscriber(modid="crittersandcompanions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CrittersAndCompanionsForge {
    public CrittersAndCompanionsForge() {
        ForgeConfigs.register(ModLoadingContext.get());
        CrittersAndCompanions.init();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> event.enqueueWork(CrittersAndCompanions::setup));
        modBus.addListener(event -> event.enqueueWork(CrittersAndCompanionsClient::init));
        DeferredRegister lootModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"crittersandcompanions");
        lootModifiers.register("replace_item", () -> ReplaceItemModifier.CODEC);
        lootModifiers.register("add_item", () -> AddItemModifier.CODEC);
        lootModifiers.register(modBus);
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFile modFile = ModList.get().getModFileById("crittersandcompanions").getFile();
            Path resourcePath = modFile.findResource(new String[]{"resourcepacks/friendlyart"});
            try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + String.valueOf(resourcePath), true, resourcePath);){
                event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"builtin/crittersandcompanions", (Component)Component.m_237113_((String)"Friendly Critter Art"), (boolean)false, ignored -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_)));
            }
        }
    }

    @SubscribeEvent
    public static void onAttributeCreation(EntityAttributeCreationEvent event) {
        CrittersAndCompanions.onAttributeCreation((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    @Mod.EventBusSubscriber(modid="crittersandcompanions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
            UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), null);
            InteractionResult result = PlayerHandler.onPlayerEntityInteract(event.getTarget(), context);
            if (result != null) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            PlayerHandler.onPlayerTick(event.player);
        }

        @SubscribeEvent
        public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
            PlayerHandler.onPlayerStartTracking(event.getTarget(), (Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerStopTracking(PlayerEvent.StopTracking event) {
            PlayerHandler.onPlayerStopTracking(event.getTarget(), (Entity)event.getEntity());
        }
    }
}

