/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModifiedExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.m_216327_();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @javax.annotation.Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final SoundEvent soundEvent;

    public ModifiedExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator explosionDamageCalculator, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction blockInteraction, SoundEvent soundEvent) {
        super(level, source, damageSource, explosionDamageCalculator, x, y, z, radius, causesFire, blockInteraction);
        this.blockInteraction = blockInteraction;
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.source = source;
        this.radius = radius;
        this.fire = causesFire;
        this.damageSource = damageSource == null ? level.m_269111_().m_269093_((Explosion)this) : damageSource;
        this.damageCalculator = explosionDamageCalculator == null ? this.m_46062_(source) : explosionDamageCalculator;
        this.soundEvent = soundEvent;
    }

    private ExplosionDamageCalculator m_46062_(@javax.annotation.Nullable Entity $$0) {
        return $$0 == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator($$0);
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> gameRules) {
        return this.level.m_46469_().m_46207_(gameRules) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    public Explosion blockExplosion(double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, SoundEvent soundEvent) {
        return this.blockExplosion(null, null, null, x, y, z, radius, fire, explosionInteraction, true, soundEvent);
    }

    public Explosion blockExplosion(double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean spawnParticles, SoundEvent soundEvent) {
        return this.blockExplosion(null, null, null, x, y, z, radius, fire, explosionInteraction, spawnParticles, soundEvent);
    }

    public Explosion blockExplosion(@Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator explosionDamageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean spawnParticles, SoundEvent soundEvent) {
        Explosion.BlockInteraction interaction = switch (explosionInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.f_254629_);
            case Level.ExplosionInteraction.MOB -> {
                if (this.level.m_46469_().m_46207_(GameRules.f_46132_)) {
                    yield this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.f_254692_);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.f_254705_);
        };
        ModifiedExplosion modifiedExplosion = new ModifiedExplosion(this.level, entity, damageSource, explosionDamageCalculator, x, y, z, radius, fire, interaction, soundEvent);
        modifiedExplosion.m_46061_();
        modifiedExplosion.m_46075_(spawnParticles);
        return modifiedExplosion;
    }

    public Explosion blockExplosionV2(ModifiedExplosion modifiedExplosion) {
        modifiedExplosion.m_46061_();
        modifiedExplosion.m_46075_(true);
        return modifiedExplosion;
    }

    public static void blockSourceExplosion(Level level, Block block, double x, double y, double z, float radius, Explosion.BlockInteraction interaction, SoundEvent soundEvent) {
        ModifiedExplosion modifiedExplosion = new ModifiedExplosion(level, null, null, null, x, y, z, radius, false, interaction, soundEvent);
        modifiedExplosion.m_46061_();
        modifiedExplosion.m_46075_(true);
    }

    public void m_46075_(boolean spawnParticle) {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, this.soundEvent, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean $$1 = this.m_254884_();
        if (spawnParticle) {
            if (!(this.radius < 2.0f) && $$1) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if ($$1) {
            ObjectArrayList $$2 = new ObjectArrayList();
            boolean $$3 = this.m_252906_() instanceof Player;
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos $$4 : this.toBlow) {
                Level $$9;
                BlockState $$5 = this.level.m_8055_($$4);
                Block $$6 = $$5.m_60734_();
                if ($$5.m_60795_()) continue;
                BlockPos $$7 = $$4.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if ($$6.m_6903_((Explosion)this) && ($$9 = this.level) instanceof ServerLevel) {
                    ServerLevel $$8 = (ServerLevel)$$9;
                    BlockEntity $$9x = $$5.m_155947_() ? this.level.m_7702_($$4) : null;
                    LootParams.Builder $$10 = new LootParams.Builder($$8).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)$$4)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)$$9x).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        $$10.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    $$5.m_222967_($$8, $$4, ItemStack.f_41583_, $$3);
                    $$5.m_287290_($$10).forEach($$2x -> ModifiedExplosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)$$2, $$2x, $$7));
                }
                this.level.m_7731_($$4, Blocks.f_50016_.m_49966_(), 3);
                $$6.m_7592_(this.level, $$4, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair $$11 : $$2) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)$$11.getSecond()), (ItemStack)((ItemStack)$$11.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos $$12 : this.toBlow) {
                if (this.random.m_188503_(3) != 0 || !this.level.m_8055_($$12).m_60795_() || !this.level.m_8055_($$12.m_7495_()).m_60804_((BlockGetter)this.level, $$12.m_7495_())) continue;
                this.level.m_46597_($$12, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)$$12));
            }
        }
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> $$0, ItemStack $$1, BlockPos $$2) {
        int $$3 = $$0.size();
        for (int $$4 = 0; $$4 < $$3; ++$$4) {
            Pair $$5 = (Pair)$$0.get($$4);
            ItemStack $$6 = (ItemStack)$$5.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)$$6, (ItemStack)$$1)) continue;
            ItemStack $$7 = ItemEntity.m_32029_((ItemStack)$$6, (ItemStack)$$1, (int)16);
            $$0.set($$4, (Object)Pair.of((Object)$$7, (Object)((BlockPos)$$5.getSecond())));
            if (!$$1.m_41619_()) continue;
            return;
        }
        $$0.add((Object)Pair.of((Object)$$1, (Object)$$2));
    }
}

