/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.sound.DNLTickingSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class EntityTickingSound
extends AbstractTickableSoundInstance
implements DNLTickingSound {
    private static final float MINIMUM_AUDIBLE_VOLUME = 0.01f;
    protected final Entity entity;
    private boolean fadingOut = false;
    private boolean fadingIn = false;
    private final float fadeStartDistance;
    private boolean stopWhenOutOfRange = true;
    private boolean shouldStop = false;
    private int fadeTicks = 20;
    private int currentFade = 0;
    private final float range;
    private float maxVolume;
    private float fadeVolume = 1.0f;
    private float distanceVolume = 1.0f;

    public EntityTickingSound(SoundEvent sound, SoundSource soundSource, Entity entity, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        super(sound, soundSource, SoundInstance.m_235150_());
        this.entity = entity;
        this.f_119578_ = false;
        this.maxVolume = maxVolume;
        this.f_119574_ = pitch;
        this.stopWhenOutOfRange = stopWhenOutOfRange;
        this.range = range;
        this.fadeStartDistance = fadeStartDistance;
        this.f_119575_ = entity.m_20185_();
        this.f_119576_ = entity.m_20186_();
        this.f_119577_ = entity.m_20189_();
        this.f_119573_ = this.maxVolume == 0.0f ? 0.01f : this.maxVolume;
    }

    public EntityTickingSound(SoundEvent sound, SoundSource soundSource, Entity entity, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range) {
        this(sound, soundSource, entity, maxVolume, pitch, stopWhenOutOfRange, range, 0.0f);
    }

    public void m_7788_() {
        this.f_119575_ = this.entity.m_20185_();
        this.f_119576_ = this.entity.m_20186_();
        this.f_119577_ = this.entity.m_20189_();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && !localPlayer.equals((Object)this.entity)) {
            float distance = localPlayer.m_20270_(this.entity);
            if (this.stopWhenOutOfRange && distance > this.range) {
                this.m_119609_();
                return;
            }
            if (distance <= this.fadeStartDistance) {
                this.distanceVolume = 1.0f;
            } else {
                float maxFadeDistance = 2.0f * this.range - this.fadeStartDistance;
                float fadeDistance = Math.min(distance - this.fadeStartDistance, maxFadeDistance);
                this.distanceVolume = Math.max(0.0f, 1.0f - fadeDistance / maxFadeDistance);
            }
        } else {
            this.distanceVolume = 1.0f;
        }
        if (this.fadingIn) {
            ++this.currentFade;
            this.fadeVolume = (float)this.currentFade / (float)this.fadeTicks;
            if (this.currentFade >= this.fadeTicks) {
                this.fadeVolume = 1.0f;
                this.fadingIn = false;
            }
        }
        if (this.fadingOut) {
            ++this.currentFade;
            this.fadeVolume = 1.0f - (float)this.currentFade / (float)this.fadeTicks;
            if ((this.shouldStop || this.stopWhenOutOfRange) && this.currentFade >= this.fadeTicks) {
                this.m_119609_();
                return;
            }
        }
        this.f_119573_ = this.maxVolume * this.fadeVolume * this.distanceVolume;
        if (!this.entity.m_6084_()) {
            this.m_119609_();
        }
    }

    @Override
    public void startFadingOut(boolean shouldStop, int fadeTicks) {
        this.fadingOut = true;
        this.shouldStop = shouldStop;
        this.fadeTicks = fadeTicks;
        this.currentFade = 0;
    }

    @Override
    public void startFadingIn(float maxVolume, int fadeTicks) {
        this.fadingIn = true;
        this.maxVolume = maxVolume;
        this.fadeTicks = fadeTicks;
        this.currentFade = 0;
    }

    @Override
    public void stopExternally() {
        this.m_119609_();
    }
}

