/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.sound.DNLTickingSound;
import dev.hexnowloading.dungeonnowloading.sound.EntityTickingSound;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class DNLClientSoundHandler {
    private static final Map<ResourceLocation, Map<Integer, Map<Integer, List<AbstractTickableSoundInstance>>>> activeSounds = new HashMap<ResourceLocation, Map<Integer, Map<Integer, List<AbstractTickableSoundInstance>>>>();

    public static void playTickingSound(ResourceLocation soundId, SoundSource soundSource, Entity entity, int tagId, float volume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId);
        if (sound == null) {
            return;
        }
        int entityId = entity.m_19879_();
        Map entityMap = activeSounds.computeIfAbsent(soundId, k -> new HashMap());
        Map tagMap = entityMap.computeIfAbsent(entityId, k -> new HashMap());
        if (tagId == -1) {
            tagId = tagMap.keySet().stream().mapToInt(i -> i).max().orElse(-1) + 1;
        }
        EntityTickingSound instance = new EntityTickingSound(sound, soundSource, entity, volume, pitch, stopWhenOutOfRange, range, fadeStartDistance);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
        tagMap.computeIfAbsent(tagId, k -> new ArrayList()).add(instance);
    }

    public static void fadeInTickingSound(ResourceLocation soundId, int entityId, TickingSoundTarget target, int specificTagId, float maxVolume, int fadeInTicks) {
        Map<Integer, Map<Integer, List<AbstractTickableSoundInstance>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null) {
            return;
        }
        Map<Integer, List<AbstractTickableSoundInstance>> tagMap = entityMap.get(entityId);
        if (tagMap == null || tagMap.isEmpty()) {
            return;
        }
        if (target == TickingSoundTarget.ALL) {
            for (List<AbstractTickableSoundInstance> list : tagMap.values()) {
                for (AbstractTickableSoundInstance instance : list) {
                    if (!(instance instanceof DNLTickingSound)) continue;
                    DNLTickingSound dnl = (DNLTickingSound)instance;
                    dnl.startFadingIn(maxVolume, fadeInTicks);
                }
            }
            return;
        }
        int tagId = DNLClientSoundHandler.resolveTagId(target, tagMap, specificTagId);
        if (tagId == -1) {
            return;
        }
        List<AbstractTickableSoundInstance> list = tagMap.get(tagId);
        if (list == null) {
            return;
        }
        for (AbstractTickableSoundInstance instance : list) {
            if (!(instance instanceof DNLTickingSound)) continue;
            DNLTickingSound dnl = (DNLTickingSound)instance;
            dnl.startFadingIn(maxVolume, fadeInTicks);
        }
    }

    public static void fadeOutTickingSound(ResourceLocation soundId, int entityId, TickingSoundTarget target, int specificTagId, int fadeTicks, boolean shouldStop) {
        Map<Integer, Map<Integer, List<AbstractTickableSoundInstance>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null) {
            return;
        }
        Map<Integer, List<AbstractTickableSoundInstance>> tagMap = entityMap.get(entityId);
        if (tagMap == null || tagMap.isEmpty()) {
            return;
        }
        if (target == TickingSoundTarget.ALL) {
            for (List<AbstractTickableSoundInstance> list : tagMap.values()) {
                for (AbstractTickableSoundInstance instance : list) {
                    if (!(instance instanceof DNLTickingSound)) continue;
                    DNLTickingSound dnl = (DNLTickingSound)instance;
                    dnl.startFadingOut(shouldStop, fadeTicks);
                }
            }
            entityMap.remove(entityId);
            if (entityMap.isEmpty()) {
                activeSounds.remove(soundId);
            }
            return;
        }
        int tagId = DNLClientSoundHandler.resolveTagId(target, tagMap, specificTagId);
        if (tagId == -1) {
            return;
        }
        List<AbstractTickableSoundInstance> list = tagMap.remove(tagId);
        if (list == null) {
            return;
        }
        for (AbstractTickableSoundInstance instance : list) {
            if (!(instance instanceof DNLTickingSound)) continue;
            DNLTickingSound dnl = (DNLTickingSound)instance;
            dnl.startFadingOut(shouldStop, fadeTicks);
        }
        if (tagMap.isEmpty()) {
            entityMap.remove(entityId);
        }
        if (entityMap.isEmpty()) {
            activeSounds.remove(soundId);
        }
    }

    private static int resolveTagId(TickingSoundTarget target, Map<Integer, List<AbstractTickableSoundInstance>> tagMap, int specificTagId) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case TickingSoundTarget.OLDEST -> tagMap.keySet().stream().min(Integer::compareTo).orElse(-1);
            case TickingSoundTarget.NEWEST -> tagMap.keySet().stream().max(Integer::compareTo).orElse(-1);
            case TickingSoundTarget.SPECIFIC -> specificTagId;
            case TickingSoundTarget.ALL -> throw new IllegalStateException("ALL is not a valid target for resolveTagId");
        };
    }

    public static boolean isTickingSoundActive(ResourceLocation soundId) {
        Map<Integer, Map<Integer, List<AbstractTickableSoundInstance>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null || entityMap.isEmpty()) {
            return false;
        }
        for (Map<Integer, List<AbstractTickableSoundInstance>> tagMap : entityMap.values()) {
            for (List<AbstractTickableSoundInstance> instances : tagMap.values()) {
                for (AbstractTickableSoundInstance instance : instances) {
                    if (instance.m_7801_()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

