/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.screen;

import dev.hexnowloading.dungeonnowloading.block.client.renderer.PlayerStatueRenderer;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.network.packets.C2SPedestalUpdatePacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PedestalEditScreen
extends Screen {
    private static final ResourceLocation PREVIEW_TEX = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal_side.png");
    private static final int MAX_CHARS = 16;
    private final BlockPos pos;
    private final DyeColor color;
    private final boolean glowing;
    private String line = "";
    private TextFieldHelper field;
    private int frame;
    private int maxTextPixels;
    private boolean sent = false;

    public PedestalEditScreen(BlockPos pos, List<Component> lines, DyeColor color, boolean glowing) {
        super((Component)Component.m_237115_((String)"screen.dnl.pedestal_edit"));
        this.pos = pos.m_7949_();
        this.color = color != null ? color : DyeColor.BLACK;
        this.glowing = glowing;
        if (lines != null && !lines.isEmpty() && lines.get(0) != null) {
            this.line = lines.get(0).getString();
        }
    }

    protected void m_7856_() {
        int btnW = 100;
        int btnH = 20;
        int y = this.f_96544_ / 4 + 144;
        this.maxTextPixels = PlayerStatueRenderer.pedestalMaxTextPixels(this.f_96547_);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, b -> {
            this.sendUpdate();
            this.f_96541_.m_91152_(null);
        }).m_252987_(this.f_96543_ / 2 - btnW - 4, y, btnW, btnH).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 + 4, y, btnW, btnH).m_253136_());
        this.field = new TextFieldHelper(() -> this.line, this::setMessage, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), s -> s.length() <= 16);
        this.field.m_95193_();
    }

    private void sendUpdate() {
        if (this.sent) {
            return;
        }
        this.sent = true;
        System.out.println("[PedestalEditScreen] sending line=\"" + this.line + "\" to server @ " + this.pos);
        Services.NETWORK.sendToServer(new C2SPedestalUpdatePacket(this.pos, List.of(Component.m_237113_((String)this.line)), this.color, this.glowing));
    }

    public void m_7861_() {
        if (this.sent) {
            return;
        }
        this.sent = true;
        System.out.println("[PedestalEditScreen] sending line=\"" + this.line + "\" to server @ " + this.pos);
        Services.NETWORK.sendToServer(new C2SPedestalUpdatePacket(this.pos, List.of(Component.m_237113_((String)this.line)), this.color, this.glowing));
    }

    public void m_86600_() {
        ++this.frame;
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 257 || key == 335) {
            this.sendUpdate();
            this.f_96541_.m_91152_(null);
            return true;
        }
        return this.field.m_95145_(key) || super.m_7933_(key, scancode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.field.m_95143_(codePoint);
        return true;
    }

    private void setMessage(String s) {
        BlockEntity be;
        if (s.length() > 16) {
            s = s.substring(0, 16);
        }
        this.line = s;
        Minecraft mc = this.f_96541_;
        if (mc != null && mc.f_91073_ != null && (be = mc.f_91073_.m_7702_(this.pos)) instanceof PlayerStatueBlockEntity) {
            PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
            ArrayList<Component> lines = new ArrayList<Component>(4);
            lines.add((Component)Component.m_237113_((String)this.line));
            lines.add((Component)Component.m_237119_());
            lines.add((Component)Component.m_237119_());
            lines.add((Component)Component.m_237119_());
            statue.setAllText(lines, this.color, this.glowing);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        g.m_280168_().m_85836_();
        int cx = this.f_96543_ / 2;
        int cy = 90;
        int texW = 16;
        int texH = 16;
        int drawW = texW * 5;
        int drawH = texH * 5;
        g.m_280411_(PREVIEW_TEX, cx - drawW / 2, cy - drawH / 2, drawW, drawH, 0.0f, 0.0f, texW, texH, texW, texH);
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        g.m_280168_().m_252880_((float)cx, (float)cy, 0.0f);
        String toDraw = this.f_96547_.m_92718_() ? this.f_96547_.m_92801_(this.line) : this.line;
        int rawW = this.f_96547_.m_92895_(toDraw);
        float fit = 1.0f;
        if (rawW > this.maxTextPixels) {
            fit = (float)this.maxTextPixels / (float)rawW;
        }
        g.m_280168_().m_85841_(fit, fit, 1.0f);
        int textColor = this.color.m_41071_();
        boolean caretBlink = this.frame / 6 % 2 == 0;
        int cursor = this.field.m_95194_();
        int sel = this.field.m_95197_();
        Objects.requireNonNull(this.f_96547_);
        int baseY = -9 / 2;
        int x0 = -rawW / 2;
        g.m_280056_(this.f_96547_, toDraw, x0, baseY, textColor, false);
        if (caretBlink && cursor >= 0 && cursor == toDraw.length()) {
            int xCaret = this.f_96547_.m_92895_(toDraw) - rawW / 2;
            g.m_280056_(this.f_96547_, "_", xCaret, baseY, textColor, false);
        }
        if (cursor != sel) {
            int a = Math.min(cursor, sel);
            int b = Math.max(cursor, sel);
            int xA = this.f_96547_.m_92895_(toDraw.substring(0, a)) - rawW / 2;
            int xB = this.f_96547_.m_92895_(toDraw.substring(0, b)) - rawW / 2;
            int yTop = baseY - 1;
            Objects.requireNonNull(this.f_96547_);
            int yBot = baseY + 9;
            g.m_285944_(RenderType.m_285783_(), xA, yTop, xB, yBot, -16776961);
        }
        g.m_280168_().m_85849_();
        g.m_280168_().m_85849_();
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    private void onDone() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }
}

