/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.game_event_listener;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.block.MendingAuraBlock;
import dev.hexnowloading.dungeonnowloading.block.PreserverBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.MendingAuraBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.MendstoneChalkMarkBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.PreserverBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLGameEvents;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockBurnManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockDestructionManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.ContainerDropManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.ExplosionDestructionManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.PistonPushManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public interface PreserverBlockDestructionSystem {
    public User getUser();

    public static class Listener
    implements GameEventListener {
        private final PreserverBlockDestructionSystem system;

        public Listener(PreserverBlockDestructionSystem system) {
            this.system = system;
        }

        public BlockPos getBlockPos() {
            return this.system.getUser().getBlockPos();
        }

        public PositionSource m_142460_() {
            return this.system.getUser().getPositionSource();
        }

        public int m_142078_() {
            BlockPos absCornerA = this.system.getUser().getBlockPos().m_121955_((Vec3i)this.system.getUser().getCornerA());
            BlockPos absCornerB = this.system.getUser().getBlockPos().m_121955_((Vec3i)this.system.getUser().getCornerB());
            int maxDistance = Math.max(Math.abs(absCornerA.m_123341_() - absCornerB.m_123341_()), Math.max(Math.abs(absCornerA.m_123342_() - absCornerB.m_123342_()), Math.abs(absCornerA.m_123343_() - absCornerB.m_123343_())));
            return Listener.squareRegionCalculation(maxDistance);
        }

        public static int squareRegionCalculation(int centerToSideDistance) {
            return (int)Math.ceil((double)centerToSideDistance * Math.sqrt(3.0));
        }

        public static int reverseSquareRegionCalculation(int y) {
            return (int)Math.floor((double)y / Math.sqrt(3.0));
        }

        public boolean m_214068_(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 pos) {
            BlockPos eventBlockPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_), (int)Math.floor(pos.f_82481_));
            Vec3 centerPos = (Vec3)this.m_142460_().m_142502_((Level)serverLevel).orElseThrow();
            BlockPos centerBlockPos = new BlockPos((int)Math.floor(centerPos.f_82479_), (int)Math.floor(centerPos.f_82480_), (int)Math.floor(centerPos.f_82481_));
            User user = this.system.getUser();
            if (!user.isInsideRegion((Level)serverLevel, eventBlockPos, centerBlockPos)) {
                return false;
            }
            if (gameEvent == DNLGameEvents.PLAYER_BLOCK_DESTROY_EARLY.get()) {
                PreserverBlockEntity preserverBlock;
                BlockEntity blockEntity = serverLevel.m_7702_(centerBlockPos);
                if (blockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)blockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                blockEntity = context.f_223711_();
                if (blockEntity instanceof Player) {
                    Player player = (Player)blockEntity;
                    if (player.m_150110_().f_35937_) {
                        return false;
                    }
                }
                if (serverLevel.m_8055_(eventBlockPos).m_60734_() instanceof MendingAuraBlock) {
                    BlockDestructionManager.cancel();
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_60734_() instanceof PreserverBlock) {
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_204336_(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                BlockState originalBlockState = serverLevel.m_8055_(eventBlockPos);
                BlockEntity originalBlockEntity = serverLevel.m_7702_(eventBlockPos);
                CompoundTag compoundTag = new CompoundTag();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.m_187480_();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockDestructionManager.cancel();
                BlockEntity blockEntity2 = serverLevel.m_7702_(eventBlockPos);
                if (blockEntity2 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity3 = (MendingAuraBlockEntity)blockEntity2;
                    blockEntity3.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((blockEntity2 = serverLevel.m_8055_(centerBlockPos).m_60734_()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock2 = (PreserverBlock)blockEntity2;
                    preserverBlock2.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.m_5594_(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_DESTROY_EARLY.get()) {
                PreserverBlockEntity preserverBlock;
                if (serverLevel.m_8055_(eventBlockPos).m_60795_()) {
                    return false;
                }
                BlockEntity originalBlockEntity = serverLevel.m_7702_(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.m_7702_(centerBlockPos) instanceof MendstoneChalkMarkBlockEntity && context.f_223711_() != null && context.f_223711_().m_6095_().m_204039_(DNLTags.BOSSES_AND_RELATED_DESTRUCTIVES)) {
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_60734_() instanceof MendingAuraBlock) {
                    BlockDestructionManager.cancel();
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_60734_() instanceof PreserverBlock) {
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_204336_(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                BlockState originalBlockState = serverLevel.m_8055_(eventBlockPos);
                originalBlockEntity = serverLevel.m_7702_(eventBlockPos);
                CompoundTag compoundTag = new CompoundTag();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.m_187480_();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockDestructionManager.cancel();
                BlockEntity blockEntity = serverLevel.m_7702_(eventBlockPos);
                if (blockEntity instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity4 = (MendingAuraBlockEntity)blockEntity;
                    blockEntity4.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((blockEntity = serverLevel.m_8055_(centerBlockPos).m_60734_()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock3 = (PreserverBlock)blockEntity;
                    preserverBlock3.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.m_5594_(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_DESTROYED_BY_EXPLOSION.get()) {
                PreserverBlockEntity preserverBlock;
                if (serverLevel.m_8055_(eventBlockPos).m_60795_()) {
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_60734_() instanceof MendingAuraBlock) {
                    ExplosionDestructionManager.cancel();
                    return false;
                }
                Block originalBlockEntity = serverLevel.m_8055_(eventBlockPos).m_60734_();
                if (originalBlockEntity instanceof PreserverBlock) {
                    PreserverBlock preserverBlock4 = (PreserverBlock)originalBlockEntity;
                    ExplosionDestructionManager.cancel();
                    preserverBlock4.setLitPreserverBlock(serverLevel, centerBlockPos);
                    return false;
                }
                originalBlockEntity = serverLevel.m_7702_(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_204336_(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                BlockState originalBlockState = serverLevel.m_8055_(eventBlockPos);
                originalBlockEntity = serverLevel.m_7702_(eventBlockPos);
                CompoundTag compoundTag = new CompoundTag();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.m_187480_();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                ExplosionDestructionManager.cancel();
                BlockEntity blockEntity = serverLevel.m_7702_(eventBlockPos);
                if (blockEntity instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity5 = (MendingAuraBlockEntity)blockEntity;
                    blockEntity5.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((blockEntity = serverLevel.m_8055_(centerBlockPos).m_60734_()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock5 = (PreserverBlock)blockEntity;
                    preserverBlock5.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.m_5594_(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_BURNED.get()) {
                PreserverBlockEntity preserverBlock;
                BlockEntity originalBlockEntity = serverLevel.m_7702_(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_204336_(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                BlockState originalBlockState = serverLevel.m_8055_(eventBlockPos);
                originalBlockEntity = serverLevel.m_7702_(eventBlockPos);
                CompoundTag compoundTag = new CompoundTag();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.m_187480_();
                }
                BlockBurnManager.cancel();
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockEntity blockEntity = serverLevel.m_7702_(eventBlockPos);
                if (blockEntity instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity6 = (MendingAuraBlockEntity)blockEntity;
                    blockEntity6.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((blockEntity = serverLevel.m_8055_(centerBlockPos).m_60734_()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock6 = (PreserverBlock)blockEntity;
                    preserverBlock6.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.m_5594_(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_PUSHED_EARLY.get()) {
                if (serverLevel.m_8055_(eventBlockPos).m_60795_()) {
                    return false;
                }
                if (serverLevel.m_8055_(eventBlockPos).m_204336_(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                BlockState originalBlockState = serverLevel.m_8055_(eventBlockPos);
                BlockEntity originalBlockEntity = serverLevel.m_7702_(eventBlockPos);
                CompoundTag compoundTag = new CompoundTag();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.m_187480_();
                }
                PistonPushManager.cancel();
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockEntity blockEntity = serverLevel.m_7702_(eventBlockPos);
                if (blockEntity instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity7 = (MendingAuraBlockEntity)blockEntity;
                    blockEntity7.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((blockEntity = serverLevel.m_8055_(centerBlockPos).m_60734_()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock = (PreserverBlock)blockEntity;
                    preserverBlock.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.m_5594_(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == GameEvent.f_157797_) {
                Entity entity = context.f_223711_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35937_) {
                        return false;
                    }
                }
                if ((entity = serverLevel.m_7702_(centerBlockPos)) instanceof PreserverBlockEntity) {
                    PreserverBlockEntity blockEntity = (PreserverBlockEntity)entity;
                    blockEntity.addPlayerPlacedBlock(eventBlockPos);
                }
                return true;
            }
            return false;
        }

        private boolean ignoreBlockTransformation(ServerLevel serverLevel, BlockPos eventBlockPos) {
            BlockState blockState = serverLevel.m_8055_(eventBlockPos);
            Block block = blockState.m_60734_();
            return blockState.m_60838_((BlockGetter)serverLevel, eventBlockPos) || blockState.m_204336_(DNLTags.NEAR_FULL_HEIGHT_BLOCKS) || blockState.m_204336_(DNLTags.CHESTS) || block instanceof IronBarsBlock || block instanceof SlabBlock || block instanceof StairBlock || block instanceof FenceBlock || block instanceof WallBlock;
        }

        private void placeMendingBlock(ServerLevel serverLevel, BlockState originalBlockState, BlockPos eventBlockPos, GameEvent gameEvent) {
            BlockState mendingAuraState;
            serverLevel.m_7731_(eventBlockPos, Blocks.f_50016_.m_49966_(), 2);
            if (originalBlockState.m_60734_() instanceof StairBlock) {
                mendingAuraState = (BlockState)((BlockState)((BlockState)((BlockState)DNLBlocks.MENDING_AURA_STAIRS.get().m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)originalBlockState.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)originalBlockState.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)originalBlockState.m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            } else if (originalBlockState.m_60734_() instanceof SlabBlock) {
                mendingAuraState = (BlockState)((BlockState)DNLBlocks.MENDING_AURA_SLAB.get().m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)originalBlockState.m_61143_((Property)SlabBlock.f_56353_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            } else if (originalBlockState.m_60734_() instanceof FenceBlock) {
                mendingAuraState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)DNLBlocks.MENDING_AURA_FENCE.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61369_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            } else if (originalBlockState.m_60734_() instanceof IronBarsBlock) {
                mendingAuraState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)DNLBlocks.MENDING_AURA_PANE.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61369_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            } else if (originalBlockState.m_60734_() instanceof WallBlock) {
                mendingAuraState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)DNLBlocks.MENDING_AURA_WALL.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61366_)))).m_61124_((Property)BlockStateProperties.f_61379_, (Comparable)((WallSide)originalBlockState.m_61143_((Property)BlockStateProperties.f_61379_)))).m_61124_((Property)BlockStateProperties.f_61380_, (Comparable)((WallSide)originalBlockState.m_61143_((Property)BlockStateProperties.f_61380_)))).m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)((WallSide)originalBlockState.m_61143_((Property)BlockStateProperties.f_61378_)))).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)((WallSide)originalBlockState.m_61143_((Property)BlockStateProperties.f_61381_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            } else if (originalBlockState.m_204336_(DNLTags.NEAR_FULL_HEIGHT_BLOCKS)) {
                mendingAuraState = DNLBlocks.MENDING_AURA_PATH.get().m_49966_();
            } else if (originalBlockState.m_204336_(DNLTags.CHESTS)) {
                mendingAuraState = (BlockState)((BlockState)DNLBlocks.MENDING_AURA_CHEST.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)originalBlockState.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)originalBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
                if (originalBlockState.m_60713_(Blocks.f_50087_)) {
                    mendingAuraState = (BlockState)mendingAuraState.m_61124_((Property)BlockStateProperties.f_61392_, (Comparable)((ChestType)originalBlockState.m_61143_((Property)BlockStateProperties.f_61392_)));
                }
            } else {
                mendingAuraState = DNLBlocks.MENDING_AURA.get().m_49966_();
            }
            serverLevel.m_7731_(eventBlockPos, mendingAuraState, 2);
            Block block = serverLevel.m_8055_(eventBlockPos).m_60734_();
            if (block instanceof MendingAuraBlock) {
                MendingAuraBlock mendingAuraBlock = (MendingAuraBlock)block;
                mendingAuraBlock.startRestoration((Level)serverLevel, eventBlockPos);
            }
        }
    }

    public static class User {
        public static final Codec<User> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("cornerA").forGetter(User::getCornerA), (App)BlockPos.f_121852_.fieldOf("cornerB").forGetter(User::getCornerB), (App)Direction.f_175356_.fieldOf("facing").forGetter(User::getFacing)).apply((Applicative)instance, (cornerA, cornerB, facing) -> new User(BlockPos.f_121853_, (BlockPos)cornerA, (BlockPos)cornerB, (Direction)facing)));
        private final BlockPos blockPos;
        private BlockPos cornerA;
        private BlockPos cornerB;
        private Direction direction;

        public User(BlockPos blockPos, BlockPos cornerA, BlockPos cornerB, Direction direction) {
            this.blockPos = blockPos;
            this.cornerA = cornerA;
            this.cornerB = cornerB;
            this.direction = direction;
        }

        public BlockPos getCornerA() {
            return this.cornerA;
        }

        public void setCornerA(BlockPos blockPos) {
            this.cornerA = blockPos;
        }

        public void setCornerB(BlockPos blockPos) {
            this.cornerB = blockPos;
        }

        public BlockPos getCornerB() {
            return this.cornerB;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public PositionSource getPositionSource() {
            return new BlockPositionSource(this.blockPos);
        }

        public Direction getFacing() {
            return this.direction;
        }

        public void setFacing(Direction direction) {
            this.direction = direction;
        }

        public boolean isInsideRegion(Level level, BlockPos eventBlockPos, BlockPos centerBlock) {
            BlockEntity blockEntity = level.m_7702_(centerBlock);
            if (!(blockEntity instanceof PreserverBlockEntity)) {
                return false;
            }
            PreserverBlockEntity preserverBlockEntity = (PreserverBlockEntity)blockEntity;
            Direction nbtDirection = preserverBlockEntity.getUser().getFacing();
            BlockPos absCornerA = this.blockPos.m_121955_((Vec3i)User.rotateOffset(level, centerBlock, this.cornerA, nbtDirection));
            BlockPos absCornerB = this.blockPos.m_121955_((Vec3i)User.rotateOffset(level, centerBlock, this.cornerB, nbtDirection));
            int minX = Math.min(absCornerA.m_123341_(), absCornerB.m_123341_());
            int minY = Math.min(absCornerA.m_123342_(), absCornerB.m_123342_());
            int minZ = Math.min(absCornerA.m_123343_(), absCornerB.m_123343_());
            int maxX = Math.max(absCornerA.m_123341_(), absCornerB.m_123341_());
            int maxY = Math.max(absCornerA.m_123342_(), absCornerB.m_123342_());
            int maxZ = Math.max(absCornerA.m_123343_(), absCornerB.m_123343_());
            return eventBlockPos.m_123341_() >= minX && eventBlockPos.m_123341_() <= maxX && eventBlockPos.m_123342_() >= minY && eventBlockPos.m_123342_() <= maxY && eventBlockPos.m_123343_() >= minZ && eventBlockPos.m_123343_() <= maxZ;
        }

        public static BlockPos rotateOffset(Level level, BlockPos pos, BlockPos offset, Direction nbtFacing) {
            Direction propertyDirection = (Direction)level.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61372_);
            int propertyFacingIndex = switch (propertyDirection) {
                default -> 0;
                case Direction.EAST -> 1;
                case Direction.SOUTH -> 2;
                case Direction.WEST -> 3;
            };
            int nbtFacingIndex = switch (nbtFacing) {
                default -> 0;
                case Direction.EAST -> 1;
                case Direction.SOUTH -> 2;
                case Direction.WEST -> 3;
            };
            int facingDifference = propertyFacingIndex - nbtFacingIndex;
            return switch (facingDifference) {
                default -> offset;
                case -3, 1 -> offset.m_7954_(Rotation.CLOCKWISE_90);
                case -1, 3 -> offset.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                case -2, 2 -> offset.m_7954_(Rotation.CLOCKWISE_180);
            };
        }
    }
}

