/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.config.MobConfig;
import dev.hexnowloading.dungeonnowloading.entity.util.ExhaustionTracker;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class EntityScale {
    private static final UUID SCALED_HEALTH_MODIFIER_UUID = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479");
    private static final UUID SCALED_ATTACK_MODIFIER_UUID = UUID.fromString("3a284fc3-6c5a-43d7-93ec-d96423e0f34f");
    private static final double bossHealthScale = (Double)BossConfig.BOSS_HEALTH_MODIFIER.get();
    private static final double bossAttackDamageScale = (Double)BossConfig.BOSS_DAMAGE_MODIFIER.get();
    private static final double multiplayerBossHealthScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_HEALTH_SCALE.get() : 0.0;
    private static final double multiplayerBossAttackScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_ATTACK_SCALE.get() : 0.0;
    private static final double multiplayerBossExhaustionScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_EXHAUSTION_SCALE.get() : 0.0;

    public static void scaleBossHealth(LivingEntity entityType, int playerCount) {
        double healthMultiplier = bossHealthScale * (1.0 + (double)(playerCount - 1) * multiplayerBossHealthScale) - 1.0;
        AttributeModifier SCALED_HEALTH_MODIFIER = new AttributeModifier(SCALED_HEALTH_MODIFIER_UUID, "Scaled health", healthMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        Objects.requireNonNull(entityType.m_21051_(Attributes.f_22276_)).m_22130_(SCALED_HEALTH_MODIFIER);
        Objects.requireNonNull(entityType.m_21051_(Attributes.f_22276_)).m_22125_(SCALED_HEALTH_MODIFIER);
        entityType.m_21153_(entityType.m_21233_());
    }

    public static void scaleBossAttack(LivingEntity entityType, int playerCount) {
        double attackMultiplier = bossAttackDamageScale * (1.0 + (double)(playerCount - 1) * multiplayerBossAttackScale) - 1.0;
        AttributeModifier SCALED_ATTACK_MODIFIER = new AttributeModifier(SCALED_ATTACK_MODIFIER_UUID, "Scaled attack", attackMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        Objects.requireNonNull(entityType.m_21051_(Attributes.f_22281_)).m_22130_(SCALED_ATTACK_MODIFIER);
        Objects.requireNonNull(entityType.m_21051_(Attributes.f_22281_)).m_22125_(SCALED_ATTACK_MODIFIER);
    }

    public static void scaleBossExhaustion(LivingEntity entityType, int playerCount, ExhaustionTracker exhaustionTracker) {
        double exhaustionMultiplier = 1.0 + (double)(playerCount - 1) * multiplayerBossExhaustionScale - 1.0;
        exhaustionTracker.setMaxExhaustion((float)((double)exhaustionTracker.getMaxExhaustion() * (1.0 + exhaustionMultiplier)));
    }

    public static void scaleMobAttributes(LivingEntity entity) {
        int health = (int)((double)entity.m_21233_() * (Double)MobConfig.DUNGEON_MOB_HEALTH_MODIFIER.get());
        int attackDamage = (int)(entity.m_21051_(Attributes.f_22281_).m_22135_() * (Double)MobConfig.DUNGEON_MOB_ATTACK_MODIFIER.get());
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)health);
        entity.m_21051_(Attributes.f_22281_).m_22100_((double)attackDamage);
        entity.m_21153_((float)health);
    }
}

