/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosAwakenGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosCircleAroundGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosDropScuttleGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosDropVertexPillarGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosShootVertexDomainGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosShootVertexOrbGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.move.FairkeeperOurosMoveControl;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import dev.hexnowloading.dungeonnowloading.util.NbtHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FairkeeperOurosEntity
extends Monster
implements Boss,
Enemy,
SlumberingEntity,
FairkeeperSerpentEntity,
WeightedTargetProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<FairkeeperOurosState> STATE = SynchedEntityData.m_135353_(FairkeeperOurosEntity.class, EntityStates.FAIRKEEPER_OUROS_STATE);
    private static final EntityDataAccessor<FairkeeperOurosAnimationState> OUROS_ANIMATION_STATE = SynchedEntityData.m_135353_(FairkeeperOurosEntity.class, EntityStates.FAIRKEEPER_OUROS_ANIMATION_STATE);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(FairkeeperOurosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> IS_ON_CEILING = SynchedEntityData.m_135353_(FairkeeperOurosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState openMouthAnimationState = new AnimationState();
    public final AnimationState openedMouthAnimationState = new AnimationState();
    public final AnimationState closeMouthAnimationState = new AnimationState();
    private final Deque<Vec3> positionHistory = new LinkedList<Vec3>();
    private final Map<UUID, Double> damageMap = new HashMap<UUID, Double>();
    private final Map<UUID, LivingEntity> attackers = new HashMap<UUID, LivingEntity>();
    private final Map<UUID, Double> threatScores = new HashMap<UUID, Double>();
    private float previousTilt = 0.0f;
    private FairkeeperSerpentCallerEntity fairkeeperSerpentCaller;
    private UUID callerUUID;
    private int attackTick;
    private int destructionTick;
    private int slitheringSoundTick;
    private int partIndex;
    private Vec3 awakenEndPos;
    private boolean targetRandomPlayer;
    private boolean canDestroyBlocks;
    private boolean changeTarget;
    private DamageSource killedDamageSource;
    private AnimationChainer<FairkeeperOurosAnimationState> animationChainer = new AnimationChainer();
    private final ServerBossEvent bossEvent;
    public static final int SEGMENT_COUNT = 14;
    public static int SEGMENT_DELAY_STEP = 13;
    private int mouthOpenAnimationTimeOut;
    private static final int MOUTH_OPEN_ANIMATION_DURATION = 19;
    private static final int SLITHERING_SOUND_INTERVAL = 140;

    public FairkeeperOurosEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FairkeeperOurosMoveControl((Mob)this);
        this.f_21343_ = new JumpControl((Mob)this);
        this.m_274367_(0.0f);
        this.m_21530_();
        this.f_21364_ = 0;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    }

    public FairkeeperOurosEntity(Level level, FairkeeperSerpentCallerEntity fairkeeperSerpentCaller) {
        this(DNLEntityTypes.FAIRKEEPER_OUROS.get(), level);
        this.fairkeeperSerpentCaller = fairkeeperSerpentCaller;
        this.callerUUID = this.fairkeeperSerpentCaller.m_20148_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FairkeeperOurosAwakenGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SUMMON_SCUTTLE, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosDropScuttleGoal(FairkeeperOurosState.SUMMON_SCUTTLE, this, 1));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, this, 1.3, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_CENTER));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_INNER, this, 1.7, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_INNER));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, this, 1.7, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_OUTER));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, this, 1, 0.05f, 2));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, this, 3, 0.2f, 2));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosShootVertexDomainGoal(FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, this));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SUMMON_MORE_SCUTTLES, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosDropScuttleGoal(FairkeeperOurosState.SUMMON_MORE_SCUTTLES, this, 3));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.DESPERATE, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.DESPERATE, this, 9, 0.2f, 2));
        this.f_21345_.m_25352_(4, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.IDLE, this, 20.0, 1.3, false, true));
        this.f_21345_.m_25352_(5, (Goal)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.IDLE, this, 20.0, 1.3, false, false));
        this.f_21346_.m_25352_(2, (Goal)new BossTargetSelectorGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(IS_ON_CEILING, (Object)false);
        this.f_19804_.m_135372_(STATE, (Object)FairkeeperOurosState.IDLE);
        this.f_19804_.m_135372_(OUROS_ANIMATION_STATE, (Object)FairkeeperOurosAnimationState.IDLE);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Slumbering", this.isSlumbering());
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        if (this.getCallerId() != null) {
            compoundTag.m_128362_("CallerUUID", this.getCallerId());
        }
        if (this.getAwakenEndPos() != null) {
            compoundTag.m_128365_("AwakenEndPos", (Tag)NbtHelper.newDoubleList(this.getAwakenEndPos().f_82479_, this.getAwakenEndPos().f_82480_, this.getAwakenEndPos().f_82481_));
        }
        compoundTag.m_128379_("CanDestroyBlocks", this.canDestroyBlocks);
        compoundTag.m_128379_("Awakened", !this.isState(FairkeeperOurosState.AWAKENING));
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        if (compoundTag.m_128403_("CallerUUID")) {
            this.setCallerId(compoundTag.m_128342_("CallerUUID"));
        }
        if (compoundTag.m_128441_("AwakenEndPos")) {
            this.awakenEndPos = new Vec3(compoundTag.m_128437_("AwakenEndPos", 6).m_128772_(0), compoundTag.m_128437_("AwakenEndPos", 6).m_128772_(1), compoundTag.m_128437_("AwakenEndPos", 6).m_128772_(2));
        }
        this.setCanDestroyBlocks(compoundTag.m_128471_("CanDestroyBlocks"));
        this.setState(compoundTag.m_128471_("Awakened") ? FairkeeperOurosState.IDLE : FairkeeperOurosState.AWAKENING);
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8119_() {
        super.m_8119_();
        this.animationControl();
    }

    private void animationControl() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.animationChainer.tick(this::transitionTo);
    }

    public void playMouthOpen() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    public void playMouthClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_CLOSE, 1.6667f, () -> this.playMouthCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
    }

    public void playDeathAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void segmentControl() {
        int i;
        Entity child = this.getChild();
        if (this.positionHistory.isEmpty()) {
            Vec3 currentPos = this.m_20182_();
            int requiredHistorySize = 15 * SEGMENT_DELAY_STEP;
            for (i = 0; i < requiredHistorySize; ++i) {
                this.positionHistory.addLast(currentPos);
            }
        }
        if (child == null && !this.m_21224_()) {
            Monster partParent = this;
            int segments = 14;
            for (i = 0; i < segments; ++i) {
                FairkeeperOurosPartEntity bodyPartParent;
                FairkeeperOurosPartEntity part = new FairkeeperOurosPartEntity(DNLEntityTypes.FAIRKEEPER_OUROS_PART.get(), (LivingEntity)partParent, (LivingEntity)this, i);
                if (partParent == this) {
                    this.setChildId(part.m_20148_());
                } else if (partParent instanceof FairkeeperOurosPartEntity && !(bodyPartParent = (FairkeeperOurosPartEntity)partParent).isTail()) {
                    if (!bodyPartParent.isTail()) {
                        bodyPartParent.setChildId(part.m_20148_());
                    } else {
                        bodyPartParent.setChildId(null);
                    }
                }
                part.m_6034_(partParent.m_20185_(), partParent.m_20186_(), partParent.m_20189_());
                part.m_146922_(partParent.m_146908_());
                part.f_20883_ = partParent.m_146908_();
                part.f_20885_ = partParent.m_146908_();
                part.setRotatable(false);
                partParent = part;
                if (i == segments - 1) {
                    part.setTail(true);
                }
                this.m_9236_().m_7967_((Entity)part);
            }
        }
        if (this.m_20184_().m_82556_() > 0.01) {
            Deque<Vec3> deque = this.positionHistory;
            synchronized (deque) {
                this.positionHistory.addFirst(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                int maxHistorySize = 15 * SEGMENT_DELAY_STEP;
                if (this.positionHistory.size() > maxHistorySize) {
                    this.positionHistory.pollLast();
                }
            }
        }
        if (!this.onCieling() && this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
        }
        if (!this.isState(FairkeeperOurosState.AWAKENING)) {
            this.lookTowardTarget();
        }
    }

    public Vec3 getSegmentTargetPosition(int segmentIndex) {
        double segmentSpacing = 4.0;
        double targetDistance = (double)segmentIndex * segmentSpacing;
        ArrayList<Vec3> history = new ArrayList<Vec3>(this.positionHistory);
        if (history.size() < 2) {
            return this.m_20182_();
        }
        Vec3 current = (Vec3)history.get(0);
        double accumulated = 0.0;
        for (int i = 1; i < history.size(); ++i) {
            Vec3 next = (Vec3)history.get(i);
            double dist = current.m_82554_(next);
            if (accumulated + dist >= targetDistance) {
                double remaining = targetDistance - accumulated;
                double t = remaining / dist;
                return current.m_165921_(next, t);
            }
            accumulated += dist;
            current = next;
        }
        return (Vec3)history.get(history.size() - 1);
    }

    private void lookTowardTarget() {
        double directionX = this.m_21566_().m_25000_() - this.m_20185_();
        double directionZ = this.m_21566_().m_25002_() - this.m_20189_();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.m_146922_((float)yaw);
        this.f_20883_ = (float)yaw;
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_6109_()) {
            boolean isRising;
            double upwardGravity = -0.08;
            boolean bl = isRising = this.m_20184_().f_82480_ >= 0.0;
            if (isRising && this.m_21023_(MobEffects.f_19591_)) {
                upwardGravity = -0.01;
            }
            if (this.m_21255_()) {
                double collisionHorizontalVelocity;
                double collisionVelocityDifference;
                float collisionDamage;
                this.m_245125_();
                Vec3 currentVelocity = this.m_20184_();
                Vec3 lookDirection = this.m_20154_();
                float pitchRadians = this.m_146909_() * ((float)Math.PI / 180);
                double horizontalLookDistance = Math.sqrt(lookDirection.f_82479_ * lookDirection.f_82479_ + lookDirection.f_82481_ * lookDirection.f_82481_);
                double horizontalVelocity = currentVelocity.m_165924_();
                double lookMagnitude = lookDirection.m_82553_();
                double adjustedCosPitch = Math.cos(pitchRadians);
                adjustedCosPitch = adjustedCosPitch * adjustedCosPitch * Math.min(1.0, lookMagnitude / 0.4);
                currentVelocity = this.m_20184_().m_82520_(0.0, upwardGravity * (-1.0 + adjustedCosPitch * 0.75), 0.0);
                if (currentVelocity.f_82480_ > 0.0 && horizontalLookDistance > 0.0) {
                    double risingAdjustment = currentVelocity.f_82480_ * 0.1 * adjustedCosPitch;
                    currentVelocity = currentVelocity.m_82520_(lookDirection.f_82479_ * risingAdjustment / horizontalLookDistance, risingAdjustment, lookDirection.f_82481_ * risingAdjustment / horizontalLookDistance);
                }
                if (pitchRadians > 0.0f && horizontalLookDistance > 0.0) {
                    double upwardAdjustment = horizontalVelocity * (double)Mth.m_14031_((float)pitchRadians) * 0.04;
                    currentVelocity = currentVelocity.m_82520_(-lookDirection.f_82479_ * upwardAdjustment / horizontalLookDistance, upwardAdjustment * 3.2, -lookDirection.f_82481_ * upwardAdjustment / horizontalLookDistance);
                }
                if (horizontalLookDistance > 0.0) {
                    currentVelocity = currentVelocity.m_82520_((lookDirection.f_82479_ / horizontalLookDistance * horizontalVelocity - currentVelocity.f_82479_) * 0.1, 0.0, (lookDirection.f_82481_ / horizontalLookDistance * horizontalVelocity - currentVelocity.f_82481_) * 0.1);
                }
                this.m_20256_(currentVelocity.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.m_9236_().f_46443_ && (collisionDamage = (float)((collisionVelocityDifference = horizontalVelocity - (collisionHorizontalVelocity = this.m_20184_().m_165924_())) * 10.0 - 3.0)) > 0.0f) {
                    this.m_5496_(this.m_5896_((int)collisionDamage), 1.0f, 1.0f);
                    this.m_6469_(this.m_269291_().m_269515_(), collisionDamage);
                }
                if (this.onCieling() && !this.m_9236_().f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos blockBelow = this.m_20099_();
                float blockFriction = this.m_9236_().m_8055_(blockBelow).m_60734_().m_49958_();
                float groundFriction = this.onCieling() ? blockFriction * 0.91f : 0.91f;
                this.m_19920_(this.m_21330_(blockFriction), movementInput);
                this.m_20256_(this.m_20184_());
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 adjustedMovement = this.m_20184_();
                if ((this.f_19862_ || this.f_20899_) && (this.m_6147_() || this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this))) {
                    adjustedMovement = new Vec3(adjustedMovement.f_82479_, -0.2, adjustedMovement.f_82481_);
                }
                double adjustedYVelocity = adjustedMovement.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    adjustedYVelocity += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - adjustedMovement.f_82480_) * 0.2;
                } else if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(blockBelow)) {
                    adjustedYVelocity = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    adjustedYVelocity -= upwardGravity;
                }
                if (this.m_147223_()) {
                    this.m_20334_(adjustedMovement.f_82479_, adjustedYVelocity, adjustedMovement.f_82481_);
                } else {
                    this.m_20334_(adjustedMovement.f_82479_ * (double)groundFriction, adjustedYVelocity * (double)0.98f, adjustedMovement.f_82481_ * (double)groundFriction);
                }
            }
        }
    }

    private float m_21330_(float $$0) {
        return this.onCieling() ? this.m_6113_() * (0.21600002f / ($$0 * $$0 * $$0)) : this.m_274460_();
    }

    protected BlockPos m_216986_(float $$0) {
        if (this.f_285638_.isPresent()) {
            BlockPos $$1 = (BlockPos)this.f_285638_.get();
            if (!($$0 > 1.0E-5f)) {
                return $$1;
            }
            BlockState $$2 = this.m_9236_().m_8055_($$1);
            return !((double)$$0 <= 0.5 && $$2.m_204336_(BlockTags.f_13039_) || $$2.m_204336_(BlockTags.f_13032_) || $$2.m_60734_() instanceof FenceGateBlock) ? $$1.m_175288_(Mth.m_14107_((double)(this.m_20182_().f_82480_ + (double)$$0))) : $$1;
        }
        int $$3 = Mth.m_14107_((double)this.m_20182_().f_82479_);
        int $$4 = Mth.m_14107_((double)(this.m_20182_().f_82480_ + (double)$$0));
        int $$5 = Mth.m_14107_((double)this.m_20182_().f_82481_);
        return new BlockPos($$3, $$4, $$5);
    }

    private SoundEvent m_5896_(int $$0) {
        return $$0 > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
    }

    public boolean onCieling() {
        return this.f_19863_ && !this.f_201939_;
    }

    protected void m_8024_() {
        if (this.isState(FairkeeperOurosState.AWAKENING)) {
            this.enableBossBar();
        }
        this.segmentControl();
        this.slitheringSoundControl();
        this.findCaller();
        this.performContactDamage();
        this.abilityCooldown();
        this.blockDestructionTick();
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void slitheringSoundControl() {
        if (this.slitheringSoundTick-- <= 0) {
            this.playSlitheringSound();
            this.slitheringSoundTick = 140;
        }
    }

    private void findCaller() {
        if (this.fairkeeperSerpentCaller == null) {
            this.fairkeeperSerpentCaller = (FairkeeperSerpentCallerEntity)((ServerLevel)this.m_9236_()).m_8791_(this.getCallerId());
        }
    }

    private void performContactDamage() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.m_7334_((Entity)this);
            entity.m_6469_(entity.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * 0.5));
        });
    }

    private boolean canPerformContactDamageTo(Entity entity) {
        if (entity instanceof FairkeeperOurosPartEntity) {
            FairkeeperOurosPartEntity part = (FairkeeperOurosPartEntity)entity;
            return !this.m_20148_().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    private void blockDestructionTick() {
        if (!this.canDestroyBlocks) {
            return;
        }
        int DESTRUCTION_RANGE = 4;
        if (this.m_20184_().m_82556_() > 0.01) {
            return;
        }
        if (this.destructionTick-- > 0) {
            return;
        }
        this.destructionTick = 2;
        this.destroyContactBlocks(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, -1, 3, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
    }

    private void destroyContactBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        boolean blockBroken = false;
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.m_146903_() + ix;
                    int dy = this.m_146904_() + iy;
                    int dz = this.m_146907_() + iz;
                    BlockPos blockPos = new BlockPos(dx, dy, dz);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13070_) || blockState.m_204336_(DNLTags.TORCH_BLOCKS)) continue;
                    blockBroken = DNLLevelUtil.destroyBlockMulti(this.m_9236_(), blockPos, false, (Entity)this, 3);
                }
            }
        }
        if (blockBroken) {
            this.m_216990_(SoundEvents.f_12442_);
        }
    }

    private void abilityCooldown() {
        if (this.fairkeeperSerpentCaller == null) {
            return;
        }
        if (!this.isState(FairkeeperOurosState.IDLE)) {
            return;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
            return;
        }
        if (this.getCaller() != null) {
            this.getCaller().setOurosWaitingForCommand(true);
        }
    }

    public void stopAttacking(int cooldown) {
        this.setState(FairkeeperOurosState.IDLE);
        this.setAttackTick(cooldown);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_7639_() instanceof FairkeeperSerpentEntity) {
            Entity entity = damageSource.m_7640_();
            if (entity instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity;
                arrow.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        this.playHurtSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
        return this.hurtAndTrackAttackers(damageSource, amount);
    }

    private boolean hurtAndTrackAttackers(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            this.recordDamage(livingEntity, amount);
        }
        return result;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_20919_ == 1) {
            this.playDeathAnimation();
            this.stopSlitheringSound();
            this.playDeathSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.partIndex = 0;
            for (int i = 0; i <= 13; ++i) {
                FairkeeperOurosPartEntity part = this.getPart(i);
                if (part == null) continue;
                part.m_21153_(0.0f);
            }
        }
        if (this.f_20919_ % 10 == 0) {
            if (this.partIndex <= 13) {
                FairkeeperOurosPartEntity part = this.getPart(13 - this.partIndex);
                if (part != null) {
                    this.m_9236_().m_5594_(null, part.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, part.m_20185_(), part.m_20186_(), part.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                    part.m_142687_(Entity.RemovalReason.KILLED);
                }
            } else if (!this.m_213877_()) {
                FairkeeperSerpentCallerEntity caller = this.getCaller();
                if (caller != null) {
                    caller.defeatedOuros();
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            ++this.partIndex;
        }
    }

    private FairkeeperOurosPartEntity getPart(int index) {
        FairkeeperOurosPartEntity part = (FairkeeperOurosPartEntity)this.getChild();
        if (part == null) {
            return null;
        }
        for (int i = 0; i < index; ++i) {
            if ((part = (FairkeeperOurosPartEntity)part.getChild()) != null) continue;
            return null;
        }
        return part;
    }

    public void m_6667_(DamageSource damageSource) {
        FairkeeperSerpentCallerEntity caller = this.getCaller();
        if (caller != null) {
            caller.setLastDamageSource(damageSource);
            caller.dyingOuros();
            if (caller.isBorosDefeated()) {
                caller.stopAllBossMusic();
            }
        }
        super.m_6667_(damageSource);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        MobEffect effect = mobEffectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (OUROS_ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperOurosAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_OPEN: {
                    this.openMouthAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_OPENED: {
                    this.openedMouthAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_CLOSE: {
                    this.closeMouthAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.m_216973_();
        this.openMouthAnimationState.m_216973_();
        this.openedMouthAnimationState.m_216973_();
        this.closeMouthAnimationState.m_216973_();
    }

    public FairkeeperOurosEntity transitionTo(FairkeeperOurosAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(FairkeeperOurosAnimationState.IDLE);
                break;
            }
            case MOUTH_OPEN: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_OPEN);
                break;
            }
            case MOUTH_OPENED: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_OPENED);
                break;
            }
            case MOUTH_CLOSE: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_CLOSE);
            }
        }
        return this;
    }

    public void playSlitheringSound() {
        float radius = 64.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_OUROS_SLITHER.get().m_11660_(), SoundSource.HOSTILE, 4.0f, 1.0f, false, 64.0f, 0.0f), player);
        }
    }

    public void stopSlitheringSound() {
        float radius = 64.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_OUROS_SLITHER.get().m_11660_(), 20, false), player);
        }
    }

    public void playMouthOpenSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_OPEN.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playMouthCloseSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_CLOSE.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playVertexDomainShootSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_SHOOT_VERTEX_DOMAIN.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playHurtSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_HURT.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playDeathSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_DEATH.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public boolean m_5830_() {
        return false;
    }

    @Override
    public BlockPos resetRegionCenter() {
        return this.getCaller().m_20183_();
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public void resetBoss() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_7337_(Entity entity) {
        return !(entity instanceof VertexDomainProjectileEntity) && super.m_7337_(entity);
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    protected int m_5639_(float $$0, float $$1) {
        return 0;
    }

    public boolean m_142535_(float v, float v1, DamageSource damageSource) {
        return false;
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public FairkeeperSerpentCallerEntity getCaller() {
        return this.fairkeeperSerpentCaller;
    }

    @Override
    public BlockPos getArenaCenter() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.m_20183_();
        }
        return this.m_20183_();
    }

    @Override
    public int getArenaSize() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.getArenaSize();
        }
        return (int)this.getFollowDistance();
    }

    public void enableBossBar() {
        this.bossEvent.m_8321_(true);
    }

    public void disableBossBar() {
        this.bossEvent.m_8321_(false);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public void setAttackTick(int i) {
        this.attackTick = i;
    }

    public double getAttackDamage() {
        return this.m_21133_(Attributes.f_22281_);
    }

    public double getFollowDistance() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public void setState(FairkeeperOurosState FairkeeperOurosState2) {
        this.f_19804_.m_135381_(STATE, (Object)FairkeeperOurosState2);
    }

    public FairkeeperOurosState getState() {
        return (FairkeeperOurosState)((Object)this.f_19804_.m_135370_(STATE));
    }

    public boolean isState(FairkeeperOurosState FairkeeperOurosState2) {
        return this.getState().equals((Object)FairkeeperOurosState2);
    }

    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getCallerId() {
        return this.callerUUID;
    }

    public void setCallerId(@Nullable UUID uniqueId) {
        this.callerUUID = uniqueId;
    }

    public Queue<Vec3> getPositionHistory() {
        return this.positionHistory;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public Vec3 getAwakenEndPos() {
        return this.awakenEndPos;
    }

    public void setAwakenEndPos(Vec3 blockPos) {
        this.awakenEndPos = blockPos;
    }

    public void setIsOnCeiling(boolean b) {
        this.f_19804_.m_135381_(IS_ON_CEILING, (Object)b);
    }

    public boolean isOnCeiling() {
        return (Boolean)this.f_19804_.m_135370_(IS_ON_CEILING);
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    public void setAnimationState(FairkeeperOurosAnimationState animationState) {
        this.f_19804_.m_135381_(OUROS_ANIMATION_STATE, (Object)animationState);
    }

    public FairkeeperOurosAnimationState getAnimationState() {
        return (FairkeeperOurosAnimationState)((Object)this.f_19804_.m_135370_(OUROS_ANIMATION_STATE));
    }

    public void setCanDestroyBlocks(boolean b) {
        this.canDestroyBlocks = b;
    }

    public boolean canDestroyBlocks() {
        return this.canDestroyBlocks;
    }

    @Override
    public Map<UUID, Double> getDamageMap() {
        return this.damageMap;
    }

    @Override
    public Map<UUID, LivingEntity> getAttackers() {
        return this.attackers;
    }

    @Override
    public Map<UUID, Double> getThreatScoreMap() {
        return this.threatScores;
    }

    public static enum FairkeeperOurosState {
        AWAKENING,
        IDLE,
        SUMMON_SCUTTLE,
        SUMMON_MORE_SCUTTLES,
        DROP_PILLAR_RANDOM,
        DROP_PILLAR_SMALL_SQUARE,
        DROP_PILLAR_LINE_CENTER,
        DROP_PILLAR_LINE_OUTER,
        DROP_PILLAR_CROSS,
        DROP_PILLAR_LINE_INNER,
        SHOOT_SINGLE_VERTEX_ORB,
        SHOOT_TRIPLE_VERTEX_ORB,
        SHOOT_VERTEX_DOMAIN,
        EXHAUSTED,
        DESPERATE,
        DYING;

    }

    public static enum FairkeeperOurosAnimationState {
        IDLE,
        MOUTH_OPEN,
        MOUTH_OPENED,
        MOUTH_CLOSE;

    }
}

