/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.menu.MendingTableMenu;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendingTableBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private static final int INVENTORY_SIZE = 4;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int cachedRepairPercent = 0;
    int cachedBasePercent = 0;
    int cachedBonusPercent = 0;
    private int cachedPotentialBasePercent = 0;
    private int cachedPotentialBonusPercent = 0;
    private static final int PICKAXE_SLOT = 0;
    private static final int MAT_SLOT_1 = 1;
    private static final int MAT_SLOT_2 = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int DURITE_PERCENT = 20;
    private static final int MENDSTONE_PERCENT = 50;
    private static final int TOOL_MATERIAL_PERCENT = 40;
    private static final int BONUS_PERCENT = 10;

    public MendingTableBlockEntity(BlockPos pos, BlockState state) {
        super(DNLBlockEntityTypes.MENDING_TABLE.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.dungeonnowloading.mending_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new MendingTableMenu(id, inventory, this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack result = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!result.m_41619_()) {
            this.recalc();
        }
        return result;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        ItemStack stack = (ItemStack)this.items.get(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(index, (Object)ItemStack.f_41583_);
        this.recalc();
        return stack;
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.recalc();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
        this.recalc();
    }

    public int getPotentialBasePercent() {
        return this.cachedPotentialBasePercent;
    }

    public int getPotentialBonusPercent() {
        return this.cachedPotentialBonusPercent;
    }

    private boolean isTool(ItemStack stack) {
        return stack.m_41763_();
    }

    private boolean isToolRepairIngredient(ItemStack tool, ItemStack ingredientStack) {
        if (tool.m_41619_() || ingredientStack.m_41619_()) {
            return false;
        }
        if (!tool.m_41763_()) {
            return false;
        }
        return tool.m_41720_().m_6832_(tool, ingredientStack);
    }

    private int percentPerItem(ItemStack tool, ItemStack stack) {
        if (stack.m_150930_(DNLItems.MENDSTONE.get())) {
            return 50;
        }
        if (stack.m_150930_(DNLItems.DURITE.get())) {
            return 20;
        }
        if (!tool.m_41619_() && this.isToolRepairIngredient(tool, stack)) {
            return 40;
        }
        return 0;
    }

    private void recalc() {
        int p2;
        ItemStack inputTool;
        ItemStack input = (ItemStack)this.items.get(0);
        ItemStack mat1 = (ItemStack)this.items.get(1);
        ItemStack mat2 = (ItemStack)this.items.get(2);
        this.items.set(3, (Object)ItemStack.f_41583_);
        this.cachedRepairPercent = 0;
        this.cachedBasePercent = 0;
        this.cachedBonusPercent = 0;
        this.cachedPotentialBasePercent = 0;
        this.cachedPotentialBonusPercent = 0;
        boolean isScrap = input.m_150930_(DNLItems.ITEM_SCRAPS.get());
        ItemStack itemStack = inputTool = isScrap ? ScrapItem.getOriginal(input) : input;
        if (inputTool.m_41619_() || !this.isTool(inputTool)) {
            this.m_6596_();
            return;
        }
        if (inputTool.m_150930_(DNLItems.MENDSTONE_PICKAXE.get())) {
            this.m_6596_();
            return;
        }
        int damage = inputTool.m_41773_();
        if (damage <= 0) {
            this.m_6596_();
            return;
        }
        int max = inputTool.m_41776_();
        int neededPercent = (damage * 100 + max - 1) / max;
        int p1 = this.percentPerItem(inputTool, mat1);
        int potentialBase = p1 + (p2 = this.percentPerItem(inputTool, mat2));
        if (potentialBase <= 0) {
            this.m_6596_();
            return;
        }
        boolean hasToolMat = !mat1.m_41619_() && this.isToolRepairIngredient(inputTool, mat1) || !mat2.m_41619_() && this.isToolRepairIngredient(inputTool, mat2);
        boolean hasDuriteOrMendstone = !mat1.m_41619_() && (mat1.m_150930_(DNLItems.DURITE.get()) || mat1.m_150930_(DNLItems.MENDSTONE.get())) || !mat2.m_41619_() && (mat2.m_150930_(DNLItems.DURITE.get()) || mat2.m_150930_(DNLItems.MENDSTONE.get()));
        int potentialBonus = hasToolMat && hasDuriteOrMendstone ? 10 : 0;
        this.cachedPotentialBasePercent = Math.min(potentialBase, 100);
        this.cachedPotentialBonusPercent = potentialBonus;
        int appliedBase = Math.min(potentialBase, neededPercent);
        int appliedBonus = Math.min(potentialBonus, Math.max(0, neededPercent - appliedBase));
        int appliedTotal = appliedBase + appliedBonus;
        int repairAmount = (appliedTotal * max + 99) / 100;
        int newDamage = Math.max(0, damage - repairAmount);
        ItemStack result = inputTool.m_41777_();
        result.m_41721_(newDamage);
        this.items.set(3, (Object)result);
        this.cachedBasePercent = appliedBase;
        this.cachedBonusPercent = appliedBonus;
        this.cachedRepairPercent = Math.min(appliedTotal, 100);
        this.m_6596_();
    }

    public void applyRepair() {
        ItemStack inputTool;
        ItemStack input = (ItemStack)this.items.get(0);
        if (input.m_41619_() || this.cachedRepairPercent <= 0) {
            return;
        }
        boolean isScrap = input.m_150930_(DNLItems.ITEM_SCRAPS.get());
        ItemStack itemStack = inputTool = isScrap ? ScrapItem.getOriginal(input) : input;
        if (inputTool.m_41619_()) {
            return;
        }
        ItemStack mat1 = (ItemStack)this.items.get(1);
        ItemStack mat2 = (ItemStack)this.items.get(2);
        int p1 = this.percentPerItem(inputTool, mat1);
        int p2 = this.percentPerItem(inputTool, mat2);
        boolean s1ToolMat = !mat1.m_41619_() && this.isToolRepairIngredient(inputTool, mat1);
        boolean s1DuriteOrMendstone = !mat1.m_41619_() && (mat1.m_150930_(DNLItems.DURITE.get()) || mat1.m_150930_(DNLItems.MENDSTONE.get()));
        boolean s2ToolMat = !mat2.m_41619_() && this.isToolRepairIngredient(inputTool, mat2);
        boolean s2DuriteOrMendstone = !mat2.m_41619_() && (mat2.m_150930_(DNLItems.DURITE.get()) || mat2.m_150930_(DNLItems.MENDSTONE.get()));
        int remaining = this.cachedBasePercent;
        boolean c1 = false;
        boolean c2 = false;
        if (remaining > 0 && p1 > 0) {
            c1 = true;
            remaining = Math.max(0, remaining - p1);
        }
        if (remaining > 0 && p2 > 0) {
            c2 = true;
        }
        if (this.cachedBonusPercent > 0) {
            boolean haveDurite;
            boolean haveToolMat;
            boolean bl = haveToolMat = c1 && s1ToolMat || c2 && s2ToolMat;
            if (!haveToolMat) {
                if (!c1 && p1 > 0 && s1ToolMat) {
                    c1 = true;
                } else if (!c2 && p2 > 0 && s2ToolMat) {
                    c2 = true;
                }
            }
            boolean bl2 = haveDurite = c1 && s1DuriteOrMendstone || c2 && s2DuriteOrMendstone;
            if (!haveDurite) {
                if (!c1 && p1 > 0 && s1DuriteOrMendstone) {
                    c1 = true;
                } else if (!c2 && p2 > 0 && s2DuriteOrMendstone) {
                    c2 = true;
                }
            }
        }
        if (c1) {
            mat1.m_41774_(1);
        }
        if (c2) {
            mat2.m_41774_(1);
        }
        this.items.set(0, (Object)ItemStack.f_41583_);
        this.items.set(3, (Object)ItemStack.f_41583_);
        this.recalc();
    }
}

