/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.hexnowloading.dungeonnowloading.block.FairkeeperSpawnerBlock;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class FairkeeperSpawnerBlockEntity
extends BlockEntity {
    private static final int SPAWN_RANGE = 4;
    private static final int SPAWN_POS_TRIES = 10;
    private static final Logger LOGGER = LogUtils.getLogger();
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    private SpawnData nextSpawnData;
    private Entity displayEntity;
    private int remainingStoredMobs = 0;
    private int spawnDelay = 0;
    private int startUpTick = 40;
    private int destroyTick = -1;
    private int requiredPlayerRange = 16;
    private double spin;
    private double oSpin;
    private boolean disabled = false;

    public FairkeeperSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(DNLBlockEntityTypes.FAIRKEEPER_SPAWNER.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("RemainingStoredMobs", this.remainingStoredMobs);
        compoundTag.m_128405_("StartUpTick", this.startUpTick);
        compoundTag.m_128405_("SpawnDelay", this.spawnDelay);
        compoundTag.m_128379_("Disabled", this.disabled);
        if (this.nextSpawnData != null) {
            compoundTag.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        compoundTag.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.spawnPotentials).result().orElseThrow());
        super.m_183515_(compoundTag);
    }

    public void m_142466_(CompoundTag compoundTag) {
        boolean b1;
        this.remainingStoredMobs = compoundTag.m_128451_("RemainingStoredMobs");
        this.startUpTick = compoundTag.m_128451_("StartUpTick");
        this.spawnDelay = compoundTag.m_128451_("SpawnDelay");
        this.disabled = compoundTag.m_128471_("Disabled");
        boolean b0 = compoundTag.m_128425_("SpawnData", 10);
        if (b0) {
            SpawnData spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_("SpawnData")).resultOrPartial($$0x -> LOGGER.warn("Invalid SpawnData: {}", $$0x)).orElseGet(SpawnData::new);
            this.setNextSpawnData(this.f_58857_, this.m_58899_(), spawnData);
        }
        if (b1 = compoundTag.m_128425_("SpawnPotentials", 9)) {
            ListTag $$6 = compoundTag.m_128437_("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.f_186560_.parse((DynamicOps)NbtOps.f_128958_, (Object)$$6).resultOrPartial($$0x -> LOGGER.warn("Invalid SpawnPotentials list: {}", $$0x)).orElseGet(SimpleWeightedRandomList::m_185864_);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.m_185862_((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        this.displayEntity = null;
        super.m_142466_(compoundTag);
    }

    protected void setNextSpawnData(Level level, BlockPos blockPos, SpawnData spawnData) {
        this.nextSpawnData = spawnData;
        if (level != null) {
            BlockState blockState = level.m_8055_(blockPos);
            level.m_7260_(blockPos, blockState, blockState, 4);
        }
    }

    public Entity getOrCreateDisplayEntity(Level level, RandomSource randomSource, BlockPos blockPos) {
        if (this.displayEntity == null) {
            CompoundTag $$3 = this.getOrCreateNextSpawnData(level, randomSource, blockPos).m_186567_();
            if (!$$3.m_128425_("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.m_20645_((CompoundTag)$$3, (Level)level, Function.identity());
            if ($$3.m_128440_() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level level, RandomSource randomSource, BlockPos blockPos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(level, blockPos, this.spawnPotentials.m_216829_(randomSource).map(WeightedEntry.Wrapper::m_146310_).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    private boolean isNearPlayer(Level level, BlockPos blockPos) {
        return level.m_45914_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FairkeeperSpawnerBlockEntity blockEntity) {
        if (state.m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT) == Boolean.TRUE) {
            RandomSource randomSource = level.m_213780_();
            double d = (double)pos.m_123341_() + randomSource.m_188500_();
            double e = (double)pos.m_123342_() + randomSource.m_188500_();
            double f = (double)pos.m_123343_() + randomSource.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d, e, f, 0.0, 0.0, 0.0);
        }
        if (!blockEntity.isNearPlayer(level, pos)) {
            blockEntity.oSpin = blockEntity.spin;
        } else if (blockEntity.displayEntity != null) {
            blockEntity.oSpin = blockEntity.spin;
            blockEntity.spin = (blockEntity.spin + (double)(1000.0f / ((float)blockEntity.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FairkeeperSpawnerBlockEntity blockEntity) {
        if (blockEntity.disabled) {
            if (blockEntity.destroyTick < 0) {
                blockEntity.destroyTick = 20 + level.f_46441_.m_188503_(40);
            }
            --blockEntity.destroyTick;
            if (blockEntity.destroyTick == 0) {
                level.m_46961_(pos, false);
                double d = (double)pos.m_123341_() + 0.5;
                double e = (double)pos.m_123342_() + 0.5;
                double f = (double)pos.m_123343_() + 0.5;
                ((ServerLevel)level).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, d, e, f, 10, 0.0, 0.5, 0.5, 0.5);
            }
        }
        if (((Boolean)state.m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT)).booleanValue()) {
            if (blockEntity.startUpTick > 0) {
                if (blockEntity.startUpTick == 40) {
                    level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12558_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.8f);
                }
                --blockEntity.startUpTick;
            } else if (blockEntity.remainingStoredMobs > 0) {
                if (blockEntity.spawnDelay > 0) {
                    --blockEntity.spawnDelay;
                } else {
                    blockEntity.spawnDelay = 20;
                    --blockEntity.remainingStoredMobs;
                    blockEntity.randomMobSummon((ServerLevel)level);
                    level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11862_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.8f);
                }
            } else {
                level.m_46961_(pos, false);
            }
        }
    }

    public void alert(int playerCount, BlockPos blockPos, FairkeeperSpawnerBlockEntity blockEntity) {
        if (blockEntity.m_58900_().m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT) == Boolean.FALSE) {
            FairkeeperSpawnerBlock.setFairkeeperAlert(blockEntity.f_58857_, blockPos, Boolean.TRUE);
            blockEntity.remainingStoredMobs = Math.min(playerCount + 1, 4);
        }
    }

    public void destroyed() {
        AABB aabb = new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_()).m_82400_(32.0);
        List nearbyPlayers = this.f_58857_.m_45976_(Player.class, aabb);
        int playerCount = Math.min(nearbyPlayers.size() + 1, 4);
        for (int i = 0; i < playerCount; ++i) {
            this.randomMobSummon((ServerLevel)this.f_58857_);
        }
    }

    public void randomMobSummon(ServerLevel level) {
        RandomSource randomSource = level.m_213780_();
        SpawnData spawnData = this.getOrCreateNextSpawnData((Level)level, randomSource, this.m_58899_());
        CompoundTag compoundTag = spawnData.m_186567_();
        Optional entityType = EntityType.m_20637_((CompoundTag)compoundTag);
        if (entityType.isEmpty()) {
            return;
        }
        if (!((EntityType)entityType.get()).m_20674_().m_21609_() && level.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            Mob mob1;
            double x = (double)this.m_58899_().m_123341_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * 4.0 + 0.5;
            double y = this.m_58899_().m_123342_() + level.f_46441_.m_188503_(3) - 1;
            double z = (double)this.m_58899_().m_123343_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * 4.0 + 0.5;
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            Entity mob = EntityType.m_20645_((CompoundTag)compoundTag, (Level)level, a -> {
                a.m_7678_(x, y, z, a.m_146908_(), a.m_146909_());
                return a;
            });
            if (mob == null) break;
            mob.m_7678_(x, y, z, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (!(mob instanceof Mob) || !level.m_45756_((Entity)(mob1 = (Mob)mob), ((EntityType)entityType.get()).m_20585_(mob1.m_20185_(), mob1.m_20186_(), mob1.m_20189_())) || !mob1.m_6914_((LevelReader)level)) continue;
            EntityScale.scaleMobAttributes((LivingEntity)mob1);
            mob1.m_21530_();
            if (spawnData.m_186567_().m_128440_() == 1 && spawnData.m_186567_().m_128425_("id", 8)) {
                ((Mob)mob).m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, (SpawnGroupData)null, (CompoundTag)null);
            }
            if (!level.m_8860_((Entity)mob1)) break;
            level.m_46796_(2004, this.m_58899_(), 0);
            level.m_142346_((Entity)mob1, GameEvent.f_157810_, blockPos);
            mob1.m_21373_();
            this.spawnPotentials.m_216829_(randomSource).ifPresent(b -> this.setNextSpawnData((Level)level, blockPos, (SpawnData)b.m_146310_()));
            break;
        }
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

