/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.block.DisabledFairkeeperChestBlock;
import dev.hexnowloading.dungeonnowloading.block.property.ChestStates;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DisabledFairkeeperChestBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private static final int OPEN_CLOSE_ANIMATION_DURATION = 10;
    private int openCloseAnimationProgress = 0;
    private int prevOpenCloseAnimationProgress = 0;

    public DisabledFairkeeperChestBlockEntity(BlockPos pos, BlockState state) {
        super(DNLBlockEntityTypes.DISABLED_FAIRKEEPER_CHEST.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    protected Component m_6820_() {
        if (this.m_58900_().m_60713_(DNLBlocks.WISE_FAIRKEEPER_CHEST.get())) {
            return Component.m_237115_((String)"block.dungeonnowloading.wise_fairkeeper_chest");
        }
        return Component.m_237115_((String)"block.dungeonnowloading.fierce_fairkeeper_chest");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this);
    }

    public int m_6643_() {
        return 27;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            DisabledFairkeeperChestBlock.setFairkeeperChest(this.m_58904_(), this.m_58899_(), ChestStates.OPENING);
            DisabledFairkeeperChestBlockEntity.playSound(this.m_58904_(), this.m_58899_(), SoundEvents.f_11749_);
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            DisabledFairkeeperChestBlock.setFairkeeperChest(this.m_58904_(), this.m_58899_(), ChestStates.CLOSING);
            DisabledFairkeeperChestBlockEntity.playSound(this.m_58904_(), this.m_58899_(), SoundEvents.f_11747_);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, DisabledFairkeeperChestBlockEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.prevOpenCloseAnimationProgress = blockEntity.openCloseAnimationProgress;
            if (state.m_61143_(DNLProperties.CHEST_STATES) == ChestStates.OPENING) {
                if (blockEntity.openCloseAnimationProgress == 10) {
                    DisabledFairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.OPENED);
                } else {
                    ++blockEntity.openCloseAnimationProgress;
                }
            } else if (state.m_61143_(DNLProperties.CHEST_STATES) == ChestStates.CLOSING) {
                if (blockEntity.openCloseAnimationProgress == 0) {
                    DisabledFairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.CLOSED);
                } else {
                    --blockEntity.openCloseAnimationProgress;
                }
            }
        }
    }

    public static void playSound(Level level, BlockPos blockPos, SoundEvent soundEvent) {
        level.m_5594_((Player)null, blockPos, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public float getOpenProgress(float partialTicks) {
        return ((float)this.prevOpenCloseAnimationProgress + (float)(this.openCloseAnimationProgress - this.prevOpenCloseAnimationProgress) * partialTicks) / 10.0f;
    }
}

