/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.property.RedstoneLaneMode;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RedstoneLaneBlock
extends DirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<RedstoneLaneMode> REDSTONE_LANE_MODE = DNLProperties.REDSTONE_LANE_MODE;
    public static final IntegerProperty REDSTONE_LANE_POWER = DNLProperties.REDSTONE_LANE_POWER;

    public RedstoneLaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).m_61124_((Property)REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_())).m_61124_(REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).m_61124_((Property)REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
        stateBuilder.m_61104_(new Property[]{REDSTONE_LANE_MODE});
        stateBuilder.m_61104_(new Property[]{REDSTONE_LANE_POWER});
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (level.m_8055_(blockPos).m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && !(entity instanceof ScuttleEntity)) {
            entity.m_6469_(level.m_269111_().m_269047_(), 6.0f);
            if (!entity.m_5825_()) {
                entity.m_20254_(5);
            }
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldBlockState, boolean b) {
        this.updatePowerStrength(blockState, level, blockPos);
        super.m_6807_(blockState, level, blockPos, oldBlockState, b);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        if (blockState.m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.UNPOWERED) {
            return 0;
        }
        if (direction == Direction.DOWN) {
            return 150;
        }
        List<Direction> directions = this.getConnectionDirection(blockState);
        for (Direction laneDirection : directions) {
            if (blockGetter.m_8055_(blockPos.m_121945_(laneDirection)).m_60734_() instanceof RedstoneLaneBlock || direction != laneDirection.m_122424_()) continue;
            return 150;
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return blockState.m_60746_(blockGetter, blockPos, direction);
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbourBlock, boolean b) {
        if (blockState.m_61143_(REDSTONE_LANE_MODE) == RedstoneLaneMode.UNPOWERED) {
            if (level.m_8055_(neighbourBlock).m_60713_(Blocks.f_50330_)) {
                this.neighbourChangedRedstoneBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if (level.m_8055_(neighbourBlock).m_60713_(DNLBlocks.REDSTONE_IDOL.get())) {
                this.neighbourChangedRedstoneIdolBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if (level.m_8055_(neighbourBlock).m_60713_(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
                this.neighbourChangedOverpoweredBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if ((level.m_8055_(neighbourBlock).m_60713_(DNLBlocks.REDSTONE_LANE_I.get()) || level.m_8055_(neighbourBlock).m_60713_(DNLBlocks.REDSTONE_LANE_L.get()) || level.m_8055_(neighbourBlock).m_60713_(DNLBlocks.REDSTONE_LANE_T.get())) && (level.m_8055_(neighbourBlock).m_61143_(REDSTONE_LANE_MODE) == RedstoneLaneMode.POWERED || level.m_8055_(neighbourBlock).m_61143_(REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED)) {
                this.neighbourChangedLane(blockState, level, blockPos, block, neighbourBlock);
            }
        } else {
            this.updatePowerStrength(blockState, level, blockPos);
        }
    }

    private void updatePowerStrength(BlockState blockState, Level level, BlockPos blockPos) {
        int power;
        boolean hasOverchargedRedstoneBlock;
        List<BlockPos> neighborLaneBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        int originalPower = (Integer)blockState.m_61143_((Property)DNLProperties.REDSTONE_LANE_POWER);
        boolean overpowered = false;
        boolean hasRedstoneBlock = !neighborLaneBlockPosList.stream().filter(b -> level.m_8055_(b).m_60713_(Blocks.f_50330_)).toList().isEmpty();
        boolean bl = hasOverchargedRedstoneBlock = !neighborLaneBlockPosList.stream().filter(b -> level.m_8055_(b).m_60713_(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())).toList().isEmpty();
        if (hasRedstoneBlock || level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50330_) || level.m_8055_(blockPos.m_7494_()).m_60713_(DNLBlocks.REDSTONE_IDOL.get())) {
            if (hasOverchargedRedstoneBlock || level.m_8055_(blockPos.m_7494_()).m_60713_(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
                return;
            }
            power = 150;
        } else if (hasOverchargedRedstoneBlock || level.m_8055_(blockPos.m_7494_()).m_60713_(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
            if (hasRedstoneBlock || level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50330_) || level.m_8055_(blockPos.m_7494_()).m_60713_(DNLBlocks.REDSTONE_IDOL.get())) {
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
                return;
            }
            power = 150;
            overpowered = true;
        } else {
            List<BlockPos> redstoneLanePosList = neighborLaneBlockPosList.stream().filter(b -> level.m_8055_(b).m_60734_() instanceof RedstoneLaneBlock).filter(b -> this.isLaneConnected(level, blockState, blockPos, (BlockPos)b)).toList();
            int highestPower = redstoneLanePosList.stream().mapToInt(b -> (Integer)level.m_8055_(b).m_61143_((Property)DNLProperties.REDSTONE_LANE_POWER)).max().orElse(0);
            overpowered = !redstoneLanePosList.stream().filter(b -> level.m_8055_(b).m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED).toList().isEmpty();
            power = Math.max(highestPower - 1, 0);
        }
        if (originalPower == power) {
            return;
        }
        if (power == 0) {
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)), 2);
        } else if (overpowered) {
            if (blockState.m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.POWERED) {
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
            } else {
                level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            }
        } else if (blockState.m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
        } else {
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
        }
        level.m_46586_(blockPos.m_7494_(), (Block)this, blockPos);
        this.updateConnectedNegihbors(neighborLaneBlockPosList, level, blockPos);
    }

    private void neighbourChangedRedstoneBlock(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbourBlock) {
        BlockPos pos;
        List<BlockPos> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.m_7494_());
        boolean isRedstoneBlock = false;
        Iterator<BlockPos> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isRedstoneBlock) {
            return;
        }
        level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.m_46586_(blockPos.m_7494_(), (Block)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedRedstoneIdolBlock(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbourBlock) {
        BlockPos pos;
        List<BlockPos> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.m_7494_());
        boolean isRedstoneBlock = false;
        Iterator<BlockPos> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isRedstoneBlock) {
            return;
        }
        level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.m_46586_(blockPos.m_7494_(), (Block)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedOverpoweredBlock(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbourBlock) {
        BlockPos pos;
        List<BlockPos> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.m_7494_());
        boolean isOverpoweredBlock = false;
        Iterator<BlockPos> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isOverpoweredBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isOverpoweredBlock) {
            return;
        }
        level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.m_46586_(blockPos.m_7494_(), (Block)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedLane(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbourBlock) {
        boolean overpowered;
        if (!this.isLaneConnected(level, blockState, blockPos, neighbourBlock)) {
            return;
        }
        int power = (Integer)level.m_8055_(neighbourBlock).m_61143_((Property)DNLProperties.REDSTONE_LANE_POWER) - 1;
        boolean bl = overpowered = level.m_8055_(neighbourBlock).m_61143_(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED;
        if (power == 0) {
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)), 2);
        } else {
            if (overpowered) {
                level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            } else {
                level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).m_61124_((Property)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            }
            this.poweredParticle(level, blockState, blockPos);
        }
        level.m_46586_(blockPos.m_7494_(), (Block)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void updateConnectedNegihbors(List<BlockPos> blockPosList, Level level, BlockPos blockPos) {
        for (BlockPos pos : blockPosList) {
            level.m_46586_(pos, (Block)this, blockPos);
        }
    }

    private void updateConnectedNeighborsWithExcluded(Level level, BlockState blockState, BlockPos blockPos, BlockPos excludedBlockPos) {
        List<BlockPos> updateTargets = this.getConnectionBlockPos(blockPos, blockState);
        for (BlockPos pos : updateTargets) {
            if (pos.equals((Object)excludedBlockPos)) continue;
            level.m_46586_(pos, (Block)this, blockPos);
        }
    }

    private boolean isLaneConnected(Level level, BlockState blockState, BlockPos originalBlockPos, BlockPos neighborBlockPos) {
        BlockPos pos;
        BlockPos pos2;
        List<BlockPos> originalBlockPosList = this.getConnectionBlockPos(originalBlockPos, blockState);
        boolean isRedstoneBlock = false;
        Iterator<BlockPos> iterator = originalBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos2 = iterator.next()).equals((Object)neighborBlockPos))) {
        }
        if (!isRedstoneBlock) {
            return false;
        }
        BlockState neighborBlockState = level.m_8055_(neighborBlockPos);
        List<BlockPos> neighborBlockPosList = this.getConnectionBlockPos(neighborBlockPos, neighborBlockState);
        Iterator<BlockPos> iterator2 = neighborBlockPosList.iterator();
        while (iterator2.hasNext() && !(isRedstoneBlock = (pos = iterator2.next()).equals((Object)originalBlockPos))) {
        }
        return isRedstoneBlock;
    }

    private List<BlockPos> getConnectionBlockPos(BlockPos blockPos, BlockState blockState) {
        ArrayList<BlockPos> neighborBlockPosList = new ArrayList<BlockPos>();
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_I.get())) {
            neighborBlockPosList.add(blockPos.m_121945_(direction));
            neighborBlockPosList.add(blockPos.m_121945_(direction.m_122424_()));
        }
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_L.get())) {
            neighborBlockPosList.add(blockPos.m_121945_(direction.m_122428_()));
            neighborBlockPosList.add(blockPos.m_121945_(direction));
        }
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_T.get())) {
            neighborBlockPosList.add(blockPos.m_121945_(direction.m_122428_()));
            neighborBlockPosList.add(blockPos.m_121945_(direction.m_122427_()));
            neighborBlockPosList.add(blockPos.m_121945_(direction));
        }
        return neighborBlockPosList;
    }

    private List<Direction> getConnectionDirection(BlockState blockState) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_I.get())) {
            directions.add(direction);
            directions.add(direction.m_122424_());
        }
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_L.get())) {
            directions.add(direction.m_122428_());
            directions.add(direction);
        }
        if (blockState.m_60713_(DNLBlocks.REDSTONE_LANE_T.get())) {
            directions.add(direction.m_122428_());
            directions.add(direction.m_122427_());
            directions.add(direction);
        }
        return directions;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        switch ((RedstoneLaneMode)((Object)blockState.m_61143_(DNLProperties.REDSTONE_LANE_MODE))) {
            default: {
                break;
            }
            case POWERED: {
                if (!(randomSource.m_188501_() < 0.1f)) break;
                float r = randomSource.m_188501_() - randomSource.m_188501_();
                double x = (double)blockPos.m_123341_() + (double)randomSource.m_188501_();
                double y = (double)blockPos.m_123342_() + 1.1 + 0.1 * (double)r;
                double z = (double)blockPos.m_123343_() + (double)randomSource.m_188501_();
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
                break;
            }
            case OVERPOWERED: {
                double z;
                double y;
                double x;
                float r;
                if (randomSource.m_188501_() < 0.1f) {
                    r = randomSource.m_188501_() - randomSource.m_188501_();
                    x = (double)blockPos.m_123341_() + (double)randomSource.m_188501_();
                    y = (double)blockPos.m_123342_() + 1.1 + 0.1 * (double)r;
                    z = (double)blockPos.m_123343_() + (double)randomSource.m_188501_();
                    level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
                }
                if (!(randomSource.m_188501_() < 0.03f)) break;
                r = randomSource.m_188501_() - randomSource.m_188501_();
                x = (double)blockPos.m_123341_() + (double)randomSource.m_188501_();
                y = (double)blockPos.m_123342_() + 1.1 + 0.1 * (double)r;
                z = (double)blockPos.m_123343_() + (double)randomSource.m_188501_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void poweredParticle(Level level, BlockState blockState, BlockPos blockPos) {
        double x = (double)blockPos.m_123341_() + 0.5;
        double y = (double)blockPos.m_123342_() + 1.1;
        double z = (double)blockPos.m_123343_() + 0.5;
        ((ServerLevel)level).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 5, 0.25, 0.1, 0.25, 0.0);
    }
}

