/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DungeonWallTorch
extends HorizontalDirectionalBlock {
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)4.0, (double)1.0, (double)9.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)7.0, (double)16.0, (double)12.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)16.0, (double)7.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)9.0, (double)1.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = light -> (Boolean)light.m_61143_((Property)LIT) != false ? 14 : 0;

    public DungeonWallTorch(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{LIT});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: 
        }
        return WEST_AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        Level levelReader = blockPlaceContext.m_43725_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        for (Direction direction : directions = blockPlaceContext.m_6232_()) {
            Direction oppositeDirection;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(oppositeDirection = direction.m_122424_()))).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        BlockPos oppositePos = blockPos.m_121945_(direction.m_122424_());
        BlockState oppositeState = levelReader.m_8055_(oppositePos);
        return oppositeState.m_60783_((BlockGetter)levelReader, oppositePos, direction);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        return direction.m_122424_() == blockState.m_61143_((Property)FACING) && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : blockState;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (DungeonWallTorch.isLit(blockState)) {
            Direction direction = (Direction)blockState.m_61143_((Property)FACING);
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.85;
            double z = (double)blockPos.m_123343_() + 0.5;
            Direction directionOpposite = direction.m_122424_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.19 * (double)directionOpposite.m_122429_(), y + 0.22, z + 0.19 * (double)directionOpposite.m_122431_(), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + 0.19 * (double)directionOpposite.m_122429_(), y + 0.22, z + 0.19 * (double)directionOpposite.m_122431_(), 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (player.m_150110_().f_35938_) {
            if (player.m_21120_(interactionHand).m_41619_() && ((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
                DungeonWallTorch.setLit((LevelAccessor)level, blockState, blockPos, false);
                level.m_5594_(null, blockPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            ItemStack flintAndSteel = player.m_21120_(interactionHand);
            if (flintAndSteel.m_150930_(Items.f_42409_) && !((Boolean)blockState.m_61143_((Property)LIT)).booleanValue() && flintAndSteel.m_41773_() < flintAndSteel.m_41776_()) {
                DungeonWallTorch.setLit((LevelAccessor)level, blockState, blockPos, true);
                if (player instanceof ServerPlayer) {
                    flintAndSteel.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(interactionHand));
                }
                level.m_5594_(player, blockPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Projectile projectile;
        if (this.canBeLit(blockState) && entity instanceof Projectile && (projectile = (Projectile)entity).m_6060_() && this.canBeLit(blockState)) {
            DungeonWallTorch.setLit((LevelAccessor)level, blockState, blockPos, true);
        }
    }

    private boolean canBeLit(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false && (Boolean)blockState.m_61143_((Property)LIT) == false;
    }

    private static boolean isLit(BlockState blockState) {
        return blockState.m_61138_((Property)LIT) && (Boolean)blockState.m_61143_((Property)LIT) != false;
    }

    private static void setLit(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, boolean b) {
        levelAccessor.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(b)), 11);
    }
}

