/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.BallistaGolemStatuePartBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.BallistaGolemStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.property.BallistaGolemStatueStates;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BallistaGolemStatueBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final Map<BallistaGolemStatueStates, BlockPos> statePositions = Map.ofEntries(Map.entry(BallistaGolemStatueStates.TOP_N, new BlockPos(0, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_NE, new BlockPos(1, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_E, new BlockPos(1, 2, 0)), Map.entry(BallistaGolemStatueStates.TOP_SE, new BlockPos(1, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_S, new BlockPos(0, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_SW, new BlockPos(-1, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_W, new BlockPos(-1, 2, 0)), Map.entry(BallistaGolemStatueStates.TOP_NW, new BlockPos(-1, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_C, new BlockPos(0, 2, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_N, new BlockPos(0, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_NE, new BlockPos(1, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_E, new BlockPos(1, 1, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_SE, new BlockPos(1, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_S, new BlockPos(0, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_SW, new BlockPos(-1, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_W, new BlockPos(-1, 1, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_NW, new BlockPos(-1, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_C, new BlockPos(0, 1, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_N, new BlockPos(0, 0, -1)), Map.entry(BallistaGolemStatueStates.BOTTOM_NE, new BlockPos(1, 0, -1)), Map.entry(BallistaGolemStatueStates.BOTTOM_E, new BlockPos(1, 0, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_SE, new BlockPos(1, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_S, new BlockPos(0, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_SW, new BlockPos(-1, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_W, new BlockPos(-1, 0, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_NW, new BlockPos(-1, 0, -1)));
    public boolean playerDestroyed = false;

    public BallistaGolemStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction playerFacing;
        BlockPos corePos;
        Level world = context.m_43725_();
        if (this.isAreaClear(world, corePos = context.m_8083_(), playerFacing = context.m_8125_().m_122424_())) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacing);
        }
        return null;
    }

    private boolean isAreaClear(Level world, BlockPos corePos, Direction facing) {
        for (BlockPos relativePos : statePositions.values()) {
            BlockPos partPos = corePos.m_121955_((Vec3i)this.getRotatedPos(relativePos, facing));
            BlockState stateAtPos = world.m_8055_(partPos);
            if (stateAtPos.m_60795_() || stateAtPos.m_247087_()) continue;
            return false;
        }
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_ && placer instanceof Player) {
            Direction playerFacing = placer.m_6350_().m_122424_();
            boolean triggeredByRedstone = false;
            for (Map.Entry<BallistaGolemStatueStates, BlockPos> entry : statePositions.entrySet()) {
                BallistaGolemStatueStates golemState = entry.getKey();
                BlockPos relativePos = entry.getValue();
                BlockPos rotatedPos = this.getRotatedPos(relativePos, playerFacing);
                BlockPos partPos = pos.m_121955_((Vec3i)rotatedPos);
                BlockState partBlockState = (BlockState)((BlockState)DNLBlocks.BALLISTA_GOLEM_STATUE_PART.get().m_49966_().m_61124_((Property)BallistaGolemStatuePartBlock.FACING, (Comparable)playerFacing)).m_61124_(BallistaGolemStatuePartBlock.STATES, (Comparable)((Object)golemState));
                world.m_7731_(partPos, partBlockState, 3);
                if (!world.m_276867_(partPos)) continue;
                triggeredByRedstone = true;
            }
            if (triggeredByRedstone) {
                BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
            } else if (world.m_276867_(pos)) {
                BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
                BallistaGolemStatueBlock.destroyBlocksAbove(world, pos);
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            BallistaGolemStatueBlockEntity blockEntity;
            BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
            BallistaGolemStatueBlock.destroyBlocksAbove(world, pos);
            if (this.playerDestroyed && state.m_60734_() instanceof BallistaGolemStatueBlock && (blockEntity = (BallistaGolemStatueBlockEntity)world.m_7702_(pos)) != null) {
                blockEntity.summonBallistaGolemEntity(world, pos, (Direction)state.m_61143_((Property)FACING));
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public static void destroyAllBlocks(Level world, BlockPos pos) {
        for (Map.Entry<BallistaGolemStatueStates, BlockPos> entry : statePositions.entrySet()) {
            BlockPos relativePos = entry.getValue();
            BlockPos partPos = pos.m_121955_((Vec3i)relativePos);
            world.m_46961_(partPos, false);
        }
    }

    public static void destroyBlocksAbove(Level level, BlockPos blockPos) {
        BlockPos targetPlane = blockPos;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos breakPos = targetPlane.m_7918_(x, 3, z);
                level.m_46961_(breakPos, true);
            }
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_) {
            boolean bl = this.playerDestroyed = !player.m_150110_().f_35937_;
            if (this.playerDestroyed) {
                ItemStack heldItem = player.m_21205_();
                this.playerDestroyed = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)heldItem) < 1;
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (level.f_46443_) {
            return;
        }
        if (!level.m_276867_(blockPos)) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        BallistaGolemStatueBlockEntity blockEntity = (BallistaGolemStatueBlockEntity)level.m_7702_(blockPos);
        if (blockEntity != null) {
            blockEntity.summonBallistaGolemEntity(level, blockPos, facing);
        }
        BallistaGolemStatueBlock.destroyAllBlocks(level, blockPos);
        BallistaGolemStatueBlock.destroyBlocksAbove(level, blockPos);
    }

    private BlockPos getRotatedPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return pos;
            }
            case SOUTH: {
                return new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            }
            case WEST: {
                return new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            }
            case EAST: {
                return new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            }
        }
        return pos;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BallistaGolemStatueBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState $blockState0) {
        return RenderShape.MODEL;
    }

    public void setPlayerDestroyed(boolean b) {
        this.playerDestroyed = b;
    }

    public static Direction getDirection(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)FACING);
    }
}

