/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server.world.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import quilt.net.mca.server.world.data.VillageManager;
import quilt.net.mca.util.NbtHelper;
import quilt.net.mca.util.WorldUtils;

public class GraveyardManager
extends class_18 {
    private final Map<TombstoneState, Long2ObjectMap<ChunkBase>> tombstones = new EnumMap<TombstoneState, Long2ObjectMap<ChunkBase>>(TombstoneState.class);

    public static GraveyardManager get(class_3218 world) {
        return WorldUtils.loadData(world, GraveyardManager::new, GraveyardManager::new, "mca_graveyard");
    }

    public GraveyardManager(class_3218 world) {
    }

    public GraveyardManager(class_2487 nbt) {
        this.tombstones.putAll(NbtHelper.toMap(nbt, TombstoneState::valueOf, v -> {
            class_2487 vv = (class_2487)v;
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            vv.method_10541().forEach(arg_0 -> GraveyardManager.lambda$new$0((Long2ObjectMap)map, vv, arg_0));
            return map;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2487 method_75(class_2487 nbt) {
        class_2487 tag = new class_2487();
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            this.tombstones.forEach((state, chunks) -> {
                class_2487 chunkList = new class_2487();
                chunks.long2ObjectEntrySet().forEach(entry -> {
                    if (!((ChunkBase)entry.getValue()).isEmpty()) {
                        chunkList.method_10566(String.valueOf(entry.getLongKey()), (class_2520)((ChunkBase)entry.getValue()).toNbt());
                    }
                });
                if (!chunkList.method_33133()) {
                    tag.method_10566(state.name(), (class_2520)chunkList);
                }
            });
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTombstoneState(class_2338 pos, TombstoneState state) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(state.opposite(), l, ChunkBase::empty).removePos(pos);
            this.getChunk(state, l, Chunk::new).addPos(pos);
            this.method_80();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTombstoneState(class_2338 pos) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).removePos(pos);
            this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).removePos(pos);
            this.method_80();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_2338> findAll(class_238 box, boolean includeEmpty, boolean includeFilled) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        if (includeEmpty || includeFilled) {
            int minX = class_3532.method_15357((double)((box.field_1323 - 2.0) / 16.0));
            int maxX = class_3532.method_15384((double)((box.field_1320 + 2.0) / 16.0));
            int minZ = class_3532.method_15357((double)((box.field_1321 - 2.0) / 16.0));
            int maxZ = class_3532.method_15384((double)((box.field_1324 + 2.0) / 16.0));
            class_2338.class_2339 mutable = new class_2338.class_2339();
            Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
            synchronized (map) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        long l = class_1923.method_8331((int)x, (int)z);
                        if (includeEmpty) {
                            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).appendAll(box, mutable, positions);
                        }
                        if (!includeFilled) continue;
                        this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).appendAll(box, mutable, positions);
                    }
                }
            }
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<class_2338> findNearest(class_2338 pos, TombstoneState state, int maxChunkRange) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            return this.getChunk(state, GraveyardManager.getChunkPos(pos), ChunkBase::empty).findNearest(pos, mutable).or(() -> {
                class_2338 center = new class_2338(class_4076.method_18675((int)pos.method_10263()), 0, class_4076.method_18675((int)pos.method_10260()));
                return class_2338.method_25998((class_2338)center, (int)maxChunkRange, (int)0, (int)maxChunkRange).map(p -> class_1923.method_8331((int)p.method_10263(), (int)p.method_10260())).map(l -> this.getChunk(state, (long)l, ChunkBase::empty).findNearest(pos, mutable)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(a -> a.method_10262((class_2382)pos)));
            });
        }
    }

    private static long getChunkPos(class_2338 pos) {
        return class_1923.method_8331((int)class_4076.method_18675((int)pos.method_10263()), (int)class_4076.method_18675((int)pos.method_10260()));
    }

    private ChunkBase getChunk(TombstoneState state, long pos, LongFunction<ChunkBase> fallback) {
        Long2ObjectMap chunks = this.tombstones.computeIfAbsent(state, n -> new Long2ObjectOpenHashMap());
        ChunkBase chunk = (ChunkBase)chunks.get(pos);
        if (chunk == null && (chunk = fallback.apply(pos)) != ChunkBase.EMPTY) {
            chunks.put(pos, (Object)chunk);
        }
        return chunk;
    }

    public void reportToVillageManager(class_1297 entity) {
        VillageManager manager = VillageManager.get((class_3218)entity.method_37908());
        GraveyardManager.get((class_3218)entity.method_37908()).findAll(entity.method_5829().method_1014(24.0), true, true).stream().filter(p -> !manager.cache.contains(p)).forEach(manager::processBuilding);
    }

    private static /* synthetic */ void lambda$new$0(Long2ObjectMap map, class_2487 vv, String key) {
        map.put(Long.parseLong(key), (Object)new Chunk((class_2499)vv.method_10580(key)));
    }

    public static enum TombstoneState {
        EMPTY,
        FILLED;


        TombstoneState opposite() {
            return this == EMPTY ? FILLED : EMPTY;
        }
    }

    private static class ChunkBase {
        static final ChunkBase EMPTY = new ChunkBase();

        private ChunkBase() {
        }

        static ChunkBase empty(long l) {
            return EMPTY;
        }

        public boolean isEmpty() {
            return true;
        }

        public class_2499 toNbt() {
            return new class_2499();
        }

        public void removePos(class_2338 pos) {
        }

        public void addPos(class_2338 pos) {
        }

        public Optional<class_2338> findNearest(class_2338 pos, class_2338.class_2339 mutable) {
            return Optional.empty();
        }

        public void appendAll(class_238 box, class_2338.class_2339 mutable, List<class_2338> positions) {
        }
    }

    private static class Chunk
    extends ChunkBase {
        private final LongSet tombstones = new LongArraySet();

        Chunk(long l) {
        }

        Chunk(class_2499 list) {
            list.forEach(l -> this.tombstones.add(((class_2514)l).method_10699()));
        }

        @Override
        public boolean isEmpty() {
            return this.tombstones.isEmpty();
        }

        @Override
        public class_2499 toNbt() {
            class_2499 list = new class_2499();
            this.tombstones.forEach(l -> list.add((Object)class_2503.method_23251((long)l)));
            return list;
        }

        @Override
        public void removePos(class_2338 pos) {
            this.tombstones.remove(pos.method_10063());
        }

        @Override
        public void addPos(class_2338 pos) {
            this.tombstones.add(pos.method_10063());
        }

        @Override
        public Optional<class_2338> findNearest(class_2338 pos, class_2338.class_2339 mutable) {
            double distance = Double.MAX_VALUE;
            long nearest = -1L;
            boolean found = false;
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.method_16363(l);
                double d = pos.method_10262((class_2382)mutable);
                if (!(d < distance)) continue;
                distance = d;
                nearest = l;
                found = true;
            }
            return found ? Optional.of(class_2338.method_10092((long)nearest)) : Optional.empty();
        }

        @Override
        public void appendAll(class_238 box, class_2338.class_2339 mutable, List<class_2338> positions) {
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.method_16363(l);
                if (!box.method_1008((double)mutable.method_10263(), (double)mutable.method_10264(), (double)mutable.method_10260())) continue;
                positions.add(mutable.method_10062());
            }
        }
    }
}

