/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship;

import forge.net.mca.Config;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import forge.net.mca.resources.API;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public enum AgeState implements VillagerDimensions
{
    UNASSIGNED(1.0f, 0.9f, 1.0f, 1.0f, 1.0f, 1.0f),
    BABY(0.45f, 0.4f, 0.0f, 1.5f, 0.0f, 1.6f),
    TODDLER(0.6f, 0.55f, 0.0f, 1.3f, 0.65f, 1.4f),
    CHILD(0.7f, 0.65f, 0.0f, 1.2f, 0.9f, 1.2f),
    TEEN(0.85f, 0.85f, 0.5f, 1.0f, 1.05f, 1.0f),
    ADULT(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);

    private static final AgeState[] VALUES;
    private final float width;
    private final float height;
    private final float breasts;
    private final float head;
    private final float speed;
    private final float pitch;

    public static int getMaxAge() {
        return Config.getServerConfig().villagerMaxAgeTime;
    }

    public static int getStageDuration() {
        return AgeState.getMaxAge() / 4;
    }

    private AgeState(float width, float height, float breasts, float head, float speed, float pitch) {
        this.width = width;
        this.height = height;
        this.breasts = breasts;
        this.head = head;
        this.speed = speed;
        this.pitch = pitch;
    }

    public Component getName() {
        return Component.m_237115_((String)("enum.agestate." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getBreasts() {
        return this.breasts;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getHead() {
        return this.head;
    }

    public float getSpeed() {
        return this.speed;
    }

    public AgeState getNext() {
        if (this == ADULT) {
            return this;
        }
        return AgeState.byId(this.ordinal() + 1);
    }

    public static AgeState byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    public static AgeState random() {
        return AgeState.byCurrentAge((int)(-API.getRng().m_188501_() * (float)AgeState.getMaxAge()));
    }

    public static float getDelta(float age) {
        return 1.0f - -age % (float)AgeState.getStageDuration() / (float)AgeState.getStageDuration();
    }

    public static int getId(int age) {
        return Mth.m_14045_((int)(1 + (age + AgeState.getMaxAge()) / AgeState.getStageDuration()), (int)0, (int)5);
    }

    public static AgeState byCurrentAge(int age) {
        return AgeState.byId(AgeState.getId(age));
    }

    public int toAge() {
        return (this.ordinal() - 1) * AgeState.getStageDuration() - AgeState.getMaxAge();
    }

    static {
        VALUES = AgeState.values();
    }
}

