/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.mca.Config;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class VillagerEntityBaseModelMCA<T extends LivingEntity>
extends HumanoidModel<T>
implements CommonVillagerModel<T> {
    protected static final String BREASTS = "breasts";
    public final ModelPart breasts;
    final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public VillagerEntityBaseModelMCA(ModelPart root) {
        super(root);
        this.breasts = root.m_171324_(BREASTS);
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = HumanoidModel.m_170681_((CubeDeformation)dilation, (float)0.0f);
        PartDefinition data = modelData.m_171576_();
        data.m_171599_(BREASTS, VillagerEntityBaseModelMCA.newBreasts(dilation, 0), PartPose.f_171404_);
        return modelData;
    }

    protected static CubeListBuilder newBreasts(CubeDeformation dilation, int oy) {
        CubeListBuilder builder = CubeListBuilder.m_171558_();
        if (Config.getInstance().enableBoobs) {
            builder.m_171514_(18, 21 + oy).m_171488_(-3.25f, -1.25f, -1.5f, 6.0f, 3.0f, 3.0f, dilation);
        }
        return builder;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_, (Object)this.f_102809_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_);
    }

    public void m_6839_(T entity, float limbAngle, float limbDistance, float tickDelta) {
        super.m_6839_(entity, limbDistance, limbAngle, tickDelta);
        this.f_102609_ |= ((VillagerLike)entity).getAgeState() == AgeState.BABY;
    }

    public void m_6973_(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.m_20159_()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).f_19797_ / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).f_19797_ / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).f_19797_ / 2.0f);
        }
        if (villager.m_6162_()) {
            limbAngle /= 3.0f;
        }
        super.m_6973_(villager, limbAngle /= 0.2f + ((VillagerLike)villager).getRawScaleFactor(), limbDistance, animationProgress, headYaw, headPitch);
        if (((VillagerLike)villager).getVillagerBrain().isPanicking()) {
            float toRadians = (float)Math.PI / 180;
            float armRaise = ((float)Math.sin(animationProgress / 5.0f) * 30.0f - 180.0f + (float)Math.sin(animationProgress / 3.0f) * 3.0f) * toRadians;
            float waveSideways = ((float)Math.sin(animationProgress / 2.0f) * 12.0f - 17.0f) * toRadians;
            this.f_102812_.f_104203_ = armRaise;
            this.f_102812_.f_104205_ = -waveSideways;
            this.f_102811_.f_104203_ = -armRaise;
            this.f_102811_.f_104205_ = waveSideways;
        }
        this.applyVillagerDimensions((VillagerLike)villager, villager.m_6047_());
    }

    public void m_102872_(HumanoidModel<T> target) {
        super.m_102872_(target);
        if (target instanceof VillagerEntityBaseModelMCA) {
            VillagerEntityBaseModelMCA m = (VillagerEntityBaseModelMCA)target;
            this.copyCommonAttributes(m);
            m.breasts.f_104207_ = this.breasts.f_104207_;
            m.breasts.m_104315_(this.breasts);
        }
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.renderCommon(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    @Override
    public ModelPart getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelPart getBodyPart() {
        return this.f_102810_;
    }

    @Override
    public Iterable<ModelPart> getCommonHeadParts() {
        return this.m_5607_();
    }

    @Override
    public Iterable<ModelPart> getCommonBodyParts() {
        return this.m_5608_();
    }

    @Override
    public Iterable<ModelPart> getBreastParts() {
        return ImmutableList.of((Object)this.breasts);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }
}

