/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block.entity;

import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.netherchested.world.inventory.NetherChestMenu;
import fuzs.netherchested.world.level.block.entity.NamedBlockEntity;
import fuzs.puzzlesapi.api.limitlesscontainers.v1.LimitlessContainerUtils;
import fuzs.puzzlesapi.api.limitlesscontainers.v1.MultipliedContainer;
import fuzs.puzzleslib.api.container.v1.ContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class NetherChestBlockEntity
extends NamedBlockEntity
implements LidBlockEntity {
    public static final int CONTAINER_SIZE = 54;
    private static final MutableComponent CONTAINER_TITLE = Component.m_237115_((String)"container.nether_chest");
    private final ContainerOpenersCounter openersCounter = new NetherChestOpenersCounter();
    private final ChestLidController chestLidController = new ChestLidController();
    public final MultipliedContainer container = new NetherChestContainer();
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);

    public NetherChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.get(), blockPos, blockState);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, NetherChestBlockEntity blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Override
    protected Component getDefaultName() {
        return CONTAINER_TITLE;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
        LimitlessContainerUtils.loadAllItems((CompoundTag)tag, this.items);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128473_("Items");
        LimitlessContainerUtils.saveAllItems((CompoundTag)tag, this.items, (boolean)true);
    }

    @Override
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new NetherChestMenu(containerId, inventory, this.container);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private class NetherChestOpenersCounter
    extends ContainerOpenersCounter {
        private NetherChestOpenersCounter() {
        }

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11889_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11888_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int count, int openCount) {
            level.m_7696_(pos, state.m_60734_(), 1, openCount);
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof NetherChestMenu) {
                NetherChestMenu netherChestMenu = (NetherChestMenu)abstractContainerMenu;
                return netherChestMenu.getContainer() == NetherChestBlockEntity.this.container;
            }
            return false;
        }
    }

    private class NetherChestContainer
    implements ContainerImpl,
    MultipliedContainer {
        private NetherChestContainer() {
        }

        public NonNullList<ItemStack> getItems() {
            return NetherChestBlockEntity.this.items;
        }

        public void m_5856_(Player player) {
            if (!NetherChestBlockEntity.this.f_58859_ && !player.m_5833_()) {
                NetherChestBlockEntity.this.openersCounter.m_155452_(player, NetherChestBlockEntity.this.m_58904_(), NetherChestBlockEntity.this.m_58899_(), NetherChestBlockEntity.this.m_58900_());
            }
        }

        public void m_5785_(Player player) {
            if (!NetherChestBlockEntity.this.f_58859_ && !player.m_5833_()) {
                NetherChestBlockEntity.this.openersCounter.m_155468_(player, NetherChestBlockEntity.this.m_58904_(), NetherChestBlockEntity.this.m_58899_(), NetherChestBlockEntity.this.m_58900_());
            }
        }

        public void m_6596_() {
            NetherChestBlockEntity.this.m_6596_();
        }

        public int getStackSizeMultiplier() {
            return ((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).stackSizeMultiplier;
        }
    }
}

