/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.core.CoreRegistry;
import com.blackgear.platform.core.helper.forge.ItemRegistryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ItemRegistry {
    private final CoreRegistry<Item> items;

    private ItemRegistry(String modId) {
        this.items = CoreRegistry.create(BuiltInRegistries.f_257033_, modId);
    }

    public static ItemRegistry create(String modId) {
        return new ItemRegistry(modId);
    }

    public <T extends Item> Supplier<T> register(String name, Supplier<T> item) {
        return this.items.register(name, item);
    }

    public Supplier<Item> register(String name) {
        return this.register(name, new Item.Properties());
    }

    public Supplier<Item> register(String name, Item.Properties properties) {
        return this.register(name, Item::new, properties);
    }

    public Supplier<Item> register(String name, Function<Item.Properties, Item> function) {
        return this.register(name, function, new Item.Properties());
    }

    public Supplier<Item> register(String name, Function<Item.Properties, Item> factory, Item.Properties properties) {
        return this.items.register(name, () -> (Item)factory.apply(properties));
    }

    public <T extends Mob> Supplier<Item> spawnEgg(String name, Supplier<EntityType<T>> entity, int primaryColor, int secondaryColor, Item.Properties properties) {
        return this.items.register(name, () -> ItemRegistry.createSpawnEgg(entity, primaryColor, secondaryColor, properties));
    }

    public Supplier<Item> fromBlock(Supplier<Block> block) {
        return () -> ((Block)block.get()).m_5456_();
    }

    public void register() {
        this.items.register();
    }

    public CoreRegistry<Item> registry() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Mob> Item createSpawnEgg(Supplier<EntityType<T>> entity, int primaryColor, int secondaryColor, Item.Properties properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemRegistryImpl.createSpawnEgg(entity, (int)var1_1, (int)var2_2, (Item.Properties)var3_3);
    }
}

