/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Calendar;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaLootConditions;
import org.jetbrains.annotations.NotNull;

public record DateCondition(int month, int startDay, int endDay) implements LootItemCondition
{
    public static LootItemCondition.Builder builder(int month, int startDay, int endDay) {
        return () -> new DateCondition(month, startDay, endDay);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ValhelsiaLootConditions.DATE.get();
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of();
    }

    public boolean test(LootContext lootContext) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == this.month && calendar.get(5) >= this.startDay && calendar.get(5) <= this.endDay;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<DateCondition> {
        public void serialize(@NotNull JsonObject jsonObject, DateCondition instance, @NotNull JsonSerializationContext context) {
            jsonObject.addProperty("month", (Number)instance.month);
            jsonObject.addProperty("start_day", (Number)instance.startDay);
            jsonObject.addProperty("end_day", (Number)instance.endDay);
        }

        @NotNull
        public DateCondition deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            return new DateCondition(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"month"), GsonHelper.m_13927_((JsonObject)jsonObject, (String)"start_day"), GsonHelper.m_13927_((JsonObject)jsonObject, (String)"end_day"));
        }
    }
}

