/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.happy_ghasts_boost.impl.common.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SimpleConfig {
    private final Map<String, String> entries = new HashMap<String, String>();

    public SimpleConfig(String filePath) throws IOException {
        this.load(filePath);
    }

    private void load(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (parts = line.split("=", 2)).length != 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim();
                this.entries.put(key, value);
            }
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.entries.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getInteger(String key, int defaultValue) {
        String value = this.entries.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.entries.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }
}

