/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.init.TGSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ReaperEntity
extends HostileGraveyardEntity
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    protected final byte ANIMATION_IDLE = 0;
    protected final byte ANIMATION_WALK = 1;
    protected final byte ANIMATION_SPAWN = (byte)2;
    protected final byte ANIMATION_DEATH = (byte)3;
    protected final byte ANIMATION_ATTACK = (byte)4;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(ReaperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> VEX_FLAGS = SynchedEntityData.m_135353_(ReaperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int CHARGING_FLAG = 1;
    Mob owner;
    @Nullable
    private BlockPos bounds;

    public ReaperEntity(EntityType<? extends ReaperEntity> entityType, Level world) {
        super(entityType, world, "reaper");
        this.f_21342_ = new ReaperMoveControl(this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VEX_FLAGS, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("BoundX")) {
            this.bounds = new BlockPos(nbt.m_128451_("BoundX"), nbt.m_128451_("BoundY"), nbt.m_128451_("BoundZ"));
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.bounds != null) {
            nbt.m_128405_("BoundX", this.bounds.m_123341_());
            nbt.m_128405_("BoundY", this.bounds.m_123342_());
            nbt.m_128405_("BoundZ", this.bounds.m_123343_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new ChargeTargetGoal());
        this.f_21345_.m_25352_(8, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new TrackOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        super.m_6478_(movementType, movement);
        this.m_20101_();
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setAnimation((byte)2);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public BlockPos getBounds() {
        return this.bounds;
    }

    private boolean areFlagsSet(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.areFlagsSet(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public static AttributeSupplier.Builder createReaperAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, event -> {
            AnimationController controller = event.getController();
            float limbSwingAmount = event.getLimbSwingAmount();
            boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
            boolean isDying = this.m_21224_();
            boolean isAttacking = this.m_5912_();
            if (isDying) {
                controller.setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (isAttacking || this.isCharging()) {
                controller.setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            byte currentAnimation = this.getAnimation();
            switch (currentAnimation) {
                case 4: {
                    controller.setAnimation(this.ATTACK_ANIMATION);
                    break;
                }
                default: {
                    controller.setAnimation(isMoving ? this.WALK_ANIMATION : this.IDLE_ANIMATION);
                }
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void m_8032_() {
        this.m_5496_(TGSounds.REAPER_AMBIENT.get(), 1.0f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_(TGSounds.REAPER_HURT.get(), 1.0f, -10.0f);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.m_5496_(TGSounds.REAPER_DEATH.get(), 1.0f, -10.0f);
    }

    private class ReaperMoveControl
    extends MoveControl {
        public ReaperMoveControl(ReaperEntity owner) {
            super((Mob)owner);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3d = new Vec3(this.f_24975_ - ReaperEntity.this.m_20185_(), this.f_24976_ - ReaperEntity.this.m_20186_(), this.f_24977_ - ReaperEntity.this.m_20189_());
                double d = vec3d.m_82553_();
                if (d < ReaperEntity.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    ReaperEntity.this.m_20256_(ReaperEntity.this.m_20184_().m_82490_(0.5));
                } else {
                    ReaperEntity.this.m_20256_(ReaperEntity.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.05 / d)));
                    if (ReaperEntity.this.m_5448_() == null) {
                        Vec3 vec3d2 = ReaperEntity.this.m_20184_();
                        ReaperEntity.this.m_146922_(-((float)Mth.m_14136_((double)vec3d2.f_82479_, (double)vec3d2.f_82481_)) * 57.295776f);
                        ReaperEntity.this.f_20883_ = ReaperEntity.this.m_146908_();
                    } else {
                        double e = ReaperEntity.this.m_5448_().m_20185_() - ReaperEntity.this.m_20185_();
                        double f = ReaperEntity.this.m_5448_().m_20189_() - ReaperEntity.this.m_20189_();
                        ReaperEntity.this.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                        ReaperEntity.this.f_20883_ = ReaperEntity.this.m_146908_();
                    }
                }
            }
        }
    }

    class ChargeTargetGoal
    extends Goal {
        public ChargeTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (ReaperEntity.this.m_5448_() != null && !ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.f_19796_.m_188503_(7) == 0) {
                return ReaperEntity.this.m_20280_((Entity)ReaperEntity.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.isCharging() && ReaperEntity.this.m_5448_() != null && ReaperEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingEntity = ReaperEntity.this.m_5448_();
            Vec3 vec3d = livingEntity.m_146892_();
            ReaperEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            ReaperEntity.this.setCharging(true);
            ReaperEntity.this.m_5496_(TGSounds.REAPER_CHARGE.get(), 1.0f, -10.0f);
        }

        public void m_8041_() {
            ReaperEntity.this.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingEntity = ReaperEntity.this.m_5448_();
            if (ReaperEntity.this.m_20191_().m_82381_(livingEntity.m_20191_())) {
                ReaperEntity.this.m_7327_((Entity)livingEntity);
                ReaperEntity.this.setCharging(false);
            } else {
                double d = ReaperEntity.this.m_20280_((Entity)livingEntity);
                if (d < 9.0) {
                    Vec3 vec3d = livingEntity.m_146892_();
                    ReaperEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                }
            }
        }
    }

    private class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.f_19796_.m_188503_(7) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockPos = ReaperEntity.this.getBounds();
            if (blockPos == null) {
                blockPos = ReaperEntity.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.m_7918_(ReaperEntity.this.f_19796_.m_188503_(15) - 7, ReaperEntity.this.f_19796_.m_188503_(11) - 5, ReaperEntity.this.f_19796_.m_188503_(15) - 7);
                if (!ReaperEntity.this.m_20193_().m_46859_(blockPos2)) continue;
                ReaperEntity.this.f_21342_.m_6849_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.5, (double)blockPos2.m_123343_() + 0.5, 0.25);
                if (ReaperEntity.this.m_5448_() != null) break;
                ReaperEntity.this.m_21563_().m_24950_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.5, (double)blockPos2.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class TrackOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions TRACK_OWNER_PREDICATE;

        public TrackOwnerTargetGoal(PathfinderMob mob) {
            super((Mob)mob, false);
            this.TRACK_OWNER_PREDICATE = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return ReaperEntity.this.owner != null && ReaperEntity.this.owner.m_5448_() != null && this.m_26150_(ReaperEntity.this.owner.m_5448_(), this.TRACK_OWNER_PREDICATE);
        }

        public void m_8056_() {
            ReaperEntity.this.m_6710_(ReaperEntity.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

