/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.HordeGraveyardEntity;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AngerableGraveyardEntity
extends HordeGraveyardEntity
implements NeutralMob {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(AngerableGraveyardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PROVOKED = SynchedEntityData.m_135353_(AngerableGraveyardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID target;
    private int ageWhenTargetSet;
    private int angerTime;

    public AngerableGraveyardEntity(EntityType<? extends Monster> entityType, Level world, String name) {
        super(entityType, world, name);
    }

    @Override
    public void m_8107_() {
        if (!this.m_20193_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_20193_(), true);
        }
        super.m_8107_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)false);
        this.f_19804_.m_135372_(PROVOKED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_20193_(), nbt);
    }

    public boolean m_21660_() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void m_7870_(int ticks) {
        this.angerTime = ticks;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.target;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.target = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.f_19804_.m_135381_(ANGRY, (Object)false);
            this.m_7870_(0);
            this.f_19804_.m_135381_(PROVOKED, (Object)false);
            entityAttributeInstance.m_22130_(ATTACKING_SPEED_BOOST);
        } else {
            this.ageWhenTargetSet = this.f_19797_;
            this.f_19804_.m_135381_(ANGRY, (Object)true);
            if (!entityAttributeInstance.m_22109_(ATTACKING_SPEED_BOOST)) {
                entityAttributeInstance.m_22118_(ATTACKING_SPEED_BOOST);
            }
        }
    }
}

