/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlocksColorAPI {
    public static final List<DyeColor> SORTED_COLORS = (List)Util.m_137537_(() -> {
        ImmutableList.Builder b = ImmutableList.builder();
        List<DyeColor> l = List.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
        b.addAll(l);
        for (DyeColor v : DyeColor.values()) {
            if (l.contains(v)) continue;
            b.add((Object)v);
        }
        return b.build();
    });

    @Nullable
    public static DyeColor getColor(Block block) {
        return BlocksColorInternal.INSTANCE.getColor(block);
    }

    @Nullable
    public static DyeColor getColor(Item item) {
        return BlocksColorInternal.INSTANCE.getColor(item);
    }

    @Nullable
    public static Item getColoredItem(String key, @Nullable DyeColor color) {
        return BlocksColorInternal.INSTANCE.getColoredItem(key, color);
    }

    @Nullable
    public static Block getColoredBlock(String key, @Nullable DyeColor color) {
        return BlocksColorInternal.INSTANCE.getColoredBlock(key, color);
    }

    public static boolean isDefaultColor(Block block) {
        String key = BlocksColorAPI.getKey(block);
        if (key == null) {
            return true;
        }
        return BlocksColorAPI.getColoredBlock(key, null) == block;
    }

    public static boolean isDefaultColor(Item item) {
        String key = BlocksColorAPI.getKey(item);
        if (key == null) {
            return true;
        }
        return BlocksColorAPI.getColoredItem(key, null) == item;
    }

    @Nullable
    public static Block changeColor(Block old, @Nullable DyeColor newColor) {
        return BlocksColorInternal.INSTANCE.changeColor(old, newColor);
    }

    @Nullable
    public static Item changeColor(Item old, @Nullable DyeColor newColor) {
        return BlocksColorInternal.INSTANCE.changeColor(old, newColor);
    }

    @Nullable
    public static String getKey(Block block) {
        return BlocksColorInternal.INSTANCE.getKey(block);
    }

    @Nullable
    public static String getKey(Item item) {
        return BlocksColorInternal.INSTANCE.getKey(item);
    }

    public static Set<String> getBlockKeys() {
        return BlocksColorInternal.INSTANCE.getBlockKeys();
    }

    public static Set<String> getItemKeys() {
        return BlocksColorInternal.INSTANCE.getItemKeys();
    }

    @Nullable
    public static HolderSet<Block> getBlockHolderSet(String key) {
        return BlocksColorInternal.INSTANCE.getBlockHolderSet(key);
    }

    @Nullable
    public static HolderSet<Item> getItemHolderSet(String key) {
        return BlocksColorInternal.INSTANCE.getItemHolderSet(key);
    }

    @Deprecated(forRemoval=true)
    public static void registerBlockColorSet(ResourceLocation key, EnumMap<DyeColor, Block> blocks, @Nullable Block defaultBlock) {
    }

    @Deprecated(forRemoval=true)
    public static void registerItemColorSet(ResourceLocation key, EnumMap<DyeColor, Item> items, @Nullable Item defaultItem) {
    }

    public static <T> Stream<T> ordered(Map<DyeColor, T> map) {
        return map.entrySet().stream().sorted(Comparator.comparing(entry -> SORTED_COLORS.indexOf(entry.getKey()))).map(Map.Entry::getValue);
    }
}

