/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.foliage;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.zepalesque.redux.world.tree.foliage.ReduxFoliagePlacers;

public class BlightwillowFoliagePlacer
extends FoliagePlacer {
    public static final Codec<BlightwillowFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> BlightwillowFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BlightwillowFoliagePlacer::new));

    public BlightwillowFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource rand, TreeConfiguration config, int maxHeight, FoliagePlacer.FoliageAttachment attachment, int height, int radius, int offset) {
        BlockPos origin = attachment.m_161451_();
        this.m_225628_(level, setter, rand, config, origin, radius - 1, 0, false);
        this.m_225628_(level, setter, rand, config, origin, radius, -1, false);
        this.m_225628_(level, setter, rand, config, origin, radius, -2, false);
        this.m_225628_(level, setter, rand, config, origin, radius, -3, false);
        this.m_225628_(level, setter, rand, config, origin, radius, -4, false);
        this.m_225628_(level, setter, rand, config, origin, radius, -5, false);
        this.m_225628_(level, setter, rand, config, origin, radius - 1, -6, false);
        BlockPos spineStart = origin.m_6625_(4);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            this.placeSpine(level, setter, rand, config, spineStart.m_5484_(d, radius + 1), radius, mutable, d);
        }
    }

    private void placeSpine(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource rand, TreeConfiguration config, BlockPos start, int radius, BlockPos.MutableBlockPos mutable, Direction d) {
        int i;
        boolean extendBelow = false;
        boolean extendAbove = false;
        for (i = -1; i < 7; ++i) {
            boolean place;
            boolean isHighest = i == 6;
            boolean isLowest = i == -1;
            boolean bl = place = !isLowest && !isHighest || rand.m_188499_();
            if (!place) continue;
            if (isLowest) {
                extendBelow = true;
            }
            if (isHighest) {
                extendAbove = true;
            }
            mutable.m_122154_((Vec3i)start, 0, i, 0);
            this.m_225628_(level, setter, rand, config, (BlockPos)mutable, 0, 0, false);
        }
        this.placeSideSpine(level, setter, rand, config, start, radius, mutable, d.m_122428_(), extendBelow);
        this.placeSideSpine(level, setter, rand, config, start, radius, mutable, d.m_122427_(), extendBelow);
        for (i = 1; i < radius + 3; ++i) {
            boolean place;
            boolean bl = place = (i != 1 || extendBelow && rand.m_188501_() < 0.75f) && (i != radius + 2 || extendAbove && rand.m_188501_() < 0.75f);
            if (!place) continue;
            mutable.m_122154_((Vec3i)start, d.m_122436_().m_123341_(), i, d.m_122436_().m_123343_());
            this.m_225628_(level, setter, rand, config, (BlockPos)mutable, 0, 0, false);
        }
    }

    private void placeSideSpine(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource rand, TreeConfiguration config, BlockPos start, int radius, BlockPos.MutableBlockPos mutable, Direction d, boolean extendBelow) {
        for (int i = 0; i <= radius; ++i) {
            boolean place;
            boolean bl = place = i != 0 || extendBelow && rand.m_188501_() < 0.75f;
            if (!place) continue;
            mutable.m_122154_((Vec3i)start, d.m_122436_().m_123341_(), i, d.m_122436_().m_123343_());
            this.m_225628_(level, setter, rand, config, (BlockPos)mutable, 0, 0, false);
        }
    }

    protected void m_225628_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos, int radius, int y, boolean large) {
        if (radius <= 0 && !this.m_214202_(random, 0, y, 0, radius, large)) {
            BlightwillowFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos.m_6630_(y));
            return;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius; ++j) {
            for (int k = -radius; k <= radius; ++k) {
                if (this.m_214202_(random, j, y, k, radius, large)) continue;
                mutablePos.m_122154_((Vec3i)pos, j, y, k);
                BlightwillowFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutablePos);
            }
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean m_214203_(RandomSource rand, int x, int y, int z, int radius, boolean remove) {
        if (radius == 0) {
            return remove;
        }
        if (y == 0 || y == -6) {
            return x + z >= radius * 2 && rand.m_188501_() < 0.75f;
        }
        if (y == -1) {
            return x + z >= radius * 2 && rand.m_188501_() < 0.9f;
        }
        if (y == -5) {
            return x + z >= radius * 2 && rand.m_188499_();
        }
        return false;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)ReduxFoliagePlacers.BLIGHTWILLOW.get();
    }
}

