/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.zepalesque.redux.mixin.common.world.ChunkAccessAccessor;

public class SurfaceRuleLakeFeature
extends Feature<Config> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public SurfaceRuleLakeFeature(Codec<Config> p_66259_) {
        super(p_66259_);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int i2;
        int k1;
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource random = context.m_225041_();
        Config config = (Config)context.m_159778_();
        if (blockpos.m_123342_() <= worldgenlevel.m_141937_() + 4) {
            return false;
        }
        blockpos = blockpos.m_6625_(4);
        boolean[] aboolean = new boolean[2048];
        int i = random.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.m_188500_() * 6.0 + 3.0;
            double d1 = random.m_188500_() * 4.0 + 2.0;
            double d2 = random.m_188500_() * 6.0 + 3.0;
            double d3 = random.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState blockstate1 = config.fluid().m_213972_(random, blockpos);
        for (k1 = 0; k1 < 16; ++k1) {
            for (int i22 = 0; i22 < 16; ++i22) {
                for (int j3 = 0; j3 < 8; ++j3) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + i22) * 8 + j3] && (k1 < 15 && aboolean[((k1 + 1) * 16 + i22) * 8 + j3] || k1 > 0 && aboolean[((k1 - 1) * 16 + i22) * 8 + j3] || i22 < 15 && aboolean[(k1 * 16 + i22 + 1) * 8 + j3] || i22 > 0 && aboolean[(k1 * 16 + (i22 - 1)) * 8 + j3] || j3 < 7 && aboolean[(k1 * 16 + i22) * 8 + j3 + 1] || j3 > 0 && aboolean[(k1 * 16 + i22) * 8 + (j3 - 1)]);
                    if (!flag) continue;
                    BlockState testState = worldgenlevel.m_8055_(blockpos.m_7918_(k1, j3, i22));
                    if (j3 >= 4 && testState.m_278721_()) {
                        return false;
                    }
                    if (j3 >= 4 || testState.m_280296_() || worldgenlevel.m_8055_(blockpos.m_7918_(k1, j3, i22)) == blockstate1) continue;
                    return false;
                }
            }
        }
        for (k1 = 0; k1 < 16; ++k1) {
            for (int i23 = 0; i23 < 16; ++i23) {
                for (int j3 = 0; j3 < 8; ++j3) {
                    BlockPos blockpos2;
                    if (!aboolean[(k1 * 16 + i23) * 8 + j3] || !this.canReplaceBlock(worldgenlevel.m_8055_(blockpos2 = blockpos.m_7918_(k1, j3, i23)))) continue;
                    boolean flag1 = j3 >= 4;
                    worldgenlevel.m_7731_(blockpos2, flag1 ? AIR : blockstate1, 2);
                    if (!flag1) continue;
                    worldgenlevel.m_186460_(blockpos2, AIR.m_60734_(), 0);
                    this.m_159739_(worldgenlevel, blockpos2);
                }
            }
        }
        for (i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    ServerChunkCache serverChunkCache;
                    ChunkGenerator d4;
                    ChunkSource chunkSource;
                    BlockPos blockpos3;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || !SurfaceRuleLakeFeature.m_159759_((BlockState)worldgenlevel.m_8055_(blockpos3 = blockpos.m_7918_(i2, j4 - 1, j3))) || worldgenlevel.m_45517_(LightLayer.SKY, blockpos.m_7918_(i2, j4, j3)) <= 0 || !((chunkSource = context.m_159774_().m_7726_()) instanceof ServerChunkCache) || !((d4 = (serverChunkCache = (ServerChunkCache)chunkSource).m_8481_()) instanceof NoiseBasedChunkGenerator)) continue;
                    NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)d4;
                    NoiseGeneratorSettings settingsHolder = (NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().get();
                    SurfaceRules.RuleSource surfaceRule = settingsHolder.f_188871_();
                    ChunkAccess chunkAccess = context.m_159774_().m_46865_(blockpos3);
                    NoiseChunk noisechunk = ((ChunkAccessAccessor)chunkAccess).getNoiseChunk();
                    if (noisechunk == null) continue;
                    CarvingContext carvingcontext = new CarvingContext(noiseBasedChunkGenerator, context.m_159774_().m_9598_(), chunkAccess.m_183618_(), noisechunk, serverChunkCache.m_214994_(), surfaceRule);
                    Optional state = carvingcontext.m_190646_(arg_0 -> ((BiomeManager)context.m_159774_().m_7062_()).m_204214_(arg_0), chunkAccess, blockpos3, false);
                    state.ifPresent(blockState -> worldgenlevel.m_7731_(blockpos3, blockState, 2));
                }
            }
        }
        if (blockstate1.m_60819_().m_205070_(FluidTags.f_13131_)) {
            for (i2 = 0; i2 < 16; ++i2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos2 = blockpos.m_7918_(i2, 4, j3);
                    if (!((Biome)worldgenlevel.m_204166_(blockpos2).m_203334_()).m_47480_((LevelReader)worldgenlevel, blockpos2, false) || !this.canReplaceBlock(worldgenlevel.m_8055_(blockpos2))) continue;
                    worldgenlevel.m_7731_(blockpos2, Blocks.f_50126_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState p_190952_) {
        return !p_190952_.m_204336_(BlockTags.f_144287_);
    }

    public record Config(BlockStateProvider fluid) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(p_190962_ -> p_190962_.group((App)BlockStateProvider.f_68747_.fieldOf("fluid").forGetter(Config::fluid)).apply((Applicative)p_190962_, Config::new));
    }
}

