/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.math;

import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class MathUtil {
    public static int rgb(int r, int g, int b) {
        return FastColor.ARGB32.m_13660_((int)0, (int)r, (int)g, (int)b);
    }

    public static float returnZeroWhenNegative(float ret, float test) {
        return test <= 0.0f ? 0.0f : ret;
    }

    public static double clampedInverp(double delta, double min, double max) {
        return Mth.m_14008_((double)Mth.m_14112_((double)delta, (double)min, (double)max), (double)min, (double)max);
    }

    public static float clampedInverp(float delta, float min, float max) {
        return Mth.m_14036_((float)Mth.m_184655_((float)delta, (float)min, (float)max), (float)min, (float)max);
    }

    public static int clampedLerpInt(float delta, int min, int max) {
        return Mth.m_14045_((int)Mth.m_269140_((float)delta, (int)min, (int)max), (int)min, (int)max);
    }

    public static int toNearestEven(float f) {
        int floored = Mth.m_14143_((float)f);
        return floored % 2 == 0 ? floored : floored + 1;
    }

    public static int toNearestEven(double d) {
        int floored = Mth.m_14107_((double)d);
        return floored % 2 == 0 ? floored : floored + 1;
    }

    public static float breathe(Entity entity, float partialTicks) {
        return MathUtil.breathe(entity, partialTicks, 1.0f, 1.0f, 0.0f);
    }

    public static float breatheOffs(Entity entity, float partialTicks, float offset) {
        return MathUtil.breathe(entity, partialTicks, 1.0f, 1.0f, offset);
    }

    public static float breathe(Entity entity, float partialTicks, float amplitude, float frequency, float offset) {
        return MathUtil.breatheBase(entity, partialTicks, 0.05f * amplitude, 0.075f * frequency, 0.8333f + offset * (float)Math.PI);
    }

    public static float breatheBase(Entity entity, float partialTicks, float amplitude, float frequency, float offset) {
        float age = (float)entity.f_19797_ + partialTicks;
        return Mth.m_14031_((float)(age * frequency + (float)(Math.PI * (double)offset))) * amplitude;
    }

    public static float staggeredBreathe(Entity entity, float partialTicks) {
        return MathUtil.staggeredBreathe(entity, partialTicks, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f);
    }

    public static float staggeredBreathe(Entity entity, float partialTicks, float amplitude, float frequency, float offset, float staggerIndex, float staggerAmount) {
        return MathUtil.staggeredBreatheBase(entity, partialTicks, 0.1f * amplitude, 0.05f * frequency, 0.8333f + offset * (float)Math.PI, 7.3f * staggerIndex, 0.15f * staggerAmount);
    }

    public static float staggeredBreatheBase(@NotNull Entity entity, float partialTicks, float amplitude, float frequency, float offset, float staggerIndex, float staggerAmount) {
        float age = (float)entity.f_19797_ + partialTicks;
        return (1.0f - staggerAmount) * (Mth.m_14031_((float)(age * frequency + (float)(Math.PI * (double)offset))) * amplitude) + staggerAmount * (Mth.m_14031_((float)(age * frequency * staggerIndex + (float)(Math.PI * (double)offset))) * amplitude);
    }

    public static float cockatriceBreathing(@NotNull Entity entity, float partialTicks, float frequency) {
        float age = (float)entity.f_19797_ + partialTicks;
        return (float)(0.65 * (double)Mth.m_14031_((float)(age * frequency)) + 0.03 * (double)Mth.m_14031_((float)(age * frequency * 13.0f)) + 0.012 * (double)Mth.m_14031_((float)(age * frequency * 4.1f)) + 0.014 * (double)Mth.m_14031_((float)(age * frequency * 27.0f)));
    }

    public static float cockatriceBreathing(@NotNull Entity entity, float partialTicks) {
        return MathUtil.cockatriceBreathing(entity, partialTicks, 0.065f) * 0.1f;
    }

    public static float animCos(float pValue) {
        return Mth.m_14089_((float)((float)((double)(2.0f * pValue) + Math.PI))) - 1.0f;
    }

    public static float costrp(float progress, float start, float end) {
        return (-Mth.m_14089_((float)((float)(Math.PI * (double)progress))) + 1.0f) * 0.5f * (end - start) + start;
    }

    public static double costrp(double progress, double start, double end) {
        return (double)((-Mth.m_14089_((float)((float)(Math.PI * progress))) + 1.0f) * 0.5f) * (end - start) + start;
    }

    public static float cerp(float progress, float start, float end, float curvedness) {
        return progress * (1.0f - curvedness) + MathUtil.costrp(progress, start, end) * curvedness;
    }

    public static double cerp(double progress, double start, double end, double curvedness) {
        return progress * (1.0 - curvedness) + MathUtil.costrp(progress, start, end) * curvedness;
    }

    public static double nextDouble(double bounds, RandomSource random) {
        return random.m_188500_() * bounds;
    }

    public static float nextFloat(float bounds, RandomSource random) {
        return random.m_188501_() * bounds;
    }

    public static double nextDouble(double min, double max, RandomSource random) {
        return min + random.m_188500_() * (max - min);
    }

    public static float nextFloat(float min, float max, RandomSource random) {
        return min + random.m_188501_() * (max - min);
    }
}

