/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.ItemStackConstructor;
import net.zepalesque.redux.recipe.StackingRecipe;
import net.zepalesque.redux.util.AssertionUtil;
import org.slf4j.Logger;

public class StackingRecipeSerializer<T extends StackingRecipe>
implements RecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public StackingRecipeSerializer(CookieBaker<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        Optional sound;
        Optional additional;
        JsonOps ops = JsonOps.INSTANCE;
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
        }
        JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElement);
        AssertionUtil.checkState(json.has("result"), () -> new JsonSyntaxException("Missing result, expected to find a string or object"));
        AssertionUtil.checkState(json.get("result").isJsonObject(), () -> new JsonSyntaxException("Expected result to be object"));
        JsonObject resultObject = json.getAsJsonObject("result");
        ItemStackConstructor result = (ItemStackConstructor)ItemStackConstructor.CODEC.parse((DynamicOps)ops, (Object)resultObject).resultOrPartial(arg_0 -> ((Logger)Redux.LOGGER).error(arg_0)).orElseThrow();
        if (json.has("additional") && json.get("additional").isJsonObject()) {
            JsonObject additionalObject = json.getAsJsonObject("additional");
            additional = CompoundTag.f_128325_.parse((DynamicOps)ops, (Object)additionalObject).resultOrPartial(arg_0 -> ((Logger)Redux.LOGGER).error(arg_0));
        } else {
            additional = Optional.empty();
        }
        if (json.has("sound")) {
            JsonElement soundObject = json.get("sound");
            sound = BuiltInRegistries.f_256894_.m_6612_(new ResourceLocation(soundObject.getAsString()));
        } else {
            sound = Optional.empty();
        }
        return this.factory.create(id, ingredient, result, additional, sound);
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStackConstructor result = (ItemStackConstructor)buffer.m_271872_(ItemStackConstructor.CODEC);
        Optional additional = buffer.m_236860_(FriendlyByteBuf::m_130260_);
        Optional<SoundEvent> sound = buffer.m_236860_(FriendlyByteBuf::m_130281_).flatMap(arg_0 -> ((Registry)BuiltInRegistries.f_256894_).m_6612_(arg_0));
        return this.factory.create(id, ingredient, result, additional, sound);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        recipe.getIngredient().m_43923_(buffer);
        buffer.m_272073_(ItemStackConstructor.CODEC, (Object)recipe.getResult());
        buffer.m_236835_(recipe.getAdditionalData(), FriendlyByteBuf::m_130079_);
        buffer.m_236835_(recipe.getSound().map(arg_0 -> ((Registry)BuiltInRegistries.f_256894_).m_7981_(arg_0)), FriendlyByteBuf::m_130085_);
    }

    public static interface CookieBaker<T extends StackingRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, ItemStackConstructor var3, Optional<CompoundTag> var4, Optional<SoundEvent> var5);
    }
}

