/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.entity;

import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.entity.monster.Blightbunny;
import net.zepalesque.redux.entity.passive.Mykapod;
import net.zepalesque.redux.entity.passive.Shimmercow;
import net.zepalesque.redux.entity.projectile.Ember;
import net.zepalesque.redux.entity.projectile.InfusedVeridiumDart;
import net.zepalesque.redux.entity.projectile.ThrownSpear;
import net.zepalesque.redux.entity.projectile.VeridiumDart;
import net.zepalesque.redux.entity.projectile.VolatileFireCrystal;
import net.zepalesque.redux.entity.util.EntitySpawner;

@Mod.EventBusSubscriber(modid="aether_redux", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxEntityTypes {
    public static final Collection<RegistryObject<? extends EntityType<? extends Entity>>> SPAWNERS = new ArrayList<RegistryObject<? extends EntityType<? extends Entity>>>();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"aether_redux");
    public static final RegistryObject<EntityType<VolatileFireCrystal>> VOLATILE_FIRE_CRYSTAL = ENTITY_TYPES.register("volatile_fire_crystal", () -> EntityType.Builder.m_20704_(VolatileFireCrystal::new, (MobCategory)MobCategory.MISC).m_20699_(0.85f, 0.85f).m_20702_(4).m_20717_(10).m_20719_().m_20712_("fire_crystal"));
    public static final RegistryObject<EntityType<Swet>> VANILLA_SWET = ENTITY_TYPES.register("vanilla_swet", () -> EntityType.Builder.m_20704_(Swet::new, (MobCategory)AetherMobCategory.AETHER_SURFACE_MONSTER).m_20699_(0.9f, 0.95f).m_20702_(10).m_20712_("vanilla_swet"));
    public static final RegistryObject<EntityType<InfusedVeridiumDart>> INFUSED_VERIDIUM_DART = ENTITY_TYPES.register("infused_veridium_dart", () -> EntityType.Builder.m_20704_(InfusedVeridiumDart::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("infused_veridium_dart"));
    public static final RegistryObject<EntityType<VeridiumDart>> VERIDIUM_DART = ENTITY_TYPES.register("veridium_dart", () -> EntityType.Builder.m_20704_(VeridiumDart::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("veridium_dart"));
    public static final RegistryObject<EntityType<ThrownSpear>> THROWN_SPEAR = ENTITY_TYPES.register("thrown_spear", () -> EntityType.Builder.m_20704_(ThrownSpear::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("thrown_spear"));
    public static final RegistryObject<EntityType<Ember>> EMBER = ENTITY_TYPES.register("ember", () -> EntityType.Builder.m_20704_(Ember::new, (MobCategory)MobCategory.MISC).m_20699_(0.125f, 0.125f).m_20702_(4).m_20717_(20).m_20712_("ember"));
    public static final RegistryObject<EntityType<Shimmercow>> SHIMMERCOW = ENTITY_TYPES.register("shimmercow", () -> EntityType.Builder.m_20704_(Shimmercow::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.125f, 1.625f).m_20702_(10).m_20712_("shimmercow"));
    public static final RegistryObject<EntityType<Mykapod>> MYKAPOD = ENTITY_TYPES.register("mykapod", () -> EntityType.Builder.m_20704_(Mykapod::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.35f, 0.35f).m_20702_(10).m_20712_("mykapod"));
    public static final RegistryObject<EntityType<Blightbunny>> BLIGHTBUNNY = ENTITY_TYPES.register("blightbunny", () -> EntityType.Builder.m_20704_(Blightbunny::new, (MobCategory)AetherMobCategory.AETHER_DARKNESS_MONSTER).m_20699_(0.6f, 0.5f).m_20702_(10).m_20712_("blightbunny"));
    public static final RegistryObject<EntityType<EntitySpawner>> COCKATRICE_SPAWNER = ReduxEntityTypes.spawner(ENTITY_TYPES.register("cockatrice_spawner", () -> EntityType.Builder.m_20704_(EntitySpawner.fabricate((Supplier<? extends EntityType<? extends Mob>>)AetherEntityTypes.COCKATRICE), (MobCategory)MobCategory.CREATURE).m_20699_(0.95f, 2.15f).m_20702_(4).m_20717_(5).m_20719_().m_20712_("cockatrice_spawner")));
    public static final RegistryObject<EntityType<EntitySpawner>> BLIGHTBUNNY_SPAWNER = ReduxEntityTypes.spawner(ENTITY_TYPES.register("blightbunny_spawner", () -> EntityType.Builder.m_20704_(EntitySpawner.fabricate(BLIGHTBUNNY), (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.5f).m_20702_(4).m_20717_(5).m_20719_().m_20712_("blightbunny_spawner")));

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)VANILLA_SWET.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Swet::checkSwetSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SHIMMERCOW.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AetherAnimal::checkAetherAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)MYKAPOD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AetherAnimal::checkAetherAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)BLIGHTBUNNY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Blightbunny::checkBunnySpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)BLIGHTBUNNY_SPAWNER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySpawner::checkEntitySpawnerSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)COCKATRICE_SPAWNER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (e, l, s, p, r) -> (Boolean)ReduxConfig.COMMON.cockatrice_burn_in_daylight.get() == false && EntitySpawner.checkEntitySpawnerSpawnRules((EntityType<? extends EntitySpawner>)e, (LevelAccessor)l, s, p, r), SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VANILLA_SWET.get(), Swet.m_21552_().m_22265_());
        event.put((EntityType)SHIMMERCOW.get(), Shimmercow.m_21552_().m_22265_());
        event.put((EntityType)MYKAPOD.get(), Mykapod.createAttributes().m_22265_());
        event.put((EntityType)BLIGHTBUNNY.get(), Blightbunny.createAttributes().m_22265_());
        event.put((EntityType)BLIGHTBUNNY_SPAWNER.get(), EntitySpawner.createAttributes().m_22265_());
        event.put((EntityType)COCKATRICE_SPAWNER.get(), EntitySpawner.createAttributes().m_22265_());
    }

    public static <E extends Entity, R extends RegistryObject<EntityType<E>>> R spawner(R type) {
        SPAWNERS.add(type);
        return type;
    }
}

